/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.embeddings;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public enum VoyageAIEmbeddingType {
    FLOAT(DenseVectorFieldMapper.ElementType.FLOAT, "float"),
    INT8(DenseVectorFieldMapper.ElementType.BYTE, "int8"),
    BYTE(DenseVectorFieldMapper.ElementType.BYTE, "int8"),
    BIT(DenseVectorFieldMapper.ElementType.BIT, "binary"),
    BINARY(DenseVectorFieldMapper.ElementType.BIT, "binary");

    private static final Map<DenseVectorFieldMapper.ElementType, VoyageAIEmbeddingType> ELEMENT_TYPE_TO_VOYAGE_EMBEDDING;
    static final EnumSet<DenseVectorFieldMapper.ElementType> SUPPORTED_ELEMENT_TYPES;
    private final DenseVectorFieldMapper.ElementType elementType;
    private final String requestString;

    private VoyageAIEmbeddingType(DenseVectorFieldMapper.ElementType elementType, String requestString) {
        this.elementType = elementType;
        this.requestString = requestString;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toRequestString() {
        return this.requestString;
    }

    public static String toLowerCase(VoyageAIEmbeddingType type) {
        return type.toString().toLowerCase(Locale.ROOT);
    }

    public static VoyageAIEmbeddingType fromString(String name) {
        return VoyageAIEmbeddingType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static VoyageAIEmbeddingType fromElementType(DenseVectorFieldMapper.ElementType elementType) {
        VoyageAIEmbeddingType embedding = ELEMENT_TYPE_TO_VOYAGE_EMBEDDING.get(elementType);
        if (embedding == null) {
            Object[] validElementTypes = (String[])SUPPORTED_ELEMENT_TYPES.stream().map(value -> value.toString().toLowerCase(Locale.ROOT)).toArray(String[]::new);
            Arrays.sort(validElementTypes);
            throw new IllegalArgumentException(Strings.format((String)"Element type [%s] does not map to a VoyageAI embedding value, must be one of [%s]", (Object[])new Object[]{elementType, String.join((CharSequence)", ", (CharSequence[])validElementTypes)}));
        }
        return embedding;
    }

    public DenseVectorFieldMapper.ElementType toElementType() {
        return this.elementType;
    }

    static {
        ELEMENT_TYPE_TO_VOYAGE_EMBEDDING = Map.of(DenseVectorFieldMapper.ElementType.FLOAT, FLOAT, DenseVectorFieldMapper.ElementType.BYTE, BYTE, DenseVectorFieldMapper.ElementType.BIT, BIT);
        SUPPORTED_ELEMENT_TYPES = EnumSet.copyOf(ELEMENT_TYPE_TO_VOYAGE_EMBEDDING.keySet());
    }

    private static final class RequestConstants {
        private static final String FLOAT = "float";
        private static final String INT8 = "int8";
        private static final String BINARY = "binary";

        private RequestConstants() {
        }
    }
}

