/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googleaistudio;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.services.googleaistudio.GoogleAiStudioRequestManager;
import org.elasticsearch.xpack.inference.services.googleaistudio.GoogleAiStudioResponseHandler;
import org.elasticsearch.xpack.inference.services.googleaistudio.embeddings.GoogleAiStudioEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.googleaistudio.request.GoogleAiStudioEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.googleaistudio.response.GoogleAiStudioEmbeddingsResponseEntity;

public class GoogleAiStudioEmbeddingsRequestManager
extends GoogleAiStudioRequestManager {
    private static final Logger logger = LogManager.getLogger(GoogleAiStudioEmbeddingsRequestManager.class);
    private static final ResponseHandler HANDLER = GoogleAiStudioEmbeddingsRequestManager.createEmbeddingsHandler();
    private final GoogleAiStudioEmbeddingsModel model;
    private final Truncator truncator;

    private static ResponseHandler createEmbeddingsHandler() {
        return new GoogleAiStudioResponseHandler("google ai studio embeddings", GoogleAiStudioEmbeddingsResponseEntity::fromResponse);
    }

    public GoogleAiStudioEmbeddingsRequestManager(GoogleAiStudioEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        super(threadPool, model);
        this.model = Objects.requireNonNull(model);
        this.truncator = Objects.requireNonNull(truncator);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        EmbeddingsInput input = inferenceInputs.castTo(EmbeddingsInput.class);
        List<String> docsInput = input.getInputs();
        InputType inputType = input.getInputType();
        Truncator.TruncationResult truncatedInput = Truncator.truncate(docsInput, this.model.getServiceSettings().maxInputTokens());
        GoogleAiStudioEmbeddingsRequest request = new GoogleAiStudioEmbeddingsRequest(this.truncator, truncatedInput, inputType, this.model);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }
}

