/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;

public class CustomResponseHandler
extends BaseResponseHandler {
    static final Function<HttpResult, ErrorResponse> ERROR_PARSER = httpResult -> {
        try {
            return new ErrorResponse(new String(httpResult.body(), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return new ErrorResponse(Strings.format((String)"Failed to parse error response body: %s", (Object[])new Object[]{e.getMessage()}));
        }
    };

    public CustomResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, ERROR_PARSER);
    }

    @Override
    public InferenceServiceResults parseResult(Request request, HttpResult result) throws RetryException {
        try {
            return this.parseFunction.apply(request, result);
        }
        catch (Exception e) {
            throw new RetryException(false, new ElasticsearchStatusException("Failed to parse custom model response, please check that the response parser path matches the response format.", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
        }
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        if (statusCode >= 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw new RetryException(true, this.buildError("Received a rate limit status code", request, result));
        }
        if (statusCode == 401) {
            throw new RetryException(false, this.buildError("Received an authentication error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }
}

