/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceExtension;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.node.PluginComponentBinding;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.plugins.internal.InternalSearchPlugin;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestHeaderDefinition;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.inference.action.DeleteInferenceEndpointAction;
import org.elasticsearch.xpack.core.inference.action.GetInferenceDiagnosticsAction;
import org.elasticsearch.xpack.core.inference.action.GetInferenceModelAction;
import org.elasticsearch.xpack.core.inference.action.GetInferenceServicesAction;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.core.inference.action.InferenceActionProxy;
import org.elasticsearch.xpack.core.inference.action.PutInferenceModelAction;
import org.elasticsearch.xpack.core.inference.action.UnifiedCompletionAction;
import org.elasticsearch.xpack.core.inference.action.UpdateInferenceModelAction;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.inference.InferenceIndex;
import org.elasticsearch.xpack.inference.InferenceNamedWriteablesProvider;
import org.elasticsearch.xpack.inference.InferenceSecretsIndex;
import org.elasticsearch.xpack.inference.action.TransportDeleteInferenceEndpointAction;
import org.elasticsearch.xpack.inference.action.TransportGetInferenceDiagnosticsAction;
import org.elasticsearch.xpack.inference.action.TransportGetInferenceModelAction;
import org.elasticsearch.xpack.inference.action.TransportGetInferenceServicesAction;
import org.elasticsearch.xpack.inference.action.TransportInferenceAction;
import org.elasticsearch.xpack.inference.action.TransportInferenceActionProxy;
import org.elasticsearch.xpack.inference.action.TransportInferenceUsageAction;
import org.elasticsearch.xpack.inference.action.TransportPutInferenceModelAction;
import org.elasticsearch.xpack.inference.action.TransportUnifiedCompletionInferenceAction;
import org.elasticsearch.xpack.inference.action.TransportUpdateInferenceModelAction;
import org.elasticsearch.xpack.inference.action.filter.ShardBulkInferenceActionFilter;
import org.elasticsearch.xpack.inference.common.InferenceAPIClusterAwareRateLimitingFeature;
import org.elasticsearch.xpack.inference.common.InferenceServiceNodeLocalRateLimitCalculator;
import org.elasticsearch.xpack.inference.common.InferenceServiceRateLimitCalculator;
import org.elasticsearch.xpack.inference.common.NoopNodeLocalRateLimitCalculator;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.http.HttpClientManager;
import org.elasticsearch.xpack.inference.external.http.HttpSettings;
import org.elasticsearch.xpack.inference.external.http.retry.RetrySettings;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.RequestExecutorServiceSettings;
import org.elasticsearch.xpack.inference.highlight.SemanticTextHighlighter;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;
import org.elasticsearch.xpack.inference.mapper.OffsetSourceFieldMapper;
import org.elasticsearch.xpack.inference.mapper.SemanticInferenceMetadataFieldsMapper;
import org.elasticsearch.xpack.inference.mapper.SemanticTextFieldMapper;
import org.elasticsearch.xpack.inference.queries.SemanticKnnVectorQueryRewriteInterceptor;
import org.elasticsearch.xpack.inference.queries.SemanticMatchQueryRewriteInterceptor;
import org.elasticsearch.xpack.inference.queries.SemanticQueryBuilder;
import org.elasticsearch.xpack.inference.queries.SemanticSparseVectorQueryRewriteInterceptor;
import org.elasticsearch.xpack.inference.rank.random.RandomRankBuilder;
import org.elasticsearch.xpack.inference.rank.random.RandomRankRetrieverBuilder;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankBuilder;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankDoc;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankRetrieverBuilder;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;
import org.elasticsearch.xpack.inference.registry.ModelRegistryMetadata;
import org.elasticsearch.xpack.inference.rest.RestDeleteInferenceEndpointAction;
import org.elasticsearch.xpack.inference.rest.RestGetInferenceDiagnosticsAction;
import org.elasticsearch.xpack.inference.rest.RestGetInferenceModelAction;
import org.elasticsearch.xpack.inference.rest.RestGetInferenceServicesAction;
import org.elasticsearch.xpack.inference.rest.RestInferenceAction;
import org.elasticsearch.xpack.inference.rest.RestPutInferenceModelAction;
import org.elasticsearch.xpack.inference.rest.RestStreamInferenceAction;
import org.elasticsearch.xpack.inference.rest.RestUpdateInferenceModelAction;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchService;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockService;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockRequestSender;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicService;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioService;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiService;
import org.elasticsearch.xpack.inference.services.cohere.CohereService;
import org.elasticsearch.xpack.inference.services.custom.CustomService;
import org.elasticsearch.xpack.inference.services.deepseek.DeepSeekService;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceService;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.authorization.ElasticInferenceServiceAuthorizationRequestHandler;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalService;
import org.elasticsearch.xpack.inference.services.googleaistudio.GoogleAiStudioService;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiService;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceService;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserService;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxService;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIService;
import org.elasticsearch.xpack.inference.services.mistral.MistralService;
import org.elasticsearch.xpack.inference.services.openai.OpenAiService;
import org.elasticsearch.xpack.inference.services.sagemaker.SageMakerClient;
import org.elasticsearch.xpack.inference.services.sagemaker.SageMakerService;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerConfiguration;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerModelBuilder;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerSchemas;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIService;
import org.elasticsearch.xpack.inference.telemetry.InferenceStats;

public class InferencePlugin
extends Plugin
implements ActionPlugin,
ExtensiblePlugin,
SystemIndexPlugin,
MapperPlugin,
SearchPlugin,
InternalSearchPlugin,
ClusterPlugin {
    public static final Setting<Boolean> SKIP_VALIDATE_AND_START = Setting.boolSetting((String)"xpack.inference.skip_validate_and_start", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final LicensedFeature.Momentary INFERENCE_API_FEATURE = LicensedFeature.momentary((String)"inference", (String)"api", (License.OperationMode)License.OperationMode.ENTERPRISE);
    public static final String X_ELASTIC_PRODUCT_USE_CASE_HTTP_HEADER = "X-elastic-product-use-case";
    public static final String NAME = "inference";
    public static final String UTILITY_THREAD_POOL_NAME = "inference_utility";
    private static final Logger log = LogManager.getLogger(InferencePlugin.class);
    private final Settings settings;
    private final SetOnce<HttpRequestSender.Factory> httpFactory = new SetOnce();
    private final SetOnce<AmazonBedrockRequestSender.Factory> amazonBedrockFactory = new SetOnce();
    private final SetOnce<HttpRequestSender.Factory> elasicInferenceServiceFactory = new SetOnce();
    private final SetOnce<ServiceComponents> serviceComponents = new SetOnce();
    private final SetOnce<ThreadPool> threadPoolSetOnce = new SetOnce();
    private final SetOnce<ElasticInferenceServiceComponents> elasticInferenceServiceComponents = new SetOnce();
    private final SetOnce<InferenceServiceRegistry> inferenceServiceRegistry = new SetOnce();
    private final SetOnce<ShardBulkInferenceActionFilter> shardBulkInferenceActionFilter = new SetOnce();
    private final SetOnce<ModelRegistry> modelRegistry = new SetOnce();
    private List<InferenceServiceExtension> inferenceServiceExtensions;

    public InferencePlugin(Settings settings) {
        this.settings = settings;
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)InferenceAction.INSTANCE, TransportInferenceAction.class), new ActionPlugin.ActionHandler((ActionType)InferenceActionProxy.INSTANCE, TransportInferenceActionProxy.class), new ActionPlugin.ActionHandler((ActionType)GetInferenceModelAction.INSTANCE, TransportGetInferenceModelAction.class), new ActionPlugin.ActionHandler((ActionType)PutInferenceModelAction.INSTANCE, TransportPutInferenceModelAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateInferenceModelAction.INSTANCE, TransportUpdateInferenceModelAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteInferenceEndpointAction.INSTANCE, TransportDeleteInferenceEndpointAction.class), new ActionPlugin.ActionHandler(XPackUsageFeatureAction.INFERENCE, TransportInferenceUsageAction.class), new ActionPlugin.ActionHandler((ActionType)GetInferenceDiagnosticsAction.INSTANCE, TransportGetInferenceDiagnosticsAction.class), new ActionPlugin.ActionHandler((ActionType)GetInferenceServicesAction.INSTANCE, TransportGetInferenceServicesAction.class), new ActionPlugin.ActionHandler((ActionType)UnifiedCompletionAction.INSTANCE, TransportUnifiedCompletionInferenceAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return List.of(new RestInferenceAction(), new RestStreamInferenceAction(this.threadPoolSetOnce), new RestGetInferenceModelAction(), new RestPutInferenceModelAction(), new RestUpdateInferenceModelAction(), new RestDeleteInferenceEndpointAction(), new RestGetInferenceDiagnosticsAction(), new RestGetInferenceServicesAction());
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ArrayList<Object> components = new ArrayList<Object>();
        ThrottlerManager throttlerManager = new ThrottlerManager(this.settings, services.threadPool());
        throttlerManager.init(services.clusterService());
        Truncator truncator = new Truncator(this.settings, services.clusterService());
        this.serviceComponents.set((Object)new ServiceComponents(services.threadPool(), throttlerManager, this.settings, truncator));
        this.threadPoolSetOnce.set((Object)services.threadPool());
        HttpClientManager httpClientManager = HttpClientManager.create(this.settings, services.threadPool(), services.clusterService(), throttlerManager);
        HttpRequestSender.Factory httpRequestSenderFactory = new HttpRequestSender.Factory((ServiceComponents)this.serviceComponents.get(), httpClientManager, services.clusterService());
        this.httpFactory.set((Object)httpRequestSenderFactory);
        AmazonBedrockRequestSender.Factory amazonBedrockRequestSenderFactory = new AmazonBedrockRequestSender.Factory((ServiceComponents)this.serviceComponents.get(), services.clusterService());
        this.amazonBedrockFactory.set((Object)amazonBedrockRequestSenderFactory);
        this.modelRegistry.set((Object)new ModelRegistry(services.clusterService(), services.client()));
        services.clusterService().addListener((ClusterStateListener)this.modelRegistry.get());
        if (this.inferenceServiceExtensions == null) {
            this.inferenceServiceExtensions = new ArrayList<InferenceServiceExtension>();
        }
        ArrayList<InferenceServiceExtension> inferenceServices = new ArrayList<InferenceServiceExtension>(this.inferenceServiceExtensions);
        inferenceServices.add(this::getInferenceServiceFactories);
        ElasticInferenceServiceSettings inferenceServiceSettings = new ElasticInferenceServiceSettings(this.settings);
        inferenceServiceSettings.init(services.clusterService());
        HttpClientManager elasticInferenceServiceHttpClientManager = HttpClientManager.create(this.settings, services.threadPool(), services.clusterService(), throttlerManager, this.getSslService(), inferenceServiceSettings.getConnectionTtl());
        HttpRequestSender.Factory elasticInferenceServiceRequestSenderFactory = new HttpRequestSender.Factory((ServiceComponents)this.serviceComponents.get(), elasticInferenceServiceHttpClientManager, services.clusterService());
        this.elasicInferenceServiceFactory.set((Object)elasticInferenceServiceRequestSenderFactory);
        ElasticInferenceServiceAuthorizationRequestHandler authorizationHandler = new ElasticInferenceServiceAuthorizationRequestHandler(inferenceServiceSettings.getElasticInferenceServiceUrl(), services.threadPool());
        SageMakerSchemas sageMakerSchemas = new SageMakerSchemas();
        LazyInitializable sageMakerConfigurations = new LazyInitializable((CheckedSupplier)new SageMakerConfiguration(sageMakerSchemas));
        inferenceServices.add(() -> List.of(context -> new ElasticInferenceService((HttpRequestSender.Factory)this.elasicInferenceServiceFactory.get(), (ServiceComponents)this.serviceComponents.get(), inferenceServiceSettings, (ModelRegistry)this.modelRegistry.get(), authorizationHandler), context -> new SageMakerService(new SageMakerModelBuilder(sageMakerSchemas), new SageMakerClient(new SageMakerClient.Factory(new HttpSettings(this.settings, services.clusterService())), services.threadPool()), sageMakerSchemas, services.threadPool(), (CheckedSupplier<Map<String, SettingsConfiguration>, RuntimeException>)((CheckedSupplier)() -> ((LazyInitializable)sageMakerConfigurations).getOrCompute()))));
        InferenceServiceExtension.InferenceServiceFactoryContext factoryContext = new InferenceServiceExtension.InferenceServiceFactoryContext(services.client(), services.threadPool(), services.clusterService(), this.settings);
        InferenceServiceRegistry serviceRegistry = new InferenceServiceRegistry(inferenceServices, factoryContext);
        serviceRegistry.init(services.client());
        for (InferenceService service : serviceRegistry.getServices().values()) {
            service.defaultConfigIds().forEach(((ModelRegistry)this.modelRegistry.get())::addDefaultIds);
        }
        this.inferenceServiceRegistry.set((Object)serviceRegistry);
        MeterRegistry meterRegistry = services.telemetryProvider().getMeterRegistry();
        InferenceStats inferenceStats = InferenceStats.create(meterRegistry);
        PluginComponentBinding inferenceStatsBinding = new PluginComponentBinding(InferenceStats.class, (Object)inferenceStats);
        ShardBulkInferenceActionFilter actionFilter = new ShardBulkInferenceActionFilter(services.clusterService(), serviceRegistry, (ModelRegistry)this.modelRegistry.get(), this.getLicenseState(), services.indexingPressure(), inferenceStats);
        this.shardBulkInferenceActionFilter.set((Object)actionFilter);
        components.add(serviceRegistry);
        components.add(this.modelRegistry.get());
        components.add(httpClientManager);
        components.add(inferenceStatsBinding);
        InferenceServiceRateLimitCalculator calculator = InferenceAPIClusterAwareRateLimitingFeature.INFERENCE_API_CLUSTER_AWARE_RATE_LIMITING_FEATURE_FLAG ? new InferenceServiceNodeLocalRateLimitCalculator(services.clusterService(), serviceRegistry) : new NoopNodeLocalRateLimitCalculator();
        components.add(new PluginComponentBinding(InferenceServiceRateLimitCalculator.class, (Object)calculator));
        return components;
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        this.inferenceServiceExtensions = loader.loadExtensions(InferenceServiceExtension.class);
    }

    public List<InferenceServiceExtension.Factory> getInferenceServiceFactories() {
        return List.of(context -> new HuggingFaceElserService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new HuggingFaceService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new OpenAiService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new CohereService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new AzureOpenAiService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new AzureAiStudioService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new GoogleAiStudioService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new GoogleVertexAiService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new MistralService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new AnthropicService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new AmazonBedrockService((HttpRequestSender.Factory)this.httpFactory.get(), (AmazonBedrockRequestSender.Factory)this.amazonBedrockFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new AlibabaCloudSearchService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new IbmWatsonxService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new JinaAIService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new VoyageAIService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new DeepSeekService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), ElasticsearchInternalService::new, context -> new CustomService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>(InferenceNamedWriteablesProvider.getNamedWriteables());
        entries.add(new NamedWriteableRegistry.Entry(RankBuilder.class, "text_similarity_reranker", TextSimilarityRankBuilder::new));
        entries.add(new NamedWriteableRegistry.Entry(RankBuilder.class, "random_reranker", RandomRankBuilder::new));
        entries.add(new NamedWriteableRegistry.Entry(RankDoc.class, "text_similarity_rank_doc", TextSimilarityRankDoc::new));
        entries.add(new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "model_registry", ModelRegistryMetadata::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "model_registry", ModelRegistryMetadata::readDiffFrom));
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> namedXContent = new ArrayList<NamedXContentRegistry.Entry>();
        namedXContent.add(new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("model_registry", new String[0]), ModelRegistryMetadata::fromXContent));
        return namedXContent;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        SystemIndexDescriptor inferenceIndexV1Descriptor = SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).setIndexPattern(".inference*").setAliasName(".inference-alias").setPrimaryIndex(".inference").setDescription("Contains inference service and model configuration").setMappings(InferenceIndex.mappingsV1()).setSettings(InferenceIndex.settings()).setOrigin(NAME).build();
        return List.of(SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).setIndexPattern(".inference*").setAliasName(".inference-alias").setPrimaryIndex(".inference").setDescription("Contains inference service and model configuration").setMappings(InferenceIndex.mappings()).setSettings(InferenceIndex.settings()).setOrigin(NAME).setPriorSystemIndexDescriptors(List.of(inferenceIndexV1Descriptor)).build(), SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).setIndexPattern(".secrets-inference*").setPrimaryIndex(".secrets-inference").setDescription("Contains inference service secrets").setMappings(InferenceSecretsIndex.mappings()).setSettings(InferenceSecretsIndex.settings()).setOrigin(NAME).setNetNew().build());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settingsToUse) {
        return List.of(InferencePlugin.inferenceUtilityExecutor(this.settings));
    }

    public static ExecutorBuilder<?> inferenceUtilityExecutor(Settings settings) {
        return new ScalingExecutorBuilder(UTILITY_THREAD_POOL_NAME, 0, 10, TimeValue.timeValueMinutes((long)10L), false, "xpack.inference.utility_thread_pool");
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(HttpSettings.getSettingsDefinitions());
        settings.addAll(HttpClientManager.getSettingsDefinitions());
        settings.addAll(ThrottlerManager.getSettingsDefinitions());
        settings.addAll(RetrySettings.getSettingsDefinitions());
        settings.addAll(Truncator.getSettingsDefinitions());
        settings.addAll(RequestExecutorServiceSettings.getSettingsDefinitions());
        settings.add(SKIP_VALIDATE_AND_START);
        settings.add(ShardBulkInferenceActionFilter.INDICES_INFERENCE_BATCH_SIZE);
        settings.addAll(ElasticInferenceServiceSettings.getSettingsDefinitions());
        return settings;
    }

    public String getFeatureName() {
        return "inference_plugin";
    }

    public String getFeatureDescription() {
        return "Inference plugin for managing inference services and inference";
    }

    public void close() {
        ServiceComponents serviceComponentsRef = (ServiceComponents)this.serviceComponents.get();
        ThrottlerManager throttlerToClose = serviceComponentsRef != null ? serviceComponentsRef.throttlerManager() : null;
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)this.inferenceServiceRegistry.get(), throttlerToClose});
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Map.of("_inference_fields", SemanticInferenceMetadataFieldsMapper.PARSER);
    }

    protected Supplier<ModelRegistry> getModelRegistry() {
        return () -> (ModelRegistry)this.modelRegistry.get();
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Map.of("semantic_text", SemanticTextFieldMapper.parser(this.getModelRegistry()), "offset_source", OffsetSourceFieldMapper.PARSER);
    }

    public Collection<MappedActionFilter> getMappedActionFilters() {
        return Collections.singletonList((MappedActionFilter)this.shardBulkInferenceActionFilter.get());
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return List.of(new SearchPlugin.QuerySpec("semantic", SemanticQueryBuilder::new, SemanticQueryBuilder::fromXContent));
    }

    public List<QueryRewriteInterceptor> getQueryRewriteInterceptors() {
        return List.of(new SemanticKnnVectorQueryRewriteInterceptor(), new SemanticMatchQueryRewriteInterceptor(), new SemanticSparseVectorQueryRewriteInterceptor());
    }

    public List<SearchPlugin.RetrieverSpec<?>> getRetrievers() {
        return List.of(new SearchPlugin.RetrieverSpec(new ParseField("text_similarity_reranker", new String[0]), (parser, context) -> TextSimilarityRankRetrieverBuilder.fromXContent(parser, context, this.getLicenseState())), new SearchPlugin.RetrieverSpec(new ParseField("random_reranker", new String[0]), RandomRankRetrieverBuilder::fromXContent));
    }

    public Map<String, Highlighter> getHighlighters() {
        return Map.of("semantic", new SemanticTextHighlighter());
    }

    public void onNodeStarted() {
        InferenceServiceRegistry registry = (InferenceServiceRegistry)this.inferenceServiceRegistry.get();
        if (registry != null) {
            registry.onNodeStarted();
        }
    }

    public Collection<RestHeaderDefinition> getRestHeaders() {
        return Set.of(new RestHeaderDefinition(X_ELASTIC_PRODUCT_USE_CASE_HTTP_HEADER, false));
    }

    public Collection<String> getTaskHeaders() {
        return Set.of(X_ELASTIC_PRODUCT_USE_CASE_HTTP_HEADER);
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }
}

