/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.util.Locale;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.external.response.streaming.StreamingErrorResponse;
import org.elasticsearch.xpack.inference.services.openai.OpenAiChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedStreamingProcessor;

public class OpenAiUnifiedChatCompletionResponseHandler
extends OpenAiChatCompletionResponseHandler {
    public OpenAiUnifiedChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, StreamingErrorResponse::fromResponse);
    }

    public OpenAiUnifiedChatCompletionResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorResponse> errorParseFunction) {
        super(requestType, parseFunction, errorParseFunction);
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        OpenAiUnifiedStreamingProcessor openAiProcessor = new OpenAiUnifiedStreamingProcessor((m, e) -> this.buildMidStreamError(request, (String)m, (Exception)e));
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(openAiProcessor);
        return new StreamingUnifiedChatCompletionResults((Flow.Publisher)openAiProcessor);
    }

    @Override
    protected Exception buildError(String message, Request request, HttpResult result, ErrorResponse errorResponse) {
        assert (request.isStreaming()) : "Only streaming requests support this format";
        int responseStatusCode = result.response().getStatusLine().getStatusCode();
        if (request.isStreaming()) {
            UnifiedChatCompletionException unifiedChatCompletionException;
            String errorMessage = this.errorMessage(message, request, result, errorResponse, responseStatusCode);
            RestStatus restStatus = OpenAiUnifiedChatCompletionResponseHandler.toRestStatus(responseStatusCode);
            if (errorResponse instanceof StreamingErrorResponse) {
                StreamingErrorResponse oer = (StreamingErrorResponse)errorResponse;
                unifiedChatCompletionException = new UnifiedChatCompletionException(restStatus, errorMessage, oer.type(), oer.code(), oer.param());
            } else {
                unifiedChatCompletionException = new UnifiedChatCompletionException(restStatus, errorMessage, OpenAiUnifiedChatCompletionResponseHandler.createErrorType(errorResponse), restStatus.name().toLowerCase(Locale.ROOT));
            }
            return unifiedChatCompletionException;
        }
        return super.buildError(message, request, result, errorResponse);
    }

    protected static String createErrorType(ErrorResponse errorResponse) {
        return errorResponse != null ? errorResponse.getClass().getSimpleName() : "unknown";
    }

    protected Exception buildMidStreamError(Request request, String message, Exception e) {
        return OpenAiUnifiedChatCompletionResponseHandler.buildMidStreamError(request.getInferenceEntityId(), message, e);
    }

    public static UnifiedChatCompletionException buildMidStreamError(String inferenceEntityId, String message, Exception e) {
        ErrorResponse errorResponse = StreamingErrorResponse.fromString(message);
        if (errorResponse instanceof StreamingErrorResponse) {
            StreamingErrorResponse oer = (StreamingErrorResponse)errorResponse;
            return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]. Error message: [%s]", (Object[])new Object[]{"Received an error response", inferenceEntityId, errorResponse.getErrorMessage()}), oer.type(), oer.code(), oer.param());
        }
        if (e != null) {
            return UnifiedChatCompletionException.fromThrowable((Throwable)e);
        }
        return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]", (Object[])new Object[]{"Received an error response", inferenceEntityId}), OpenAiUnifiedChatCompletionResponseHandler.createErrorType(errorResponse), "stream_error");
    }
}

