/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxRerankRequestManager;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.action.IbmWatsonxActionVisitor;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank.IbmWatsonxRerankModel;

public class IbmWatsonxActionCreator
implements IbmWatsonxActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public IbmWatsonxActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(IbmWatsonxEmbeddingsModel model, Map<String, Object> taskSettings) {
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("IBM WatsonX embeddings");
        return new SenderExecutableAction(this.sender, this.getEmbeddingsRequestManager(model, this.serviceComponents.truncator(), this.serviceComponents.threadPool()), failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(IbmWatsonxRerankModel model, Map<String, Object> taskSettings) {
        IbmWatsonxRerankModel overriddenModel = IbmWatsonxRerankModel.of(model, taskSettings);
        IbmWatsonxRerankRequestManager requestCreator = IbmWatsonxRerankRequestManager.of(overriddenModel, this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("Ibm Watsonx rerank");
        return new SenderExecutableAction(this.sender, requestCreator, failedToSendRequestErrorMessage);
    }

    protected IbmWatsonxEmbeddingsRequestManager getEmbeddingsRequestManager(IbmWatsonxEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        return new IbmWatsonxEmbeddingsRequestManager(model, truncator, threadPool);
    }
}

