/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceBaseService;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModelParameters;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.action.HuggingFaceActionCreator;
import org.elasticsearch.xpack.inference.services.huggingface.completion.HuggingFaceChatCompletionModel;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserModel;
import org.elasticsearch.xpack.inference.services.huggingface.embeddings.HuggingFaceEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.huggingface.request.completion.HuggingFaceUnifiedChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.huggingface.rerank.HuggingFaceRerankModel;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class HuggingFaceService
extends HuggingFaceBaseService {
    public static final String NAME = "hugging_face";
    private static final String SERVICE_NAME = "Hugging Face";
    private static final EnumSet<TaskType> SUPPORTED_TASK_TYPES = EnumSet.of(TaskType.RERANK, TaskType.TEXT_EMBEDDING, TaskType.SPARSE_EMBEDDING, TaskType.COMPLETION, TaskType.CHAT_COMPLETION);
    private static final ResponseHandler UNIFIED_CHAT_COMPLETION_HANDLER = new HuggingFaceChatCompletionResponseHandler("hugging face chat completion", OpenAiChatCompletionResponseEntity::fromResponse);

    public HuggingFaceService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    @Override
    protected HuggingFaceModel createModel(HuggingFaceModelParameters params) {
        return switch (params.taskType()) {
            case TaskType.RERANK -> new HuggingFaceRerankModel(params.inferenceEntityId(), params.taskType(), NAME, params.serviceSettings(), params.taskSettings(), params.secretSettings(), params.context());
            case TaskType.TEXT_EMBEDDING -> new HuggingFaceEmbeddingsModel(params.inferenceEntityId(), params.taskType(), NAME, params.serviceSettings(), params.chunkingSettings(), params.secretSettings(), params.context());
            case TaskType.SPARSE_EMBEDDING -> new HuggingFaceElserModel(params.inferenceEntityId(), params.taskType(), NAME, params.serviceSettings(), params.secretSettings(), params.context());
            case TaskType.CHAT_COMPLETION, TaskType.COMPLETION -> new HuggingFaceChatCompletionModel(params.inferenceEntityId(), params.taskType(), NAME, params.serviceSettings(), params.secretSettings(), params.context());
            default -> throw new ElasticsearchStatusException(params.failureMessage(), RestStatus.BAD_REQUEST, new Object[0]);
        };
    }

    public Model updateModelWithEmbeddingDetails(Model model, int embeddingSize) {
        if (model instanceof HuggingFaceEmbeddingsModel) {
            HuggingFaceEmbeddingsModel embeddingsModel = (HuggingFaceEmbeddingsModel)model;
            HuggingFaceServiceSettings serviceSettings = embeddingsModel.getServiceSettings();
            SimilarityMeasure similarityFromModel = serviceSettings.similarity();
            SimilarityMeasure similarityToUse = similarityFromModel == null ? SimilarityMeasure.COSINE : similarityFromModel;
            HuggingFaceServiceSettings updatedServiceSettings = new HuggingFaceServiceSettings(serviceSettings.uri(), similarityToUse, embeddingSize, embeddingsModel.getTokenLimit(), serviceSettings.rateLimitSettings());
            return new HuggingFaceEmbeddingsModel(embeddingsModel, updatedServiceSettings);
        }
        throw ServiceUtils.invalidModelTypeForUpdateModelWithEmbeddingDetails(model.getClass());
    }

    @Override
    protected void doChunkedInfer(Model model, List<ChunkInferenceInput> inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        if (!(model instanceof HuggingFaceModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        HuggingFaceModel huggingFaceModel = (HuggingFaceModel)model;
        HuggingFaceActionCreator actionCreator = new HuggingFaceActionCreator(this.getSender(), this.getServiceComponents());
        List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(inputs, 20, huggingFaceModel.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
        for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
            ExecutableAction action = huggingFaceModel.accept(actionCreator);
            action.execute(new EmbeddingsInput(request.batch().inputs(), inputType), timeout, request.listener());
        }
    }

    @Override
    protected void doUnifiedCompletionInfer(Model model, UnifiedChatInput inputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof HuggingFaceChatCompletionModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        HuggingFaceChatCompletionModel huggingFaceChatCompletionModel = (HuggingFaceChatCompletionModel)model;
        HuggingFaceChatCompletionModel overriddenModel = HuggingFaceChatCompletionModel.of(huggingFaceChatCompletionModel, inputs.getRequest());
        GenericRequestManager<UnifiedChatInput> manager = new GenericRequestManager<UnifiedChatInput>(this.getServiceComponents().threadPool(), overriddenModel, UNIFIED_CHAT_COMPLETION_HANDLER, unifiedChatInput -> new HuggingFaceUnifiedChatCompletionRequest((UnifiedChatInput)unifiedChatInput, overriddenModel), UnifiedChatInput.class);
        String errorMessage = HuggingFaceActionCreator.buildErrorMessage(TaskType.CHAT_COMPLETION, model.getInferenceEntityId());
        SenderExecutableAction action = new SenderExecutableAction(this.getSender(), manager, errorMessage);
        action.execute(inputs, timeout, listener);
    }

    public Set<TaskType> supportedStreamingTasks() {
        return EnumSet.of(TaskType.COMPLETION, TaskType.CHAT_COMPLETION);
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return SUPPORTED_TASK_TYPES;
    }

    public String name() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("url", new SettingsConfiguration.Builder(SUPPORTED_TASK_TYPES).setDescription("The URL endpoint to use for the requests.").setLabel("URL").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.putAll(DefaultSecretSettings.toSettingsConfiguration(SUPPORTED_TASK_TYPES));
            configurationMap.putAll(RateLimitSettings.toSettingsConfiguration(SUPPORTED_TASK_TYPES));
            return new InferenceServiceConfiguration.Builder().setService(HuggingFaceService.NAME).setName(HuggingFaceService.SERVICE_NAME).setTaskTypes(SUPPORTED_TASK_TYPES).setConfigurations(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }

        private Configuration() {
        }
    }
}

