/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.action.HuggingFaceActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class HuggingFaceModel
extends RateLimitGroupingModel {
    private final HuggingFaceRateLimitServiceSettings rateLimitServiceSettings;
    private final SecureString apiKey;

    public HuggingFaceModel(ModelConfigurations configurations, ModelSecrets secrets, HuggingFaceRateLimitServiceSettings rateLimitServiceSettings, @Nullable ApiKeySecrets apiKeySecrets) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
        this.apiKey = ServiceUtils.apiKey(apiKeySecrets);
    }

    protected HuggingFaceModel(HuggingFaceModel model, TaskSettings taskSettings) {
        super((RateLimitGroupingModel)model, taskSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
    }

    public HuggingFaceRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.rateLimitServiceSettings.uri(), this.apiKey);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitServiceSettings.rateLimitSettings();
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public abstract Integer getTokenLimit();

    public abstract ExecutableAction accept(HuggingFaceActionVisitor var1);
}

