/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record GoogleVertexAiRerankRequestEntity(String query, List<String> inputs, @Nullable Boolean returnDocuments, @Nullable Integer topN, @Nullable String model) implements ToXContentObject
{
    private static final String MODEL_FIELD = "model";
    private static final String QUERY_FIELD = "query";
    private static final String RECORDS_FIELD = "records";
    private static final String ID_FIELD = "id";
    private static final String CONTENT_FIELD = "content";
    private static final String TOP_N_FIELD = "topN";
    private static final String IGNORE_RECORD_DETAILS_IN_RESPONSE_FIELD = "ignoreRecordDetailsInResponse";

    public GoogleVertexAiRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(inputs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.model != null) {
            builder.field(MODEL_FIELD, this.model);
        }
        builder.field(QUERY_FIELD, this.query);
        builder.startArray(RECORDS_FIELD);
        for (int recordId = 0; recordId < this.inputs.size(); ++recordId) {
            builder.startObject();
            builder.field(ID_FIELD, String.valueOf(recordId));
            builder.field(CONTENT_FIELD, this.inputs.get(recordId));
            builder.endObject();
        }
        builder.endArray();
        if (this.topN != null) {
            builder.field(TOP_N_FIELD, this.topN);
        }
        if (this.returnDocuments != null) {
            builder.field(IGNORE_RECORD_DETAILS_IN_RESPONSE_FIELD, this.returnDocuments == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE);
        }
        builder.endObject();
        return builder;
    }
}

