/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googleaistudio.request;

import java.net.URI;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public interface GoogleAiStudioRequest
extends Request {
    public static final String API_KEY_PARAMETER = "key";

    public static void decorateWithApiKeyParameter(HttpPost httpPost, DefaultSecretSettings secretSettings) {
        try {
            URI uriWithApiKey = GoogleAiStudioRequest.builderWithApiKeyParameter(httpPost.getURI(), secretSettings).build();
            httpPost.setURI(uriWithApiKey);
        }
        catch (Exception e) {
            ValidationException validationException = new ValidationException((Throwable)e);
            validationException.addValidationError(e.getMessage());
            throw validationException;
        }
    }

    public static URIBuilder builderWithApiKeyParameter(URI uri, DefaultSecretSettings secretSettings) {
        return new URIBuilder().setScheme(uri.getScheme()).setHost(uri.getHost()).setPort(uri.getPort()).setPath(uri.getPath()).addParameter(API_KEY_PARAMETER, secretSettings.apiKey().toString());
    }
}

