/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.inference.common.MapPathExtractor;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.custom.response.BaseCustomResponseParser;

public class RerankResponseParser
extends BaseCustomResponseParser<RankedDocsResults> {
    public static final String NAME = "rerank_response_parser";
    public static final String RERANK_PARSER_SCORE = "relevance_score";
    public static final String RERANK_PARSER_INDEX = "reranked_index";
    public static final String RERANK_PARSER_DOCUMENT_TEXT = "document_text";
    private final String relevanceScorePath;
    private final String rerankIndexPath;
    private final String documentTextPath;

    public static RerankResponseParser fromMap(Map<String, Object> responseParserMap, String scope, ValidationException validationException) {
        String fullScope = String.join((CharSequence)".", scope, "json_parser");
        String relevanceScore = ServiceUtils.extractRequiredString(responseParserMap, RERANK_PARSER_SCORE, fullScope, validationException);
        String rerankIndex = ServiceUtils.extractOptionalString(responseParserMap, RERANK_PARSER_INDEX, fullScope, validationException);
        String documentText = ServiceUtils.extractOptionalString(responseParserMap, RERANK_PARSER_DOCUMENT_TEXT, fullScope, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new RerankResponseParser(relevanceScore, rerankIndex, documentText);
    }

    public RerankResponseParser(String relevanceScorePath) {
        this(relevanceScorePath, null, null);
    }

    public RerankResponseParser(String relevanceScorePath, @Nullable String rerankIndexPath, @Nullable String documentTextPath) {
        this.relevanceScorePath = Objects.requireNonNull(relevanceScorePath);
        this.rerankIndexPath = rerankIndexPath;
        this.documentTextPath = documentTextPath;
    }

    public RerankResponseParser(StreamInput in) throws IOException {
        this.relevanceScorePath = in.readString();
        this.rerankIndexPath = in.readOptionalString();
        this.documentTextPath = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.relevanceScorePath);
        out.writeOptionalString(this.rerankIndexPath);
        out.writeOptionalString(this.documentTextPath);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("json_parser");
        builder.field(RERANK_PARSER_SCORE, this.relevanceScorePath);
        if (this.rerankIndexPath != null) {
            builder.field(RERANK_PARSER_INDEX, this.rerankIndexPath);
        }
        if (this.documentTextPath != null) {
            builder.field(RERANK_PARSER_DOCUMENT_TEXT, this.documentTextPath);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RerankResponseParser that = (RerankResponseParser)o;
        return Objects.equals(this.relevanceScorePath, that.relevanceScorePath) && Objects.equals(this.rerankIndexPath, that.rerankIndexPath) && Objects.equals(this.documentTextPath, that.documentTextPath);
    }

    public int hashCode() {
        return Objects.hash(this.relevanceScorePath, this.rerankIndexPath, this.documentTextPath);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public RankedDocsResults transform(Map<String, Object> map) {
        List<Float> scores = this.extractScores(map);
        List<Integer> indices = this.extractIndices(map);
        List<String> documents = this.extractDocuments(map);
        if (indices != null && indices.size() != scores.size()) {
            throw new IllegalStateException(Strings.format((String)"The number of index fields [%d] was not the same as the number of scores [%d]", (Object[])new Object[]{indices.size(), scores.size()}));
        }
        if (documents != null && documents.size() != scores.size()) {
            throw new IllegalStateException(Strings.format((String)"The number of document fields [%d] was not the same as the number of scores [%d]", (Object[])new Object[]{documents.size(), scores.size()}));
        }
        ArrayList<RankedDocsResults.RankedDoc> rankedDocs = new ArrayList<RankedDocsResults.RankedDoc>();
        for (int i = 0; i < scores.size(); ++i) {
            int index = indices != null ? indices.get(i) : i;
            Float score = scores.get(i);
            String document = documents != null ? documents.get(i) : null;
            rankedDocs.add(new RankedDocsResults.RankedDoc(index, score.floatValue(), document));
        }
        return new RankedDocsResults(rankedDocs);
    }

    private List<Float> extractScores(Map<String, Object> map) {
        try {
            MapPathExtractor.Result result = MapPathExtractor.extract(map, this.relevanceScorePath);
            return RerankResponseParser.convertToListOfFloats(result.extractedObject(), result.getArrayFieldName(0));
        }
        catch (Exception e) {
            throw new IllegalStateException(Strings.format((String)"Failed to parse rerank scores, error: %s", (Object[])new Object[]{e.getMessage()}), e);
        }
    }

    private List<Integer> extractIndices(Map<String, Object> map) {
        if (this.rerankIndexPath != null) {
            try {
                MapPathExtractor.Result indexResult = MapPathExtractor.extract(map, this.rerankIndexPath);
                return RerankResponseParser.convertToListOfIntegers(indexResult.extractedObject(), indexResult.getArrayFieldName(0));
            }
            catch (Exception e) {
                throw new IllegalStateException(Strings.format((String)"Failed to parse rerank indices, error: %s", (Object[])new Object[]{e.getMessage()}), e);
            }
        }
        return null;
    }

    private List<String> extractDocuments(Map<String, Object> map) {
        try {
            if (this.documentTextPath != null) {
                MapPathExtractor.Result documentResult = MapPathExtractor.extract(map, this.documentTextPath);
                String documentFieldName = documentResult.getArrayFieldName(0);
                return RerankResponseParser.castList(RerankResponseParser.validateList(documentResult.extractedObject(), documentFieldName), (obj, fieldName) -> RerankResponseParser.toType(obj, String.class, fieldName), documentFieldName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(Strings.format((String)"Failed to parse rerank documents, error: %s", (Object[])new Object[]{e.getMessage()}), e);
        }
        return null;
    }
}

