/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai.response;

import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.http.HttpResponse;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.HttpUtils;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ContentTooLargeException;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandlerUtils;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.ErrorMessageResponseEntity;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;
import org.elasticsearch.xpack.inference.services.openai.OpenAiStreamingProcessor;

public class AzureMistralOpenAiExternalResponseHandler
extends BaseResponseHandler {
    static final String REQUESTS_LIMIT = "x-ratelimit-limit-requests";
    static final String TOKENS_LIMIT = "x-ratelimit-limit-tokens";
    static final String REMAINING_REQUESTS = "x-ratelimit-remaining-requests";
    static final String REMAINING_TOKENS = "x-ratelimit-remaining-tokens";
    static final String CONTENT_TOO_LARGE_MESSAGE = "Please reduce your prompt; or completion length.";
    static final String SERVER_BUSY_ERROR = "Received a server busy error status code";
    private final boolean canHandleStreamingResponses;

    public AzureMistralOpenAiExternalResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorResponse> errorParseFunction, boolean canHandleStreamingResponses) {
        super(requestType, parseFunction, errorParseFunction);
        this.canHandleStreamingResponses = canHandleStreamingResponses;
    }

    @Override
    public void validateResponse(ThrottlerManager throttlerManager, Logger logger, Request request, HttpResult result, boolean checkForErrorObject) throws RetryException {
        this.checkForFailureStatusCode(request, result);
        HttpUtils.checkForEmptyBody(throttlerManager, logger, request, result);
    }

    @Override
    public boolean canHandleStreamingResponses() {
        return this.canHandleStreamingResponses;
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        OpenAiStreamingProcessor openAiProcessor = new OpenAiStreamingProcessor();
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(openAiProcessor);
        return new StreamingChatCompletionResults((Flow.Publisher)openAiProcessor);
    }

    @Override
    public void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        if (result.isSuccessfulResponse()) {
            return;
        }
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 500) {
            throw this.handle500Error(request, result);
        }
        if (statusCode == 503) {
            throw this.handle503Error(request, result);
        }
        if (statusCode > 500) {
            throw this.handleOther500Error(request, result);
        }
        if (statusCode == 429) {
            throw this.handleRateLimitingError(request, result);
        }
        if (AzureMistralOpenAiExternalResponseHandler.isContentTooLarge(result)) {
            throw new ContentTooLargeException(this.buildError("Received a content too large status code", request, result));
        }
        if (statusCode == 401) {
            throw this.handleAuthenticationError(request, result);
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw this.handleRedirectionStatusCode(request, result);
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    protected RetryException handle500Error(Request request, HttpResult result) {
        return new RetryException(true, this.buildError("Received a server error status code", request, result));
    }

    protected RetryException handle503Error(Request request, HttpResult result) {
        return new RetryException(true, this.buildError(SERVER_BUSY_ERROR, request, result));
    }

    protected RetryException handleOther500Error(Request request, HttpResult result) {
        return new RetryException(false, this.buildError("Received a server error status code", request, result));
    }

    protected RetryException handleAuthenticationError(Request request, HttpResult result) {
        return new RetryException(false, this.buildError("Received an authentication error status code", request, result));
    }

    protected RetryException handleRateLimitingError(Request request, HttpResult result) {
        return new RetryException(true, this.buildError(AzureMistralOpenAiExternalResponseHandler.buildRateLimitErrorMessage(result), request, result));
    }

    protected RetryException handleRedirectionStatusCode(Request request, HttpResult result) {
        throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
    }

    public static boolean isContentTooLarge(HttpResult result) {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 413) {
            return true;
        }
        if (statusCode == 400) {
            ErrorResponse errorEntity = ErrorMessageResponseEntity.fromResponse(result);
            return errorEntity != null && errorEntity.getErrorMessage().contains(CONTENT_TOO_LARGE_MESSAGE);
        }
        return false;
    }

    public static String buildRateLimitErrorMessage(HttpResult result) {
        HttpResponse response = result.response();
        String tokenLimit = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, TOKENS_LIMIT);
        String remainingTokens = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_TOKENS);
        String requestLimit = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REQUESTS_LIMIT);
        String remainingRequests = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_REQUESTS);
        if (tokenLimit.equals("unknown") && requestLimit.equals("unknown")) {
            String usageMessage = Strings.format((String)"Remaining tokens [%s]. Remaining requests [%s].", (Object[])new Object[]{remainingTokens, remainingRequests});
            return "Received a rate limit status code. " + usageMessage;
        }
        String usageMessage = Strings.format((String)"Token limit [%s], remaining tokens [%s]. Request limit [%s], remaining requests [%s]", (Object[])new Object[]{tokenLimit, remainingTokens, requestLimit, remainingRequests});
        return "Received a rate limit status code. " + usageMessage;
    }
}

