/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.shards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardMonitoringDoc;

public class ShardsCollector
extends Collector {
    public ShardsCollector(ClusterService clusterService, XPackLicenseState licenseState) {
        super("shards", clusterService, null, licenseState);
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster && super.shouldCollect(isElectedMaster);
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) throws Exception {
        RoutingTable routingTable;
        ArrayList<ShardMonitoringDoc> results = new ArrayList<ShardMonitoringDoc>(1);
        if (clusterState != null && (routingTable = clusterState.routingTable()) != null) {
            String[] indices;
            String clusterUuid = ShardsCollector.clusterUuid(clusterState);
            String stateUUID = clusterState.stateUUID();
            long timestamp = ShardsCollector.timestamp();
            String[] indicesToMonitor = this.getCollectionIndices();
            boolean isAllIndices = IndexNameExpressionResolver.isAllIndices(Arrays.asList(indicesToMonitor));
            for (String index : indices = isAllIndices ? routingTable.indicesRouting().keySet().toArray(new String[0]) : ShardsCollector.expandIndexPattern(indicesToMonitor, routingTable.indicesRouting().keySet().toArray(new String[0]))) {
                IndexRoutingTable indexRoutingTable = routingTable.index(index);
                if (indexRoutingTable == null) continue;
                int shardCount = indexRoutingTable.size();
                for (int i = 0; i < shardCount; ++i) {
                    IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(i);
                    ShardRouting primary = shardRoutingTable.primaryShard();
                    MonitoringDoc.Node primaryShardNode = null;
                    if (primary.assignedToNode()) {
                        primaryShardNode = ShardsCollector.convertNode(node.getTimestamp(), clusterState.getNodes().get(primary.currentNodeId()));
                    }
                    results.add(new ShardMonitoringDoc(clusterUuid, timestamp, interval, primaryShardNode, primary, stateUUID, 0));
                    List replicas = shardRoutingTable.replicaShards();
                    for (int j = 0; j < replicas.size(); ++j) {
                        ShardRouting replica = (ShardRouting)replicas.get(j);
                        MonitoringDoc.Node replicaShardNode = null;
                        if (replica.assignedToNode()) {
                            replicaShardNode = ShardsCollector.convertNode(node.getTimestamp(), clusterState.getNodes().get(replica.currentNodeId()));
                        }
                        results.add(new ShardMonitoringDoc(clusterUuid, timestamp, interval, replicaShardNode, replica, stateUUID, j + 1));
                    }
                }
            }
        }
        return Collections.unmodifiableCollection(results);
    }

    private static String[] expandIndexPattern(String[] indicesToMonitor, String[] indices) {
        HashSet<String> expandedIndices = new HashSet<String>();
        for (String indexOrPattern : indicesToMonitor) {
            if (indexOrPattern.contains("*")) {
                for (String index : indices) {
                    if (!Regex.simpleMatch((String)indexOrPattern, (String)index)) continue;
                    expandedIndices.add(index);
                }
                continue;
            }
            expandedIndices.add(indexOrPattern);
        }
        return expandedIndices.toArray(new String[0]);
    }
}

