/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.lucene.LuceneCountOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.LuceneSourceOperator;
import org.elasticsearch.compute.lucene.LuceneTopNSourceOperator;
import org.elasticsearch.compute.lucene.TimeSeriesSourceOperatorFactory;
import org.elasticsearch.compute.lucene.read.TimeSeriesExtractFieldOperator;
import org.elasticsearch.compute.lucene.read.ValuesSourceReaderOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.OrdinalsGroupingOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.compute.operator.TimeSeriesAggregationOperator;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.KeywordEsField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.core.type.PotentiallyUnmappedKeywordEsField;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.TimeSeriesAggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.TimeSeriesFieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.TimeSeriesSourceExec;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.planner.PhysicalSettings;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.planner.TypeConverter;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;

public class EsPhysicalOperationProviders
extends AbstractPhysicalOperationProviders {
    private static final Logger logger = LogManager.getLogger(EsPhysicalOperationProviders.class);
    private final List<ShardContext> shardContexts;
    private final PhysicalSettings physicalSettings;

    public EsPhysicalOperationProviders(FoldContext foldContext, List<ShardContext> shardContexts, AnalysisRegistry analysisRegistry, PhysicalSettings physicalSettings) {
        super(foldContext, analysisRegistry);
        this.shardContexts = shardContexts;
        this.physicalSettings = physicalSettings;
    }

    @Override
    public final LocalExecutionPlanner.PhysicalOperation fieldExtractPhysicalOperation(FieldExtractExec fieldExtractExec, LocalExecutionPlanner.PhysicalOperation source) {
        Layout.Builder layout = source.layout.builder();
        Attribute sourceAttr = fieldExtractExec.sourceAttribute();
        List<ValuesSourceReaderOperator.ShardContext> readers = this.shardContexts.stream().map(s -> new ValuesSourceReaderOperator.ShardContext(s.searcher().getIndexReader(), () -> ((ShardContext)s).newSourceLoader(), s.storedFieldsSequentialProportion())).toList();
        int docChannel = source.layout.get(sourceAttr.id()).channel();
        for (Attribute attr : fieldExtractExec.attributesToExtract()) {
            layout.append((NamedExpression)attr);
        }
        List<ValuesSourceReaderOperator.FieldInfo> fields = this.extractFields(fieldExtractExec.attributesToExtract(), fieldExtractExec::fieldExtractPreference);
        if (fieldExtractExec instanceof TimeSeriesFieldExtractExec) {
            return source.with((Operator.OperatorFactory)new TimeSeriesExtractFieldOperator.Factory(fields, this.shardContexts), layout.build());
        }
        return source.with((Operator.OperatorFactory)new ValuesSourceReaderOperator.Factory(this.physicalSettings.valuesLoadingJumboSize(), fields, readers, docChannel), layout.build());
    }

    private static String getFieldName(Attribute attr) {
        String string;
        if (attr instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)attr;
            string = fa.fieldName().string();
        } else {
            string = attr.name();
        }
        return string;
    }

    private BlockLoader getBlockLoaderFor(int shardId, Attribute attr, MappedFieldType.FieldExtractPreference fieldExtractPreference) {
        FieldAttribute fa;
        EsField esField;
        DefaultShardContext shardContext = (DefaultShardContext)this.shardContexts.get(shardId);
        if (attr instanceof FieldAttribute && (esField = (fa = (FieldAttribute)attr).field()) instanceof PotentiallyUnmappedKeywordEsField) {
            PotentiallyUnmappedKeywordEsField kf = (PotentiallyUnmappedKeywordEsField)esField;
            shardContext = new DefaultShardContextForUnmappedField(shardContext, kf);
        }
        boolean isUnsupported = attr.dataType() == DataType.UNSUPPORTED;
        BlockLoader blockLoader = shardContext.blockLoader(EsPhysicalOperationProviders.getFieldName(attr), isUnsupported, fieldExtractPreference);
        MultiTypeEsField unionTypes = EsPhysicalOperationProviders.findUnionTypes(attr);
        if (unionTypes != null) {
            String indexName = shardContext.ctx.getFullyQualifiedIndex().getName();
            Expression conversion = unionTypes.getConversionExpressionForIndex(indexName);
            return conversion == null ? BlockLoader.CONSTANT_NULLS : new TypeConvertingBlockLoader(blockLoader, (AbstractConvertFunction)conversion);
        }
        return blockLoader;
    }

    @Nullable
    private static MultiTypeEsField findUnionTypes(Attribute attr) {
        FieldAttribute fa;
        EsField esField;
        if (attr instanceof FieldAttribute && (esField = (fa = (FieldAttribute)attr).field()) instanceof MultiTypeEsField) {
            MultiTypeEsField multiTypeEsField = (MultiTypeEsField)esField;
            return multiTypeEsField;
        }
        return null;
    }

    public Function<org.elasticsearch.compute.lucene.ShardContext, List<LuceneSliceQueue.QueryAndTags>> querySupplier(QueryBuilder builder) {
        QueryBuilder qb = builder == null ? QueryBuilders.matchAllQuery().boost(0.0f) : builder;
        return ctx -> List.of(new LuceneSliceQueue.QueryAndTags(this.shardContexts.get(ctx.index()).toQuery(qb), List.of()));
    }

    @Override
    public final LocalExecutionPlanner.PhysicalOperation sourcePhysicalOperation(EsQueryExec esQueryExec, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        LuceneSourceOperator.Factory luceneFactory;
        if (esQueryExec.indexMode() == IndexMode.TIME_SERIES) {
            assert (false) : "Time series source should be translated to TimeSeriesSourceExec";
            throw new IllegalStateException("Time series source should be translated to TimeSeriesSourceExec");
        }
        logger.trace("Query Exec is {}", new Object[]{esQueryExec});
        List<EsQueryExec.Sort> sorts = esQueryExec.sorts();
        assert (esQueryExec.estimatedRowSize() != null) : "estimated row size not initialized";
        int rowEstimatedSize = esQueryExec.estimatedRowSize();
        int limit = esQueryExec.limit() != null ? (Integer)esQueryExec.limit().fold(context.foldCtx()) : Integer.MAX_VALUE;
        boolean scoring = esQueryExec.hasScoring();
        if (sorts != null && !sorts.isEmpty()) {
            ArrayList sortBuilders = new ArrayList(sorts.size());
            long estimatedPerRowSortSize = 0L;
            for (EsQueryExec.Sort sort : sorts) {
                sortBuilders.add(sort.sortBuilder());
                estimatedPerRowSortSize += (long)EstimatesRowSize.estimateSize(sort.resulType());
            }
            luceneFactory = new LuceneTopNSourceOperator.Factory(this.shardContexts, this.querySupplier(esQueryExec.query()), context.queryPragmas().dataPartitioning(this.physicalSettings.defaultDataPartitioning()), context.queryPragmas().taskConcurrency(), context.pageSize(rowEstimatedSize), limit, sortBuilders, estimatedPerRowSortSize *= 2L, scoring);
        } else {
            luceneFactory = new LuceneSourceOperator.Factory(this.shardContexts, this.querySupplier(esQueryExec.query()), context.queryPragmas().dataPartitioning(this.physicalSettings.defaultDataPartitioning()), context.queryPragmas().taskConcurrency(), context.pageSize(rowEstimatedSize), limit, scoring);
        }
        Layout.Builder layout = new Layout.Builder();
        layout.append(esQueryExec.output());
        int instanceCount = Math.max(1, luceneFactory.taskConcurrency());
        context.driverParallelism(new LocalExecutionPlanner.DriverParallelism(LocalExecutionPlanner.DriverParallelism.Type.DATA_PARALLELISM, instanceCount));
        return LocalExecutionPlanner.PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)luceneFactory, layout.build());
    }

    @Override
    public LocalExecutionPlanner.PhysicalOperation timeSeriesSourceOperation(TimeSeriesSourceExec ts, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        int limit = ts.limit() != null ? (Integer)ts.limit().fold(context.foldCtx()) : Integer.MAX_VALUE;
        TimeSeriesSourceOperatorFactory luceneFactory = TimeSeriesSourceOperatorFactory.create((int)limit, (int)context.pageSize(ts.estimatedRowSize()), (int)context.queryPragmas().taskConcurrency(), this.shardContexts, this.querySupplier(ts.query()));
        Layout.Builder layout = new Layout.Builder();
        layout.append(ts.output());
        context.driverParallelism(LocalExecutionPlanner.DriverParallelism.SINGLE);
        return LocalExecutionPlanner.PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)luceneFactory, layout.build());
    }

    private List<ValuesSourceReaderOperator.FieldInfo> extractFields(List<Attribute> attributes, Function<Attribute, MappedFieldType.FieldExtractPreference> preference) {
        ArrayList<ValuesSourceReaderOperator.FieldInfo> fieldInfos = new ArrayList<ValuesSourceReaderOperator.FieldInfo>(attributes.size());
        for (Attribute attr : attributes) {
            DataType dataType = attr.dataType();
            MappedFieldType.FieldExtractPreference fieldExtractPreference = preference.apply(attr);
            ElementType elementType = PlannerUtils.toElementType(dataType, fieldExtractPreference);
            IntFunction<BlockLoader> loader = s -> this.getBlockLoaderFor(s, attr, fieldExtractPreference);
            fieldInfos.add(new ValuesSourceReaderOperator.FieldInfo(EsPhysicalOperationProviders.getFieldName(attr), elementType, loader));
        }
        return fieldInfos;
    }

    public LuceneCountOperator.Factory countSource(LocalExecutionPlanner.LocalExecutionPlannerContext context, QueryBuilder queryBuilder, Expression limit) {
        return new LuceneCountOperator.Factory(this.shardContexts, this.querySupplier(queryBuilder), context.queryPragmas().dataPartitioning(this.physicalSettings.defaultDataPartitioning()), context.queryPragmas().taskConcurrency(), limit == null ? Integer.MAX_VALUE : (Integer)limit.fold(context.foldCtx()));
    }

    @Override
    public final Operator.OperatorFactory ordinalGroupingOperatorFactory(LocalExecutionPlanner.PhysicalOperation source, AggregateExec aggregateExec, List<GroupingAggregator.Factory> aggregatorFactories, Attribute attrSource, ElementType groupElementType, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        Attribute sourceAttribute = FieldExtractExec.extractSourceAttributesFrom(aggregateExec.child());
        int docChannel = source.layout.get(sourceAttribute.id()).channel();
        List<ValuesSourceReaderOperator.ShardContext> vsShardContexts = this.shardContexts.stream().map(s -> new ValuesSourceReaderOperator.ShardContext(s.searcher().getIndexReader(), () -> ((ShardContext)s).newSourceLoader(), s.storedFieldsSequentialProportion())).toList();
        return new OrdinalsGroupingOperator.OrdinalsGroupingOperatorFactory(shardIdx -> this.getBlockLoaderFor(shardIdx, attrSource, MappedFieldType.FieldExtractPreference.NONE), vsShardContexts, groupElementType, docChannel, attrSource.name(), aggregatorFactories, context.pageSize(aggregateExec.estimatedRowSize()));
    }

    @Override
    public Operator.OperatorFactory timeSeriesAggregatorOperatorFactory(TimeSeriesAggregateExec ts, AggregatorMode aggregatorMode, List<GroupingAggregator.Factory> aggregatorFactories, List<BlockHash.GroupSpec> groupSpecs, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        return new TimeSeriesAggregationOperator.Factory(ts.timeBucketRounding(context.foldCtx()), this.shardContexts.size() == 1 && ts.anyMatch(p -> p instanceof TimeSeriesSourceExec), groupSpecs, aggregatorMode, aggregatorFactories, context.pageSize(ts.estimatedRowSize()));
    }

    public static class DefaultShardContext
    extends ShardContext {
        private final int index;
        private final Releasable releasable;
        private final SearchExecutionContext ctx;
        private final AliasFilter aliasFilter;
        private final String shardIdentifier;

        public DefaultShardContext(int index, Releasable releasable, SearchExecutionContext ctx, AliasFilter aliasFilter) {
            this.index = index;
            this.releasable = releasable;
            this.ctx = ctx;
            this.aliasFilter = aliasFilter;
            this.shardIdentifier = this.ctx.getFullyQualifiedIndex().getName() + ":" + this.ctx.getShardId();
        }

        public int index() {
            return this.index;
        }

        public IndexSearcher searcher() {
            return this.ctx.searcher();
        }

        public Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sorts) throws IOException {
            return SortBuilder.buildSort(sorts, (SearchExecutionContext)this.ctx, (boolean)false);
        }

        public String shardIdentifier() {
            return this.shardIdentifier;
        }

        public SourceLoader newSourceLoader() {
            return this.ctx.newSourceLoader(null, false);
        }

        @Override
        public Query toQuery(QueryBuilder queryBuilder) {
            Query query = this.ctx.toQuery(queryBuilder).query();
            if (this.ctx.nestedLookup() != NestedLookup.EMPTY && NestedHelper.mightMatchNestedDocs((Query)query, (SearchExecutionContext)this.ctx)) {
                query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter((IndexVersion)this.ctx.indexVersionCreated()), BooleanClause.Occur.FILTER).build();
            }
            if (this.aliasFilter != AliasFilter.EMPTY) {
                Query filterQuery = this.ctx.toQuery(this.aliasFilter.getQueryBuilder()).query();
                query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.FILTER).build();
            }
            return query;
        }

        public BlockLoader blockLoader(String name, boolean asUnsupportedSource, final MappedFieldType.FieldExtractPreference fieldExtractPreference) {
            if (asUnsupportedSource) {
                return BlockLoader.CONSTANT_NULLS;
            }
            MappedFieldType fieldType = this.fieldType(name);
            if (fieldType == null) {
                return BlockLoader.CONSTANT_NULLS;
            }
            BlockLoader loader = fieldType.blockLoader(new MappedFieldType.BlockLoaderContext(){

                public String indexName() {
                    return ctx.getFullyQualifiedIndex().getName();
                }

                public IndexSettings indexSettings() {
                    return ctx.getIndexSettings();
                }

                public MappedFieldType.FieldExtractPreference fieldExtractPreference() {
                    return fieldExtractPreference;
                }

                public SearchLookup lookup() {
                    return ctx.lookup();
                }

                public Set<String> sourcePaths(String name) {
                    return ctx.sourcePath(name);
                }

                public String parentField(String field) {
                    return ctx.parentPath(field);
                }

                public FieldNamesFieldMapper.FieldNamesFieldType fieldNames() {
                    return (FieldNamesFieldMapper.FieldNamesFieldType)ctx.lookup().fieldType("_field_names");
                }
            });
            if (loader == null) {
                HeaderWarning.addWarning((String)"Field [{}] cannot be retrieved, it is unsupported or not indexed; returning null", (Object[])new Object[]{name});
                return BlockLoader.CONSTANT_NULLS;
            }
            return loader;
        }

        @Nullable
        public MappedFieldType fieldType(String name) {
            return this.ctx.getFieldType(name);
        }

        @Override
        public double storedFieldsSequentialProportion() {
            return (Double)EsqlPlugin.STORED_FIELDS_SEQUENTIAL_PROPORTION.get(this.ctx.getIndexSettings().getSettings());
        }

        public void close() {
            this.releasable.close();
        }
    }

    private static class DefaultShardContextForUnmappedField
    extends DefaultShardContext {
        private static final FieldType UNMAPPED_FIELD_TYPE = new FieldType((IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE);
        private final KeywordEsField unmappedEsField;

        DefaultShardContextForUnmappedField(DefaultShardContext ctx, PotentiallyUnmappedKeywordEsField unmappedEsField) {
            super(ctx.index, ctx.releasable, ctx.ctx, ctx.aliasFilter);
            this.unmappedEsField = unmappedEsField;
        }

        @Override
        @Nullable
        public MappedFieldType fieldType(String name) {
            MappedFieldType superResult = super.fieldType(name);
            return superResult == null && name.equals(this.unmappedEsField.getName()) ? DefaultShardContextForUnmappedField.createUnmappedFieldType(name, this) : superResult;
        }

        static MappedFieldType createUnmappedFieldType(String name, DefaultShardContext context) {
            KeywordFieldMapper.Builder builder = new KeywordFieldMapper.Builder(name, context.ctx.indexVersionCreated());
            builder.docValues(false);
            builder.indexed(false);
            return new KeywordFieldMapper.KeywordFieldType(name, UNMAPPED_FIELD_TYPE, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, builder, context.ctx.isSourceSynthetic());
        }

        static {
            UNMAPPED_FIELD_TYPE.setDocValuesType(DocValuesType.NONE);
            UNMAPPED_FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            UNMAPPED_FIELD_TYPE.setStored(false);
            UNMAPPED_FIELD_TYPE.freeze();
        }
    }

    private static class TypeConvertingBlockLoader
    implements BlockLoader {
        private final BlockLoader delegate;
        private final TypeConverter typeConverter;

        protected TypeConvertingBlockLoader(BlockLoader delegate, AbstractConvertFunction convertFunction) {
            this.delegate = delegate;
            this.typeConverter = TypeConverter.fromConvertFunction(convertFunction);
        }

        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return this.delegate.builder(factory, expectedCount);
        }

        public BlockLoader.Block convert(BlockLoader.Block block) {
            return this.typeConverter.convert((Block)block);
        }

        public BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            final BlockLoader.ColumnAtATimeReader reader = this.delegate.columnAtATimeReader(context);
            if (reader == null) {
                return null;
            }
            return new BlockLoader.ColumnAtATimeReader(){

                public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
                    BlockLoader.Block block = reader.read(factory, docs, offset);
                    return typeConverter.convert((Block)block);
                }

                public boolean canReuse(int startingDocID) {
                    return reader.canReuse(startingDocID);
                }

                public String toString() {
                    return reader.toString();
                }
            };
        }

        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            return this.delegate.rowStrideReader(context);
        }

        public StoredFieldsSpec rowStrideStoredFieldSpec() {
            return this.delegate.rowStrideStoredFieldSpec();
        }

        public boolean supportsOrdinals() {
            return false;
        }

        public SortedSetDocValues ordinals(LeafReaderContext context) {
            throw new IllegalArgumentException("Ordinals are not supported for type conversion");
        }

        public final String toString() {
            return "TypeConvertingBlockLoader[delegate=" + String.valueOf(this.delegate) + ", typeConverter=" + String.valueOf(this.typeConverter) + "]";
        }
    }

    public static abstract class ShardContext
    implements org.elasticsearch.compute.lucene.ShardContext,
    Releasable {
        private final AbstractRefCounted refCounted = new AbstractRefCounted(){

            protected void closeInternal() {
                this.close();
            }
        };

        public void incRef() {
            this.refCounted.incRef();
        }

        public boolean tryIncRef() {
            return this.refCounted.tryIncRef();
        }

        public boolean decRef() {
            return this.refCounted.decRef();
        }

        public boolean hasReferences() {
            return this.refCounted.hasReferences();
        }

        public abstract Query toQuery(QueryBuilder var1);

        public abstract double storedFieldsSequentialProportion();
    }
}

