/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.operator.lookup.QueryList;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.AbstractLookupService;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;

public class LookupFromIndexService
extends AbstractLookupService<Request, TransportRequest> {
    public static final String LOOKUP_ACTION_NAME = "indices:data/read/esql/lookup_from_index";

    public LookupFromIndexService(ClusterService clusterService, IndicesService indicesService, AbstractLookupService.LookupShardContextFactory lookupShardContextFactory, TransportService transportService, IndexNameExpressionResolver indexNameExpressionResolver, BigArrays bigArrays, BlockFactory blockFactory) {
        super(LOOKUP_ACTION_NAME, clusterService, indicesService, lookupShardContextFactory, transportService, indexNameExpressionResolver, bigArrays, blockFactory, false, TransportRequest::readFrom);
    }

    @Override
    protected TransportRequest transportRequest(Request request, ShardId shardId) {
        return new TransportRequest(request.sessionId, shardId, request.indexPattern, request.inputDataType, request.inputPage, null, request.extractFields, request.matchField, request.source);
    }

    @Override
    protected QueryList queryList(TransportRequest request, SearchExecutionContext context, AliasFilter aliasFilter, Block inputBlock, @Nullable DataType inputDataType, Warnings warnings) {
        return LookupFromIndexService.termQueryList(context.getFieldType(request.matchField), context, aliasFilter, inputBlock, inputDataType).onlySingleValues(warnings, "LOOKUP JOIN encountered multi-value");
    }

    @Override
    protected LookupResponse createLookupResponse(List<Page> pages, BlockFactory blockFactory) throws IOException {
        return new LookupResponse(pages, blockFactory);
    }

    @Override
    protected AbstractLookupService.LookupResponse readLookupResponse(StreamInput in, BlockFactory blockFactory) throws IOException {
        return new LookupResponse(in, blockFactory);
    }

    protected static class TransportRequest
    extends AbstractLookupService.TransportRequest {
        private final String matchField;
        private static final TransportVersion JOIN_ON_ALIASES = TransportVersion.fromName((String)"join_on_aliases");

        TransportRequest(String sessionId, ShardId shardId, String indexPattern, DataType inputDataType, Page inputPage, Page toRelease, List<NamedExpression> extractFields, String matchField, Source source) {
            super(sessionId, shardId, indexPattern, inputDataType, inputPage, toRelease, extractFields, source);
            this.matchField = matchField;
        }

        static TransportRequest readFrom(StreamInput in, BlockFactory blockFactory) throws IOException {
            Page inputPage;
            TaskId parentTaskId = TaskId.readFromStream((StreamInput)in);
            String sessionId = in.readString();
            ShardId shardId = new ShardId(in);
            String indexPattern = in.getTransportVersion().supports(JOIN_ON_ALIASES) ? in.readString() : shardId.getIndexName();
            DataType inputDataType = DataType.fromTypeName((String)in.readString());
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                inputPage = new Page((StreamInput)bsi);
            }
            PlanStreamInput planIn = new PlanStreamInput(in, in.namedWriteableRegistry(), null);
            List extractFields = planIn.readNamedWriteableCollectionAsList(NamedExpression.class);
            String matchField = in.readString();
            Source source = Source.EMPTY;
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_17_0)) {
                source = Source.readFrom((StreamInput)planIn);
            }
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_LOOKUP_JOIN_SOURCE_TEXT)) {
                String sourceText = in.readString();
                source = new Source(source.source(), sourceText);
            }
            TransportRequest result = new TransportRequest(sessionId, shardId, indexPattern, inputDataType, inputPage, inputPage, extractFields, matchField, source);
            result.setParentTask(parentTaskId);
            return result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sessionId);
            out.writeWriteable((Writeable)this.shardId);
            if (out.getTransportVersion().supports(JOIN_ON_ALIASES)) {
                out.writeString(this.indexPattern);
            } else if (!this.indexPattern.equals(this.shardId.getIndexName())) {
                throw new EsqlIllegalArgumentException("Aliases and index patterns are not allowed for LOOKUP JOIN [{}]", this.indexPattern);
            }
            out.writeString(this.inputDataType.typeName());
            out.writeWriteable((Writeable)this.inputPage);
            PlanStreamOutput planOut = new PlanStreamOutput(out, null);
            planOut.writeNamedWriteableCollection(this.extractFields);
            out.writeString(this.matchField);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_17_0)) {
                this.source.writeTo((StreamOutput)planOut);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_LOOKUP_JOIN_SOURCE_TEXT)) {
                out.writeString(this.source.text());
            }
        }

        @Override
        protected String extraDescription() {
            return " ,match_field=" + this.matchField;
        }
    }

    public static class Request
    extends AbstractLookupService.Request {
        private final String matchField;

        Request(String sessionId, String index, String indexPattern, DataType inputDataType, String matchField, Page inputPage, List<NamedExpression> extractFields, Source source) {
            super(sessionId, index, indexPattern, inputDataType, inputPage, extractFields, source);
            this.matchField = matchField;
        }
    }

    protected static class LookupResponse
    extends AbstractLookupService.LookupResponse {
        private List<Page> pages;

        LookupResponse(List<Page> pages, BlockFactory blockFactory) {
            super(blockFactory);
            this.pages = pages;
        }

        LookupResponse(StreamInput in, BlockFactory blockFactory) throws IOException {
            super(blockFactory);
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                this.pages = bsi.readCollectionAsList(Page::new);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            long bytes = this.pages.stream().mapToLong(Page::ramBytesUsedByBlocks).sum();
            this.blockFactory.breaker().addEstimateBytesAndMaybeBreak(bytes, "serialize lookup join response");
            this.reservedBytes += bytes;
            out.writeCollection(this.pages);
        }

        @Override
        protected List<Page> takePages() {
            List<Page> p = this.pages;
            this.pages = null;
            return p;
        }

        List<Page> pages() {
            return this.pages;
        }

        @Override
        protected void innerRelease() {
            if (this.pages != null) {
                Releasables.closeExpectNoException((Releasable)Releasables.wrap((Iterator)Iterators.map(this.pages.iterator(), page -> () -> ((Page)page).releaseBlocks())));
            }
        }

        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            LookupResponse that = (LookupResponse)((Object)o);
            return Objects.equals(this.pages, that.pages);
        }

        public int hashCode() {
            return Objects.hashCode(this.pages);
        }

        public String toString() {
            return "LookupResponse{pages=" + String.valueOf(this.pages) + "}";
        }
    }
}

