/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class DeleteShutdownNodeAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteShutdownNodeAction INSTANCE = new DeleteShutdownNodeAction();
    public static final String NAME = "cluster:admin/shutdown/delete";

    public DeleteShutdownNodeAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String nodeId;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String nodeId) {
            super(masterNodeTimeout, ackTimeout);
            this.nodeId = nodeId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.nodeId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public ActionRequestValidationException validate() {
            if (!Strings.hasText((String)this.nodeId)) {
                ActionRequestValidationException arve = new ActionRequestValidationException();
                arve.addValidationError("the node id to remove from shutdown is required");
                return arve;
            }
            return null;
        }
    }
}

