/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.Objects;
import java.util.OptionalInt;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RatedSearchHit
implements Writeable,
ToXContentObject {
    private final SearchHit searchHit;
    private final OptionalInt rating;

    public RatedSearchHit(SearchHit searchHit, OptionalInt rating) {
        this.searchHit = searchHit.asUnpooled();
        this.rating = rating;
    }

    RatedSearchHit(StreamInput in) throws IOException {
        this(SearchHit.readFrom((StreamInput)in, (boolean)false), in.readBoolean() ? OptionalInt.of(in.readVInt()) : OptionalInt.empty());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.searchHit.writeTo(out);
        out.writeBoolean(this.rating.isPresent());
        if (this.rating.isPresent()) {
            out.writeVInt(this.rating.getAsInt());
        }
    }

    public SearchHit getSearchHit() {
        return this.searchHit;
    }

    public OptionalInt getRating() {
        return this.rating;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("hit", (ToXContent)this.searchHit);
        builder.field("rating", this.rating.isPresent() ? Integer.valueOf(this.rating.getAsInt()) : null);
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RatedSearchHit other = (RatedSearchHit)obj;
        return Objects.equals(this.rating, other.rating) && Objects.equals(this.searchHit, other.searchHit);
    }

    public final int hashCode() {
        return Objects.hash(this.rating, this.searchHit);
    }
}

