/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.painless.Def;
import org.elasticsearch.painless.DefBootstrap;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.api.ValueIterator;
import org.elasticsearch.painless.ir.ArgumentsNode;
import org.elasticsearch.painless.ir.BinaryImplNode;
import org.elasticsearch.painless.ir.BinaryMathNode;
import org.elasticsearch.painless.ir.BlockNode;
import org.elasticsearch.painless.ir.BooleanNode;
import org.elasticsearch.painless.ir.BreakNode;
import org.elasticsearch.painless.ir.CastNode;
import org.elasticsearch.painless.ir.CatchNode;
import org.elasticsearch.painless.ir.ClassNode;
import org.elasticsearch.painless.ir.ComparisonNode;
import org.elasticsearch.painless.ir.ConditionNode;
import org.elasticsearch.painless.ir.ConditionalNode;
import org.elasticsearch.painless.ir.ConstantNode;
import org.elasticsearch.painless.ir.ContinueNode;
import org.elasticsearch.painless.ir.DeclarationBlockNode;
import org.elasticsearch.painless.ir.DeclarationNode;
import org.elasticsearch.painless.ir.DefInterfaceReferenceNode;
import org.elasticsearch.painless.ir.DoWhileLoopNode;
import org.elasticsearch.painless.ir.DupNode;
import org.elasticsearch.painless.ir.ElvisNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.FieldNode;
import org.elasticsearch.painless.ir.FlipArrayIndexNode;
import org.elasticsearch.painless.ir.FlipCollectionIndexNode;
import org.elasticsearch.painless.ir.FlipDefIndexNode;
import org.elasticsearch.painless.ir.ForEachLoopNode;
import org.elasticsearch.painless.ir.ForEachSubArrayNode;
import org.elasticsearch.painless.ir.ForEachSubIterableNode;
import org.elasticsearch.painless.ir.ForLoopNode;
import org.elasticsearch.painless.ir.FunctionNode;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.ir.IfElseNode;
import org.elasticsearch.painless.ir.IfNode;
import org.elasticsearch.painless.ir.InstanceofNode;
import org.elasticsearch.painless.ir.InvokeCallDefNode;
import org.elasticsearch.painless.ir.InvokeCallMemberNode;
import org.elasticsearch.painless.ir.InvokeCallNode;
import org.elasticsearch.painless.ir.ListInitializationNode;
import org.elasticsearch.painless.ir.LoadBraceDefNode;
import org.elasticsearch.painless.ir.LoadBraceNode;
import org.elasticsearch.painless.ir.LoadDotArrayLengthNode;
import org.elasticsearch.painless.ir.LoadDotDefNode;
import org.elasticsearch.painless.ir.LoadDotNode;
import org.elasticsearch.painless.ir.LoadDotShortcutNode;
import org.elasticsearch.painless.ir.LoadFieldMemberNode;
import org.elasticsearch.painless.ir.LoadListShortcutNode;
import org.elasticsearch.painless.ir.LoadMapShortcutNode;
import org.elasticsearch.painless.ir.LoadVariableNode;
import org.elasticsearch.painless.ir.MapInitializationNode;
import org.elasticsearch.painless.ir.NewArrayNode;
import org.elasticsearch.painless.ir.NewObjectNode;
import org.elasticsearch.painless.ir.NullNode;
import org.elasticsearch.painless.ir.NullSafeSubNode;
import org.elasticsearch.painless.ir.ReturnNode;
import org.elasticsearch.painless.ir.StatementExpressionNode;
import org.elasticsearch.painless.ir.StatementNode;
import org.elasticsearch.painless.ir.StaticNode;
import org.elasticsearch.painless.ir.StoreBraceDefNode;
import org.elasticsearch.painless.ir.StoreBraceNode;
import org.elasticsearch.painless.ir.StoreDotDefNode;
import org.elasticsearch.painless.ir.StoreDotNode;
import org.elasticsearch.painless.ir.StoreDotShortcutNode;
import org.elasticsearch.painless.ir.StoreListShortcutNode;
import org.elasticsearch.painless.ir.StoreMapShortcutNode;
import org.elasticsearch.painless.ir.StoreVariableNode;
import org.elasticsearch.painless.ir.StringConcatenationNode;
import org.elasticsearch.painless.ir.ThrowNode;
import org.elasticsearch.painless.ir.TryNode;
import org.elasticsearch.painless.ir.TypedCaptureReferenceNode;
import org.elasticsearch.painless.ir.TypedInterfaceReferenceNode;
import org.elasticsearch.painless.ir.UnaryMathNode;
import org.elasticsearch.painless.ir.UnaryNode;
import org.elasticsearch.painless.ir.WhileLoopNode;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ANode;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.EAssignment;
import org.elasticsearch.painless.node.EBinary;
import org.elasticsearch.painless.node.EBooleanComp;
import org.elasticsearch.painless.node.EBooleanConstant;
import org.elasticsearch.painless.node.EBrace;
import org.elasticsearch.painless.node.ECall;
import org.elasticsearch.painless.node.ECallLocal;
import org.elasticsearch.painless.node.EComp;
import org.elasticsearch.painless.node.EConditional;
import org.elasticsearch.painless.node.EDecimal;
import org.elasticsearch.painless.node.EDot;
import org.elasticsearch.painless.node.EElvis;
import org.elasticsearch.painless.node.EExplicit;
import org.elasticsearch.painless.node.EFunctionRef;
import org.elasticsearch.painless.node.EInstanceof;
import org.elasticsearch.painless.node.ELambda;
import org.elasticsearch.painless.node.EListInit;
import org.elasticsearch.painless.node.EMapInit;
import org.elasticsearch.painless.node.ENewArray;
import org.elasticsearch.painless.node.ENewArrayFunctionRef;
import org.elasticsearch.painless.node.ENewObj;
import org.elasticsearch.painless.node.ENull;
import org.elasticsearch.painless.node.ENumeric;
import org.elasticsearch.painless.node.ERegex;
import org.elasticsearch.painless.node.EString;
import org.elasticsearch.painless.node.ESymbol;
import org.elasticsearch.painless.node.EUnary;
import org.elasticsearch.painless.node.SBlock;
import org.elasticsearch.painless.node.SBreak;
import org.elasticsearch.painless.node.SCatch;
import org.elasticsearch.painless.node.SClass;
import org.elasticsearch.painless.node.SContinue;
import org.elasticsearch.painless.node.SDeclBlock;
import org.elasticsearch.painless.node.SDeclaration;
import org.elasticsearch.painless.node.SDo;
import org.elasticsearch.painless.node.SEach;
import org.elasticsearch.painless.node.SExpression;
import org.elasticsearch.painless.node.SFor;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.node.SIf;
import org.elasticsearch.painless.node.SIfElse;
import org.elasticsearch.painless.node.SReturn;
import org.elasticsearch.painless.node.SThrow;
import org.elasticsearch.painless.node.STry;
import org.elasticsearch.painless.node.SWhile;
import org.elasticsearch.painless.phase.UserTreeVisitor;
import org.elasticsearch.painless.symbol.Decorations;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.IRDecorations;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.elasticsearch.painless.symbol.SemanticScope;

public class DefaultUserTreeToIRTreePhase
implements UserTreeVisitor<ScriptScope> {
    protected ClassNode irClassNode;

    protected void injectBootstrapMethod(ScriptScope scriptScope) {
        Location internalLocation = new Location("$internal$injectStaticFields", 0);
        int modifiers = 9;
        FieldNode irFieldNode = new FieldNode(internalLocation);
        irFieldNode.attachDecoration(new IRDecorations.IRDModifiers(modifiers));
        irFieldNode.attachDecoration(new IRDecorations.IRDFieldType(PainlessLookup.class));
        irFieldNode.attachDecoration(new IRDecorations.IRDName("$DEFINITION"));
        this.irClassNode.addFieldNode(irFieldNode);
        irFieldNode = new FieldNode(internalLocation);
        irFieldNode.attachDecoration(new IRDecorations.IRDModifiers(modifiers));
        irFieldNode.attachDecoration(new IRDecorations.IRDFieldType(FunctionTable.class));
        irFieldNode.attachDecoration(new IRDecorations.IRDName("$FUNCTIONS"));
        this.irClassNode.addFieldNode(irFieldNode);
        irFieldNode = new FieldNode(internalLocation);
        irFieldNode.attachDecoration(new IRDecorations.IRDModifiers(modifiers));
        irFieldNode.attachDecoration(new IRDecorations.IRDFieldType(Map.class));
        irFieldNode.attachDecoration(new IRDecorations.IRDName("$COMPILERSETTINGS"));
        this.irClassNode.addFieldNode(irFieldNode);
        internalLocation = new Location("$internal$injectDefBootstrapMethod", 0);
        try {
            FunctionNode irFunctionNode = new FunctionNode(internalLocation);
            irFunctionNode.attachDecoration(new IRDecorations.IRDName("$bootstrapDef"));
            irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(CallSite.class));
            irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(List.of(MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class)));
            irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(List.of("methodHandlesLookup", "name", "type", "initialDepth", "flavor", "args")));
            irFunctionNode.attachCondition(IRDecorations.IRCStatic.class);
            irFunctionNode.attachCondition(IRDecorations.IRCVarArgs.class);
            irFunctionNode.attachCondition(IRDecorations.IRCSynthetic.class);
            irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(0));
            this.irClassNode.addFunctionNode(irFunctionNode);
            BlockNode blockNode = new BlockNode(internalLocation);
            blockNode.attachCondition(IRDecorations.IRCAllEscape.class);
            irFunctionNode.setBlockNode(blockNode);
            ReturnNode returnNode = new ReturnNode(internalLocation);
            blockNode.addStatementNode(returnNode);
            BinaryImplNode irBinaryImplNode = new BinaryImplNode(internalLocation);
            irBinaryImplNode.attachDecoration(new IRDecorations.IRDExpressionType(CallSite.class));
            returnNode.setExpressionNode(irBinaryImplNode);
            StaticNode staticNode = new StaticNode(internalLocation);
            staticNode.attachDecoration(new IRDecorations.IRDExpressionType(DefBootstrap.class));
            irBinaryImplNode.setLeftNode(staticNode);
            InvokeCallNode invokeCallNode = new InvokeCallNode(internalLocation);
            invokeCallNode.attachDecoration(new IRDecorations.IRDExpressionType(CallSite.class));
            invokeCallNode.setMethod(new PainlessMethod(DefBootstrap.class.getMethod("bootstrap", PainlessLookup.class, FunctionTable.class, Map.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class), DefBootstrap.class, CallSite.class, Arrays.asList(PainlessLookup.class, FunctionTable.class, Map.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class), null, null, Map.of()));
            invokeCallNode.setBox(DefBootstrap.class);
            irBinaryImplNode.setRightNode(invokeCallNode);
            LoadFieldMemberNode irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
            irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(PainlessLookup.class));
            irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDName("$DEFINITION"));
            irLoadFieldMemberNode.attachCondition(IRDecorations.IRCStatic.class);
            invokeCallNode.addArgumentNode(irLoadFieldMemberNode);
            irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
            irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(FunctionTable.class));
            irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDName("$FUNCTIONS"));
            irLoadFieldMemberNode.attachCondition(IRDecorations.IRCStatic.class);
            invokeCallNode.addArgumentNode(irLoadFieldMemberNode);
            irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
            irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(Map.class));
            irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDName("$COMPILERSETTINGS"));
            irLoadFieldMemberNode.attachCondition(IRDecorations.IRCStatic.class);
            invokeCallNode.addArgumentNode(irLoadFieldMemberNode);
            LoadVariableNode irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(MethodHandles.Lookup.class));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("methodHandlesLookup"));
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("name"));
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(MethodType.class));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("type"));
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(Integer.TYPE));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("initialDepth"));
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(Integer.TYPE));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("flavor"));
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(Object[].class));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("args"));
            invokeCallNode.addArgumentNode(irLoadVariableNode);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    protected ExpressionNode injectCast(AExpression userExpressionNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode = (ExpressionNode)this.visit(userExpressionNode, scriptScope);
        if (irExpressionNode == null) {
            return null;
        }
        Decorations.ExpressionPainlessCast expressionPainlessCast = scriptScope.getDecoration(userExpressionNode, Decorations.ExpressionPainlessCast.class);
        if (expressionPainlessCast == null) {
            return irExpressionNode;
        }
        PainlessCast painlessCast = expressionPainlessCast.expressionPainlessCast();
        Class<?> targetType = painlessCast.targetType;
        if (painlessCast.boxTargetType != null) {
            targetType = PainlessLookupUtility.typeToBoxedType(painlessCast.boxTargetType);
        } else if (painlessCast.unboxTargetType != null) {
            targetType = painlessCast.unboxTargetType;
        }
        CastNode irCastNode = new CastNode(irExpressionNode.getLocation());
        irCastNode.attachDecoration(new IRDecorations.IRDExpressionType(targetType));
        irCastNode.attachDecoration(new IRDecorations.IRDCast(painlessCast));
        irCastNode.setChildNode(irExpressionNode);
        return irCastNode;
    }

    protected static ExpressionNode buildLoadStore(int accessDepth, Location location, boolean isNullSafe, ExpressionNode irPrefixNode, ExpressionNode irIndexNode, ExpressionNode irLoadNode, UnaryNode irStoreNode) {
        ExpressionNode irExpressionNode;
        ExpressionNode expressionNode = irExpressionNode = irLoadNode != null ? irLoadNode : irStoreNode;
        if (irPrefixNode != null) {
            BinaryImplNode binaryImplNode;
            if (irIndexNode != null) {
                binaryImplNode = new BinaryImplNode(location);
                if (isNullSafe) {
                    binaryImplNode.attachDecoration(new IRDecorations.IRDExpressionType((Class)irExpressionNode.getDecorationValue(IRDecorations.IRDExpressionType.class)));
                    binaryImplNode.setLeftNode(irIndexNode);
                    binaryImplNode.setRightNode(irExpressionNode);
                    irExpressionNode = binaryImplNode;
                } else {
                    binaryImplNode.attachDecoration(new IRDecorations.IRDExpressionType(Void.TYPE));
                    binaryImplNode.setLeftNode(irPrefixNode);
                    binaryImplNode.setRightNode(irIndexNode);
                    irPrefixNode = binaryImplNode;
                }
            }
            if (irLoadNode != null && irStoreNode != null) {
                DupNode dupNode = new DupNode(location);
                dupNode.attachDecoration(new IRDecorations.IRDExpressionType(Void.TYPE));
                dupNode.attachDecoration(new IRDecorations.IRDSize(accessDepth));
                dupNode.setChildNode(irPrefixNode);
                irPrefixNode = dupNode;
            }
            binaryImplNode = new BinaryImplNode(location);
            binaryImplNode.attachDecoration(irExpressionNode.getDecoration(IRDecorations.IRDExpressionType.class));
            if (isNullSafe) {
                NullSafeSubNode irNullSafeSubNode = new NullSafeSubNode(location);
                irNullSafeSubNode.attachDecoration(irExpressionNode.getDecoration(IRDecorations.IRDExpressionType.class));
                irNullSafeSubNode.setChildNode(irExpressionNode);
                binaryImplNode.setLeftNode(irPrefixNode);
                binaryImplNode.setRightNode(irNullSafeSubNode);
            } else {
                binaryImplNode.setLeftNode(irPrefixNode);
                binaryImplNode.setRightNode(irExpressionNode);
            }
            irExpressionNode = binaryImplNode;
        }
        if (irLoadNode != null && irStoreNode != null) {
            irStoreNode.setChildNode(irExpressionNode);
            irExpressionNode = irStoreNode;
        }
        return irExpressionNode;
    }

    protected IRNode visit(ANode userNode, ScriptScope scriptScope) {
        if (userNode == null) {
            return null;
        }
        userNode.visit(this, scriptScope);
        return scriptScope.getDecoration(userNode, Decorations.IRNodeDecoration.class).irNode();
    }

    @Override
    public void visitClass(SClass userClassNode, ScriptScope scriptScope) {
        this.irClassNode = new ClassNode(userClassNode.getLocation());
        for (SFunction userFunctionNode : userClassNode.getFunctionNodes()) {
            this.irClassNode.addFunctionNode((FunctionNode)this.visit(userFunctionNode, scriptScope));
        }
        this.irClassNode.setScriptScope(scriptScope);
        this.injectBootstrapMethod(scriptScope);
        scriptScope.putDecoration(userClassNode, new Decorations.IRNodeDecoration(this.irClassNode));
    }

    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scriptScope) {
        String functionName = userFunctionNode.getFunctionName();
        int functionArity = userFunctionNode.getCanonicalTypeNameParameters().size();
        FunctionTable.LocalFunction localFunction = scriptScope.getFunctionTable().getFunction(functionName, functionArity);
        Class<?> returnType = localFunction.getReturnType();
        boolean methodEscape = scriptScope.getCondition(userFunctionNode, Decorations.MethodEscape.class);
        BlockNode irBlockNode = (BlockNode)this.visit(userFunctionNode.getBlockNode(), scriptScope);
        if (!methodEscape) {
            ExpressionNode irExpressionNode;
            if (returnType == Void.TYPE) {
                irExpressionNode = null;
            } else if (userFunctionNode.isAutoReturnEnabled()) {
                if (returnType.isPrimitive()) {
                    ConstantNode irConstantNode = new ConstantNode(userFunctionNode.getLocation());
                    irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(returnType));
                    if (returnType == Boolean.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)false));
                    } else if (returnType == Byte.TYPE || returnType == Character.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)0));
                    } else if (returnType == Long.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)0L));
                    } else if (returnType == Float.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(0.0f)));
                    } else if (returnType == Double.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)0.0));
                    } else {
                        throw userFunctionNode.createError(new IllegalStateException("illegal tree structure"));
                    }
                    irExpressionNode = irConstantNode;
                } else {
                    irExpressionNode = new NullNode(userFunctionNode.getLocation());
                    irExpressionNode.attachDecoration(new IRDecorations.IRDExpressionType(returnType));
                }
            } else {
                throw userFunctionNode.createError(new IllegalStateException("illegal tree structure"));
            }
            ReturnNode irReturnNode = new ReturnNode(userFunctionNode.getLocation());
            irReturnNode.setExpressionNode(irExpressionNode);
            irBlockNode.addStatementNode(irReturnNode);
        }
        FunctionNode irFunctionNode = new FunctionNode(userFunctionNode.getLocation());
        irFunctionNode.setBlockNode(irBlockNode);
        String mangledName = scriptScope.getFunctionTable().getFunction(userFunctionNode.getFunctionName(), userFunctionNode.getCanonicalTypeNameParameters().size()).getMangledName();
        irFunctionNode.attachDecoration(new IRDecorations.IRDName(mangledName));
        irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(returnType));
        irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(localFunction.getTypeParameters()));
        irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(userFunctionNode.getParameterNames()));
        if (userFunctionNode.isStatic()) {
            irFunctionNode.attachCondition(IRDecorations.IRCStatic.class);
        }
        if (userFunctionNode.isSynthetic()) {
            irFunctionNode.attachCondition(IRDecorations.IRCSynthetic.class);
        }
        irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(scriptScope.getCompilerSettings().getMaxLoopCounter()));
        scriptScope.putDecoration(userFunctionNode, new Decorations.IRNodeDecoration(irFunctionNode));
    }

    @Override
    public void visitBlock(SBlock userBlockNode, ScriptScope scriptScope) {
        BlockNode irBlockNode = new BlockNode(userBlockNode.getLocation());
        for (AStatement userStatementNode : userBlockNode.getStatementNodes()) {
            irBlockNode.addStatementNode((StatementNode)this.visit(userStatementNode, scriptScope));
        }
        if (scriptScope.getCondition(userBlockNode, Decorations.AllEscape.class)) {
            irBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
        }
        scriptScope.putDecoration(userBlockNode, new Decorations.IRNodeDecoration(irBlockNode));
    }

    @Override
    public void visitIf(SIf userIfNode, ScriptScope scriptScope) {
        IfNode irIfNode = new IfNode(userIfNode.getLocation());
        irIfNode.setConditionNode(this.injectCast(userIfNode.getConditionNode(), scriptScope));
        irIfNode.setBlockNode((BlockNode)this.visit(userIfNode.getIfBlockNode(), scriptScope));
        scriptScope.putDecoration(userIfNode, new Decorations.IRNodeDecoration(irIfNode));
    }

    @Override
    public void visitIfElse(SIfElse userIfElseNode, ScriptScope scriptScope) {
        IfElseNode irIfElseNode = new IfElseNode(userIfElseNode.getLocation());
        irIfElseNode.setConditionNode(this.injectCast(userIfElseNode.getConditionNode(), scriptScope));
        irIfElseNode.setBlockNode((BlockNode)this.visit(userIfElseNode.getIfBlockNode(), scriptScope));
        irIfElseNode.setElseBlockNode((BlockNode)this.visit(userIfElseNode.getElseBlockNode(), scriptScope));
        scriptScope.putDecoration(userIfElseNode, new Decorations.IRNodeDecoration(irIfElseNode));
    }

    @Override
    public void visitWhile(SWhile userWhileNode, ScriptScope scriptScope) {
        WhileLoopNode irWhileLoopNode = new WhileLoopNode(userWhileNode.getLocation());
        irWhileLoopNode.setConditionNode(this.injectCast(userWhileNode.getConditionNode(), scriptScope));
        irWhileLoopNode.setBlockNode((BlockNode)this.visit(userWhileNode.getBlockNode(), scriptScope));
        if (scriptScope.getCondition(userWhileNode, Decorations.ContinuousLoop.class)) {
            irWhileLoopNode.attachCondition(IRDecorations.IRCContinuous.class);
        }
        scriptScope.putDecoration(userWhileNode, new Decorations.IRNodeDecoration(irWhileLoopNode));
    }

    @Override
    public void visitDo(SDo userDoNode, ScriptScope scriptScope) {
        DoWhileLoopNode irDoWhileLoopNode = new DoWhileLoopNode(userDoNode.getLocation());
        irDoWhileLoopNode.setConditionNode(this.injectCast(userDoNode.getConditionNode(), scriptScope));
        irDoWhileLoopNode.setBlockNode((BlockNode)this.visit(userDoNode.getBlockNode(), scriptScope));
        if (scriptScope.getCondition(userDoNode, Decorations.ContinuousLoop.class)) {
            irDoWhileLoopNode.attachCondition(IRDecorations.IRCContinuous.class);
        }
        scriptScope.putDecoration(userDoNode, new Decorations.IRNodeDecoration(irDoWhileLoopNode));
    }

    @Override
    public void visitFor(SFor userForNode, ScriptScope scriptScope) {
        ForLoopNode irForLoopNode = new ForLoopNode(userForNode.getLocation());
        irForLoopNode.setInitializerNode(this.visit(userForNode.getInitializerNode(), scriptScope));
        irForLoopNode.setConditionNode(this.injectCast(userForNode.getConditionNode(), scriptScope));
        irForLoopNode.setAfterthoughtNode((ExpressionNode)this.visit(userForNode.getAfterthoughtNode(), scriptScope));
        irForLoopNode.setBlockNode((BlockNode)this.visit(userForNode.getBlockNode(), scriptScope));
        if (scriptScope.getCondition(userForNode, Decorations.ContinuousLoop.class)) {
            irForLoopNode.attachCondition(IRDecorations.IRCContinuous.class);
        }
        scriptScope.putDecoration(userForNode, new Decorations.IRNodeDecoration(irForLoopNode));
    }

    @Override
    public void visitEach(SEach userEachNode, ScriptScope scriptScope) {
        ConditionNode irConditionNode;
        SemanticScope.Variable variable = scriptScope.getDecoration(userEachNode, Decorations.SemanticVariable.class).semanticVariable();
        PainlessCast painlessCast = scriptScope.hasDecoration(userEachNode, Decorations.ExpressionPainlessCast.class) ? scriptScope.getDecoration(userEachNode, Decorations.ExpressionPainlessCast.class).expressionPainlessCast() : null;
        ExpressionNode irIterableNode = (ExpressionNode)this.visit(userEachNode.getIterableNode(), scriptScope);
        Class<?> iterableValueType = scriptScope.getDecoration(userEachNode.getIterableNode(), Decorations.ValueType.class).valueType();
        BlockNode irBlockNode = (BlockNode)this.visit(userEachNode.getBlockNode(), scriptScope);
        if (iterableValueType.isArray()) {
            ForEachSubArrayNode irForEachSubArrayNode = new ForEachSubArrayNode(userEachNode.getLocation());
            irForEachSubArrayNode.setConditionNode(irIterableNode);
            irForEachSubArrayNode.setBlockNode(irBlockNode);
            irForEachSubArrayNode.attachDecoration(new IRDecorations.IRDVariableType(variable.type()));
            irForEachSubArrayNode.attachDecoration(new IRDecorations.IRDVariableName(variable.name()));
            irForEachSubArrayNode.attachDecoration(new IRDecorations.IRDArrayType(iterableValueType));
            irForEachSubArrayNode.attachDecoration(new IRDecorations.IRDArrayName("#array" + userEachNode.getLocation().getOffset()));
            irForEachSubArrayNode.attachDecoration(new IRDecorations.IRDIndexType(Integer.TYPE));
            irForEachSubArrayNode.attachDecoration(new IRDecorations.IRDIndexName("#index" + userEachNode.getLocation().getOffset()));
            irForEachSubArrayNode.attachDecoration(new IRDecorations.IRDIndexedType(iterableValueType.getComponentType()));
            if (painlessCast != null) {
                irForEachSubArrayNode.attachDecoration(new IRDecorations.IRDCast(painlessCast));
            }
            irConditionNode = irForEachSubArrayNode;
        } else if (iterableValueType == def.class || Iterable.class.isAssignableFrom(iterableValueType)) {
            ForEachSubIterableNode irForEachSubIterableNode = new ForEachSubIterableNode(userEachNode.getLocation());
            irForEachSubIterableNode.setConditionNode(irIterableNode);
            irForEachSubIterableNode.setBlockNode(irBlockNode);
            irForEachSubIterableNode.attachDecoration(new IRDecorations.IRDVariableType(variable.type()));
            irForEachSubIterableNode.attachDecoration(new IRDecorations.IRDVariableName(variable.name()));
            irForEachSubIterableNode.attachDecoration(new IRDecorations.IRDIterableName("#itr" + userEachNode.getLocation().getOffset()));
            if (iterableValueType != def.class) {
                irForEachSubIterableNode.attachDecoration(new IRDecorations.IRDIterableType(Iterator.class));
                irForEachSubIterableNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userEachNode, Decorations.IterablePainlessMethod.class).iterablePainlessMethod()));
                if (painlessCast != null) {
                    irForEachSubIterableNode.attachDecoration(new IRDecorations.IRDCast(painlessCast));
                }
            } else {
                irForEachSubIterableNode.attachDecoration(new IRDecorations.IRDIterableType(ValueIterator.class));
                if (painlessCast != null && !variable.type().isPrimitive()) {
                    irForEachSubIterableNode.attachDecoration(new IRDecorations.IRDCast(painlessCast));
                }
            }
            irConditionNode = irForEachSubIterableNode;
        } else {
            throw userEachNode.createError(new IllegalStateException("illegal tree structure"));
        }
        ForEachLoopNode irForEachLoopNode = new ForEachLoopNode(userEachNode.getLocation());
        irForEachLoopNode.setConditionNode(irConditionNode);
        scriptScope.putDecoration(userEachNode, new Decorations.IRNodeDecoration(irForEachLoopNode));
    }

    @Override
    public void visitDeclBlock(SDeclBlock userDeclBlockNode, ScriptScope scriptScope) {
        DeclarationBlockNode irDeclarationBlockNode = new DeclarationBlockNode(userDeclBlockNode.getLocation());
        for (SDeclaration userDeclarationNode : userDeclBlockNode.getDeclarationNodes()) {
            irDeclarationBlockNode.addDeclarationNode((DeclarationNode)this.visit(userDeclarationNode, scriptScope));
        }
        scriptScope.putDecoration(userDeclBlockNode, new Decorations.IRNodeDecoration(irDeclarationBlockNode));
    }

    @Override
    public void visitDeclaration(SDeclaration userDeclarationNode, ScriptScope scriptScope) {
        SemanticScope.Variable variable = scriptScope.getDecoration(userDeclarationNode, Decorations.SemanticVariable.class).semanticVariable();
        DeclarationNode irDeclarationNode = new DeclarationNode(userDeclarationNode.getLocation());
        irDeclarationNode.setExpressionNode(this.injectCast(userDeclarationNode.getValueNode(), scriptScope));
        irDeclarationNode.attachDecoration(new IRDecorations.IRDDeclarationType(variable.type()));
        irDeclarationNode.attachDecoration(new IRDecorations.IRDName(variable.name()));
        scriptScope.putDecoration(userDeclarationNode, new Decorations.IRNodeDecoration(irDeclarationNode));
    }

    @Override
    public void visitReturn(SReturn userReturnNode, ScriptScope scriptScope) {
        ReturnNode irReturnNode = new ReturnNode(userReturnNode.getLocation());
        irReturnNode.setExpressionNode(this.injectCast(userReturnNode.getValueNode(), scriptScope));
        scriptScope.putDecoration(userReturnNode, new Decorations.IRNodeDecoration(irReturnNode));
    }

    @Override
    public void visitExpression(SExpression userExpressionNode, ScriptScope scriptScope) {
        StatementNode irStatementNode;
        ExpressionNode irExpressionNode = this.injectCast(userExpressionNode.getStatementNode(), scriptScope);
        if (scriptScope.getCondition(userExpressionNode, Decorations.MethodEscape.class)) {
            ReturnNode irReturnNode = new ReturnNode(userExpressionNode.getLocation());
            irReturnNode.setExpressionNode(irExpressionNode);
            irStatementNode = irReturnNode;
        } else {
            StatementExpressionNode irStatementExpressionNode = new StatementExpressionNode(userExpressionNode.getLocation());
            irStatementExpressionNode.setExpressionNode(irExpressionNode);
            irStatementNode = irStatementExpressionNode;
        }
        scriptScope.putDecoration(userExpressionNode, new Decorations.IRNodeDecoration(irStatementNode));
    }

    @Override
    public void visitTry(STry userTryNode, ScriptScope scriptScope) {
        TryNode irTryNode = new TryNode(userTryNode.getLocation());
        for (SCatch userCatchNode : userTryNode.getCatchNodes()) {
            irTryNode.addCatchNode((CatchNode)this.visit(userCatchNode, scriptScope));
        }
        irTryNode.setBlockNode((BlockNode)this.visit(userTryNode.getBlockNode(), scriptScope));
        scriptScope.putDecoration(userTryNode, new Decorations.IRNodeDecoration(irTryNode));
    }

    @Override
    public void visitCatch(SCatch userCatchNode, ScriptScope scriptScope) {
        SemanticScope.Variable variable = scriptScope.getDecoration(userCatchNode, Decorations.SemanticVariable.class).semanticVariable();
        CatchNode irCatchNode = new CatchNode(userCatchNode.getLocation());
        irCatchNode.attachDecoration(new IRDecorations.IRDExceptionType(variable.type()));
        irCatchNode.attachDecoration(new IRDecorations.IRDSymbol(variable.name()));
        irCatchNode.setBlockNode((BlockNode)this.visit(userCatchNode.getBlockNode(), scriptScope));
        scriptScope.putDecoration(userCatchNode, new Decorations.IRNodeDecoration(irCatchNode));
    }

    @Override
    public void visitThrow(SThrow userThrowNode, ScriptScope scriptScope) {
        ThrowNode irThrowNode = new ThrowNode(userThrowNode.getLocation());
        irThrowNode.setExpressionNode(this.injectCast(userThrowNode.getExpressionNode(), scriptScope));
        scriptScope.putDecoration(userThrowNode, new Decorations.IRNodeDecoration(irThrowNode));
    }

    @Override
    public void visitContinue(SContinue userContinueNode, ScriptScope scriptScope) {
        ContinueNode irContinueNode = new ContinueNode(userContinueNode.getLocation());
        scriptScope.putDecoration(userContinueNode, new Decorations.IRNodeDecoration(irContinueNode));
    }

    @Override
    public void visitBreak(SBreak userBreakNode, ScriptScope scriptScope) {
        BreakNode irBreakNode = new BreakNode(userBreakNode.getLocation());
        scriptScope.putDecoration(userBreakNode, new Decorations.IRNodeDecoration(irBreakNode));
    }

    @Override
    public void visitAssignment(EAssignment userAssignmentNode, ScriptScope scriptScope) {
        ExpressionNode irAssignmentNode;
        boolean read = scriptScope.getCondition(userAssignmentNode, Decorations.Read.class);
        Class<?> compoundType = scriptScope.hasDecoration(userAssignmentNode, Decorations.CompoundType.class) ? scriptScope.getDecoration(userAssignmentNode, Decorations.CompoundType.class).compoundType() : null;
        ExpressionNode irValueNode = this.injectCast(userAssignmentNode.getRightNode(), scriptScope);
        if (compoundType != null) {
            PainlessCast upcast;
            PainlessCast downcast;
            ExpressionNode irCompoundNode;
            boolean concatenate = userAssignmentNode.getOperation() == Operation.ADD && compoundType == String.class;
            scriptScope.setCondition(userAssignmentNode.getLeftNode(), Decorations.Compound.class);
            UnaryNode irStoreNode = (UnaryNode)this.visit(userAssignmentNode.getLeftNode(), scriptScope);
            ExpressionNode irLoadNode = irStoreNode.getChildNode();
            if (concatenate) {
                StringConcatenationNode stringConcatenationNode = new StringConcatenationNode(irStoreNode.getLocation());
                stringConcatenationNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irCompoundNode = stringConcatenationNode;
            } else {
                BinaryMathNode irBinaryMathNode = new BinaryMathNode(irStoreNode.getLocation());
                irBinaryMathNode.setLeftNode(irLoadNode);
                irBinaryMathNode.attachDecoration(new IRDecorations.IRDExpressionType(compoundType));
                irBinaryMathNode.attachDecoration(new IRDecorations.IRDOperation(userAssignmentNode.getOperation()));
                irBinaryMathNode.attachDecoration(new IRDecorations.IRDBinaryType(compoundType));
                irBinaryMathNode.attachDecoration(new IRDecorations.IRDFlags(2));
                irCompoundNode = irBinaryMathNode;
            }
            PainlessCast painlessCast = downcast = scriptScope.hasDecoration(userAssignmentNode, Decorations.DowncastPainlessCast.class) ? scriptScope.getDecoration(userAssignmentNode, Decorations.DowncastPainlessCast.class).downcastPainlessCast() : null;
            if (downcast == null) {
                irCompoundNode.attachDecoration(new IRDecorations.IRDExpressionType((Class)irStoreNode.getDecorationValue(IRDecorations.IRDStoreType.class)));
                irStoreNode.setChildNode(irCompoundNode);
            } else {
                CastNode irCastNode = new CastNode(irCompoundNode.getLocation());
                irCastNode.attachDecoration(new IRDecorations.IRDExpressionType(downcast.targetType));
                irCastNode.attachDecoration(new IRDecorations.IRDCast(downcast));
                irCastNode.setChildNode(irCompoundNode);
                irStoreNode.setChildNode(irCastNode);
            }
            if (read) {
                int accessDepth = scriptScope.getDecoration(userAssignmentNode.getLeftNode(), Decorations.AccessDepth.class).accessDepth();
                if (userAssignmentNode.postIfRead()) {
                    int size = MethodWriter.getType((Class)irLoadNode.getDecorationValue(IRDecorations.IRDExpressionType.class)).getSize();
                    irDupNode = new DupNode(irLoadNode.getLocation());
                    irDupNode.attachDecoration(irLoadNode.getDecoration(IRDecorations.IRDExpressionType.class));
                    irDupNode.attachDecoration(new IRDecorations.IRDSize(size));
                    irDupNode.attachDecoration(new IRDecorations.IRDDepth(accessDepth));
                    irDupNode.setChildNode(irLoadNode);
                    irLoadNode = irDupNode;
                } else {
                    int size = MethodWriter.getType((Class)irStoreNode.getDecorationValue(IRDecorations.IRDExpressionType.class)).getSize();
                    irDupNode = new DupNode(irStoreNode.getLocation());
                    irDupNode.attachDecoration(new IRDecorations.IRDExpressionType((Class)irStoreNode.getDecorationValue(IRDecorations.IRDStoreType.class)));
                    irDupNode.attachDecoration(new IRDecorations.IRDSize(size));
                    irDupNode.attachDecoration(new IRDecorations.IRDDepth(accessDepth));
                    irDupNode.setChildNode(irStoreNode.getChildNode());
                    irStoreNode.setChildNode(irDupNode);
                }
            }
            PainlessCast painlessCast2 = upcast = scriptScope.hasDecoration(userAssignmentNode, Decorations.UpcastPainlessCast.class) ? scriptScope.getDecoration(userAssignmentNode, Decorations.UpcastPainlessCast.class).upcastPainlessCast() : null;
            if (upcast != null) {
                CastNode irCastNode = new CastNode(irLoadNode.getLocation());
                irCastNode.attachDecoration(new IRDecorations.IRDExpressionType(upcast.targetType));
                irCastNode.attachDecoration(new IRDecorations.IRDCast(upcast));
                irCastNode.setChildNode(irLoadNode);
                irLoadNode = irCastNode;
            }
            if (concatenate) {
                ExpressionNode irStringConcatenationNode = irCompoundNode;
                ((ArgumentsNode)irStringConcatenationNode).addArgumentNode(irLoadNode);
                ((ArgumentsNode)irStringConcatenationNode).addArgumentNode(irValueNode);
            } else {
                BinaryMathNode irBinaryMathNode = (BinaryMathNode)irCompoundNode;
                irBinaryMathNode.setLeftNode(irLoadNode);
                irBinaryMathNode.setRightNode(irValueNode);
            }
            irAssignmentNode = irStoreNode;
        } else {
            irAssignmentNode = (ExpressionNode)this.visit(userAssignmentNode.getLeftNode(), scriptScope);
            if (read) {
                int size = MethodWriter.getType((Class)irValueNode.getDecorationValue(IRDecorations.IRDExpressionType.class)).getSize();
                int accessDepth = scriptScope.getDecoration(userAssignmentNode.getLeftNode(), Decorations.AccessDepth.class).accessDepth();
                DupNode irDupNode = new DupNode(irValueNode.getLocation());
                irDupNode.attachDecoration(irValueNode.getDecoration(IRDecorations.IRDExpressionType.class));
                irDupNode.attachDecoration(new IRDecorations.IRDSize(size));
                irDupNode.attachDecoration(new IRDecorations.IRDDepth(accessDepth));
                irDupNode.setChildNode(irValueNode);
                irValueNode = irDupNode;
            }
            if (irAssignmentNode instanceof BinaryImplNode) {
                BinaryImplNode bin = (BinaryImplNode)irAssignmentNode;
                ((UnaryNode)bin.getRightNode()).setChildNode(irValueNode);
            } else {
                ((UnaryNode)irAssignmentNode).setChildNode(irValueNode);
            }
        }
        scriptScope.putDecoration(userAssignmentNode, new Decorations.IRNodeDecoration(irAssignmentNode));
    }

    @Override
    public void visitUnary(EUnary userUnaryNode, ScriptScope scriptScope) {
        IRNode irNode;
        Class<?> unaryType;
        Class<?> clazz = unaryType = scriptScope.hasDecoration(userUnaryNode, Decorations.UnaryType.class) ? scriptScope.getDecoration(userUnaryNode, Decorations.UnaryType.class).unaryType() : null;
        if (scriptScope.getCondition(userUnaryNode.getChildNode(), Decorations.Negate.class)) {
            irNode = this.visit(userUnaryNode.getChildNode(), scriptScope);
        } else {
            UnaryMathNode irUnaryMathNode = new UnaryMathNode(userUnaryNode.getLocation());
            irUnaryMathNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userUnaryNode, Decorations.ValueType.class).valueType()));
            if (unaryType != null) {
                irUnaryMathNode.attachDecoration(new IRDecorations.IRDUnaryType(unaryType));
            }
            irUnaryMathNode.attachDecoration(new IRDecorations.IRDOperation(userUnaryNode.getOperation()));
            if (scriptScope.getCondition(userUnaryNode, Decorations.Explicit.class)) {
                irUnaryMathNode.attachDecoration(new IRDecorations.IRDFlags(4));
            }
            irUnaryMathNode.setChildNode(this.injectCast(userUnaryNode.getChildNode(), scriptScope));
            irNode = irUnaryMathNode;
        }
        scriptScope.putDecoration(userUnaryNode, new Decorations.IRNodeDecoration(irNode));
    }

    @Override
    public void visitBinary(EBinary userBinaryNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        Operation operation = userBinaryNode.getOperation();
        Class<?> valueType = scriptScope.getDecoration(userBinaryNode, Decorations.ValueType.class).valueType();
        if (operation == Operation.ADD && valueType == String.class) {
            StringConcatenationNode stringConcatenationNode = new StringConcatenationNode(userBinaryNode.getLocation());
            stringConcatenationNode.addArgumentNode((ExpressionNode)this.visit(userBinaryNode.getLeftNode(), scriptScope));
            stringConcatenationNode.addArgumentNode((ExpressionNode)this.visit(userBinaryNode.getRightNode(), scriptScope));
            irExpressionNode = stringConcatenationNode;
        } else {
            Class<?> binaryType = scriptScope.getDecoration(userBinaryNode, Decorations.BinaryType.class).binaryType();
            Class<?> shiftType = scriptScope.hasDecoration(userBinaryNode, Decorations.ShiftType.class) ? scriptScope.getDecoration(userBinaryNode, Decorations.ShiftType.class).shiftType() : null;
            BinaryMathNode irBinaryMathNode = new BinaryMathNode(userBinaryNode.getLocation());
            irBinaryMathNode.attachDecoration(new IRDecorations.IRDOperation(operation));
            if (operation == Operation.MATCH || operation == Operation.FIND) {
                irBinaryMathNode.attachDecoration(new IRDecorations.IRDRegexLimit(scriptScope.getCompilerSettings().getAppliedRegexLimitFactor()));
            }
            irBinaryMathNode.attachDecoration(new IRDecorations.IRDBinaryType(binaryType));
            if (shiftType != null) {
                irBinaryMathNode.attachDecoration(new IRDecorations.IRDShiftType(shiftType));
            }
            if (scriptScope.getCondition(userBinaryNode, Decorations.Explicit.class)) {
                irBinaryMathNode.attachDecoration(new IRDecorations.IRDFlags(4));
            }
            irBinaryMathNode.setLeftNode(this.injectCast(userBinaryNode.getLeftNode(), scriptScope));
            irBinaryMathNode.setRightNode(this.injectCast(userBinaryNode.getRightNode(), scriptScope));
            irExpressionNode = irBinaryMathNode;
        }
        irExpressionNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
        scriptScope.putDecoration(userBinaryNode, new Decorations.IRNodeDecoration(irExpressionNode));
    }

    @Override
    public void visitBooleanComp(EBooleanComp userBooleanCompNode, ScriptScope scriptScope) {
        Class<?> valueType = scriptScope.getDecoration(userBooleanCompNode, Decorations.ValueType.class).valueType();
        BooleanNode irBooleanNode = new BooleanNode(userBooleanCompNode.getLocation());
        irBooleanNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
        irBooleanNode.attachDecoration(new IRDecorations.IRDOperation(userBooleanCompNode.getOperation()));
        irBooleanNode.setLeftNode(this.injectCast(userBooleanCompNode.getLeftNode(), scriptScope));
        irBooleanNode.setRightNode(this.injectCast(userBooleanCompNode.getRightNode(), scriptScope));
        scriptScope.putDecoration(userBooleanCompNode, new Decorations.IRNodeDecoration(irBooleanNode));
    }

    @Override
    public void visitComp(EComp userCompNode, ScriptScope scriptScope) {
        ComparisonNode irComparisonNode = new ComparisonNode(userCompNode.getLocation());
        irComparisonNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userCompNode, Decorations.ValueType.class).valueType()));
        irComparisonNode.attachDecoration(new IRDecorations.IRDComparisonType(scriptScope.getDecoration(userCompNode, Decorations.ComparisonType.class).comparisonType()));
        irComparisonNode.attachDecoration(new IRDecorations.IRDOperation(userCompNode.getOperation()));
        irComparisonNode.setLeftNode(this.injectCast(userCompNode.getLeftNode(), scriptScope));
        irComparisonNode.setRightNode(this.injectCast(userCompNode.getRightNode(), scriptScope));
        scriptScope.putDecoration(userCompNode, new Decorations.IRNodeDecoration(irComparisonNode));
    }

    @Override
    public void visitExplicit(EExplicit userExplicitNode, ScriptScope scriptScope) {
        scriptScope.putDecoration(userExplicitNode, new Decorations.IRNodeDecoration(this.injectCast(userExplicitNode.getChildNode(), scriptScope)));
    }

    @Override
    public void visitInstanceof(EInstanceof userInstanceofNode, ScriptScope scriptScope) {
        Class<?> valuetype = scriptScope.getDecoration(userInstanceofNode, Decorations.ValueType.class).valueType();
        Class<?> instanceType = scriptScope.getDecoration(userInstanceofNode, Decorations.InstanceType.class).instanceType();
        InstanceofNode irInstanceofNode = new InstanceofNode(userInstanceofNode.getLocation());
        irInstanceofNode.attachDecoration(new IRDecorations.IRDExpressionType(valuetype));
        irInstanceofNode.attachDecoration(new IRDecorations.IRDInstanceType(instanceType));
        irInstanceofNode.setChildNode((ExpressionNode)this.visit(userInstanceofNode.getExpressionNode(), scriptScope));
        scriptScope.putDecoration(userInstanceofNode, new Decorations.IRNodeDecoration(irInstanceofNode));
    }

    @Override
    public void visitConditional(EConditional userConditionalNode, ScriptScope scriptScope) {
        ConditionalNode irConditionalNode = new ConditionalNode(userConditionalNode.getLocation());
        irConditionalNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userConditionalNode, Decorations.ValueType.class).valueType()));
        irConditionalNode.setConditionNode(this.injectCast(userConditionalNode.getConditionNode(), scriptScope));
        irConditionalNode.setLeftNode(this.injectCast(userConditionalNode.getTrueNode(), scriptScope));
        irConditionalNode.setRightNode(this.injectCast(userConditionalNode.getFalseNode(), scriptScope));
        scriptScope.putDecoration(userConditionalNode, new Decorations.IRNodeDecoration(irConditionalNode));
    }

    @Override
    public void visitElvis(EElvis userElvisNode, ScriptScope scriptScope) {
        ElvisNode irElvisNode = new ElvisNode(userElvisNode.getLocation());
        irElvisNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userElvisNode, Decorations.ValueType.class).valueType()));
        irElvisNode.setLeftNode(this.injectCast(userElvisNode.getLeftNode(), scriptScope));
        irElvisNode.setRightNode(this.injectCast(userElvisNode.getRightNode(), scriptScope));
        scriptScope.putDecoration(userElvisNode, new Decorations.IRNodeDecoration(irElvisNode));
    }

    @Override
    public void visitListInit(EListInit userListInitNode, ScriptScope scriptScope) {
        ListInitializationNode irListInitializationNode = new ListInitializationNode(userListInitNode.getLocation());
        irListInitializationNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userListInitNode, Decorations.ValueType.class).valueType()));
        irListInitializationNode.attachDecoration(new IRDecorations.IRDConstructor(scriptScope.getDecoration(userListInitNode, Decorations.StandardPainlessConstructor.class).standardPainlessConstructor()));
        irListInitializationNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userListInitNode, Decorations.StandardPainlessMethod.class).standardPainlessMethod()));
        for (AExpression userValueNode : userListInitNode.getValueNodes()) {
            irListInitializationNode.addArgumentNode(this.injectCast(userValueNode, scriptScope));
        }
        scriptScope.putDecoration(userListInitNode, new Decorations.IRNodeDecoration(irListInitializationNode));
    }

    @Override
    public void visitMapInit(EMapInit userMapInitNode, ScriptScope scriptScope) {
        MapInitializationNode irMapInitializationNode = new MapInitializationNode(userMapInitNode.getLocation());
        irMapInitializationNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userMapInitNode, Decorations.ValueType.class).valueType()));
        irMapInitializationNode.attachDecoration(new IRDecorations.IRDConstructor(scriptScope.getDecoration(userMapInitNode, Decorations.StandardPainlessConstructor.class).standardPainlessConstructor()));
        irMapInitializationNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userMapInitNode, Decorations.StandardPainlessMethod.class).standardPainlessMethod()));
        for (int i = 0; i < userMapInitNode.getKeyNodes().size(); ++i) {
            irMapInitializationNode.addArgumentNode(this.injectCast(userMapInitNode.getKeyNodes().get(i), scriptScope), this.injectCast(userMapInitNode.getValueNodes().get(i), scriptScope));
        }
        scriptScope.putDecoration(userMapInitNode, new Decorations.IRNodeDecoration(irMapInitializationNode));
    }

    @Override
    public void visitNewArray(ENewArray userNewArrayNode, ScriptScope scriptScope) {
        NewArrayNode irNewArrayNode = new NewArrayNode(userNewArrayNode.getLocation());
        irNewArrayNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userNewArrayNode, Decorations.ValueType.class).valueType()));
        if (userNewArrayNode.isInitializer()) {
            irNewArrayNode.attachCondition(IRDecorations.IRCInitialize.class);
        }
        for (AExpression userArgumentNode : userNewArrayNode.getValueNodes()) {
            irNewArrayNode.addArgumentNode(this.injectCast(userArgumentNode, scriptScope));
        }
        scriptScope.putDecoration(userNewArrayNode, new Decorations.IRNodeDecoration(irNewArrayNode));
    }

    @Override
    public void visitNewObj(ENewObj userNewObjectNode, ScriptScope scriptScope) {
        Class<?> valueType = scriptScope.getDecoration(userNewObjectNode, Decorations.ValueType.class).valueType();
        PainlessConstructor painlessConstructor = scriptScope.getDecoration(userNewObjectNode, Decorations.StandardPainlessConstructor.class).standardPainlessConstructor();
        NewObjectNode irNewObjectNode = new NewObjectNode(userNewObjectNode.getLocation());
        irNewObjectNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
        irNewObjectNode.attachDecoration(new IRDecorations.IRDConstructor(painlessConstructor));
        if (scriptScope.getCondition(userNewObjectNode, Decorations.Read.class)) {
            irNewObjectNode.attachCondition(IRDecorations.IRCRead.class);
        }
        for (AExpression userArgumentNode : userNewObjectNode.getArgumentNodes()) {
            irNewObjectNode.addArgumentNode(this.injectCast(userArgumentNode, scriptScope));
        }
        scriptScope.putDecoration(userNewObjectNode, new Decorations.IRNodeDecoration(irNewObjectNode));
    }

    @Override
    public void visitCallLocal(ECallLocal callLocalNode, ScriptScope scriptScope) {
        InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(callLocalNode.getLocation());
        if (scriptScope.hasDecoration(callLocalNode, Decorations.StandardLocalFunction.class)) {
            FunctionTable.LocalFunction localFunction = scriptScope.getDecoration(callLocalNode, Decorations.StandardLocalFunction.class).localFunction();
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDFunction(localFunction));
        } else if (scriptScope.hasDecoration(callLocalNode, Decorations.ThisPainlessMethod.class)) {
            PainlessMethod thisMethod = scriptScope.getDecoration(callLocalNode, Decorations.ThisPainlessMethod.class).thisPainlessMethod();
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDThisMethod(thisMethod));
        } else if (scriptScope.hasDecoration(callLocalNode, Decorations.StandardPainlessMethod.class)) {
            PainlessMethod importedMethod = scriptScope.getDecoration(callLocalNode, Decorations.StandardPainlessMethod.class).standardPainlessMethod();
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDMethod(importedMethod));
        } else if (scriptScope.hasDecoration(callLocalNode, Decorations.StandardPainlessClassBinding.class)) {
            PainlessClassBinding painlessClassBinding = scriptScope.getDecoration(callLocalNode, Decorations.StandardPainlessClassBinding.class).painlessClassBinding();
            bindingName = scriptScope.getNextSyntheticName("class_binding");
            irFieldNode = new FieldNode(callLocalNode.getLocation());
            irFieldNode.attachDecoration(new IRDecorations.IRDModifiers(2));
            irFieldNode.attachDecoration(new IRDecorations.IRDFieldType(painlessClassBinding.javaConstructor().getDeclaringClass()));
            irFieldNode.attachDecoration(new IRDecorations.IRDName(bindingName));
            this.irClassNode.addFieldNode(irFieldNode);
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDClassBinding(painlessClassBinding));
            if ((Integer)scriptScope.getDecoration(callLocalNode, Decorations.StandardConstant.class).standardConstant() == 0) {
                irInvokeCallMemberNode.attachCondition(IRDecorations.IRCStatic.class);
            }
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDName(bindingName));
        } else if (scriptScope.hasDecoration(callLocalNode, Decorations.StandardPainlessInstanceBinding.class)) {
            PainlessInstanceBinding painlessInstanceBinding = scriptScope.getDecoration(callLocalNode, Decorations.StandardPainlessInstanceBinding.class).painlessInstanceBinding();
            bindingName = scriptScope.getNextSyntheticName("instance_binding");
            irFieldNode = new FieldNode(callLocalNode.getLocation());
            irFieldNode.attachDecoration(new IRDecorations.IRDModifiers(9));
            irFieldNode.attachDecoration(new IRDecorations.IRDFieldType(painlessInstanceBinding.targetInstance().getClass()));
            irFieldNode.attachDecoration(new IRDecorations.IRDName(bindingName));
            this.irClassNode.addFieldNode(irFieldNode);
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDInstanceBinding(painlessInstanceBinding));
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDName(bindingName));
            scriptScope.addStaticConstant(bindingName, painlessInstanceBinding.targetInstance());
        } else {
            throw callLocalNode.createError(new IllegalStateException("illegal tree structure"));
        }
        for (AExpression userArgumentNode : callLocalNode.getArgumentNodes()) {
            irInvokeCallMemberNode.addArgumentNode(this.injectCast(userArgumentNode, scriptScope));
        }
        Class<?> valueType = scriptScope.getDecoration(callLocalNode, Decorations.ValueType.class).valueType();
        irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
        scriptScope.putDecoration(callLocalNode, new Decorations.IRNodeDecoration(irInvokeCallMemberNode));
    }

    @Override
    public void visitBooleanConstant(EBooleanConstant userBooleanConstantNode, ScriptScope scriptScope) {
        Class<?> valueType = scriptScope.getDecoration(userBooleanConstantNode, Decorations.ValueType.class).valueType();
        Object constant = scriptScope.getDecoration(userBooleanConstantNode, Decorations.StandardConstant.class).standardConstant();
        ConstantNode irConstantNode = new ConstantNode(userBooleanConstantNode.getLocation());
        irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
        irConstantNode.attachDecoration(new IRDecorations.IRDConstant(constant));
        scriptScope.putDecoration(userBooleanConstantNode, new Decorations.IRNodeDecoration(irConstantNode));
    }

    @Override
    public void visitNumeric(ENumeric userNumericNode, ScriptScope scriptScope) {
        Class<?> valueType = scriptScope.getDecoration(userNumericNode, Decorations.ValueType.class).valueType();
        Object constant = scriptScope.getDecoration(userNumericNode, Decorations.StandardConstant.class).standardConstant();
        ConstantNode irConstantNode = new ConstantNode(userNumericNode.getLocation());
        irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
        irConstantNode.attachDecoration(new IRDecorations.IRDConstant(constant));
        scriptScope.putDecoration(userNumericNode, new Decorations.IRNodeDecoration(irConstantNode));
    }

    @Override
    public void visitDecimal(EDecimal userDecimalNode, ScriptScope scriptScope) {
        Class<?> valueType = scriptScope.getDecoration(userDecimalNode, Decorations.ValueType.class).valueType();
        Object constant = scriptScope.getDecoration(userDecimalNode, Decorations.StandardConstant.class).standardConstant();
        ConstantNode irConstantNode = new ConstantNode(userDecimalNode.getLocation());
        irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
        irConstantNode.attachDecoration(new IRDecorations.IRDConstant(constant));
        scriptScope.putDecoration(userDecimalNode, new Decorations.IRNodeDecoration(irConstantNode));
    }

    @Override
    public void visitString(EString userStringNode, ScriptScope scriptScope) {
        Class<?> valueType = scriptScope.getDecoration(userStringNode, Decorations.ValueType.class).valueType();
        Object constant = scriptScope.getDecoration(userStringNode, Decorations.StandardConstant.class).standardConstant();
        ConstantNode irConstantNode = new ConstantNode(userStringNode.getLocation());
        irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
        irConstantNode.attachDecoration(new IRDecorations.IRDConstant(constant));
        scriptScope.putDecoration(userStringNode, new Decorations.IRNodeDecoration(irConstantNode));
    }

    @Override
    public void visitNull(ENull userNullNode, ScriptScope scriptScope) {
        NullNode irNullNode = new NullNode(userNullNode.getLocation());
        irNullNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userNullNode, Decorations.ValueType.class).valueType()));
        scriptScope.putDecoration(userNullNode, new Decorations.IRNodeDecoration(irNullNode));
    }

    @Override
    public void visitRegex(ERegex userRegexNode, ScriptScope scriptScope) {
        ConstantNode constant = new ConstantNode(userRegexNode.getLocation());
        constant.attachDecoration(new IRDecorations.IRDExpressionType(Pattern.class));
        constant.attachDecoration(new IRDecorations.IRDConstant(scriptScope.getDecoration(userRegexNode, Decorations.StandardConstant.class).standardConstant()));
        scriptScope.putDecoration(userRegexNode, new Decorations.IRNodeDecoration(constant));
    }

    @Override
    public void visitLambda(ELambda userLambdaNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        if (scriptScope.hasDecoration(userLambdaNode, Decorations.TargetType.class)) {
            TypedInterfaceReferenceNode typedInterfaceReferenceNode = new TypedInterfaceReferenceNode(userLambdaNode.getLocation());
            typedInterfaceReferenceNode.attachDecoration(new IRDecorations.IRDReference(scriptScope.getDecoration(userLambdaNode, Decorations.ReferenceDecoration.class).reference()));
            irExpressionNode = typedInterfaceReferenceNode;
        } else {
            DefInterfaceReferenceNode defInterfaceReferenceNode = new DefInterfaceReferenceNode(userLambdaNode.getLocation());
            defInterfaceReferenceNode.attachDecoration(new IRDecorations.IRDDefReferenceEncoding(scriptScope.getDecoration(userLambdaNode, Decorations.EncodingDecoration.class).encoding()));
            irExpressionNode = defInterfaceReferenceNode;
        }
        FunctionNode irFunctionNode = new FunctionNode(userLambdaNode.getLocation());
        irFunctionNode.setBlockNode((BlockNode)this.visit(userLambdaNode.getBlockNode(), scriptScope));
        irFunctionNode.attachDecoration(new IRDecorations.IRDName(scriptScope.getDecoration(userLambdaNode, Decorations.MethodNameDecoration.class).methodName()));
        irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(scriptScope.getDecoration(userLambdaNode, Decorations.ReturnType.class).returnType()));
        irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(scriptScope.getDecoration(userLambdaNode, Decorations.TypeParameters.class).typeParameters()));
        irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(scriptScope.getDecoration(userLambdaNode, Decorations.ParameterNames.class).parameterNames()));
        if (scriptScope.getCondition(userLambdaNode, Decorations.InstanceCapturingLambda.class)) {
            irFunctionNode.attachCondition(IRDecorations.IRCInstanceCapture.class);
            irExpressionNode.attachCondition(IRDecorations.IRCInstanceCapture.class);
        } else {
            irFunctionNode.attachCondition(IRDecorations.IRCStatic.class);
        }
        irFunctionNode.attachCondition(IRDecorations.IRCSynthetic.class);
        irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(scriptScope.getCompilerSettings().getMaxLoopCounter()));
        this.irClassNode.addFunctionNode(irFunctionNode);
        irExpressionNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userLambdaNode, Decorations.ValueType.class).valueType()));
        List<SemanticScope.Variable> captures = scriptScope.getDecoration(userLambdaNode, Decorations.CapturesDecoration.class).captures();
        if (!captures.isEmpty()) {
            List<String> captureNames = captures.stream().map(SemanticScope.Variable::name).toList();
            irExpressionNode.attachDecoration(new IRDecorations.IRDCaptureNames(captureNames));
        }
        scriptScope.putDecoration(userLambdaNode, new Decorations.IRNodeDecoration(irExpressionNode));
    }

    @Override
    public void visitFunctionRef(EFunctionRef userFunctionRefNode, ScriptScope scriptScope) {
        ExpressionNode irReferenceNode;
        Decorations.TargetType targetType = scriptScope.getDecoration(userFunctionRefNode, Decorations.TargetType.class);
        Decorations.CapturesDecoration capturesDecoration = scriptScope.getDecoration(userFunctionRefNode, Decorations.CapturesDecoration.class);
        if (targetType == null) {
            Def.Encoding encoding = scriptScope.getDecoration(userFunctionRefNode, Decorations.EncodingDecoration.class).encoding();
            DefInterfaceReferenceNode defInterfaceReferenceNode = new DefInterfaceReferenceNode(userFunctionRefNode.getLocation());
            defInterfaceReferenceNode.attachDecoration(new IRDecorations.IRDDefReferenceEncoding(encoding));
            if (scriptScope.getCondition(userFunctionRefNode, Decorations.InstanceCapturingFunctionRef.class)) {
                defInterfaceReferenceNode.attachCondition(IRDecorations.IRCInstanceCapture.class);
            }
            irReferenceNode = defInterfaceReferenceNode;
        } else if (capturesDecoration != null && capturesDecoration.captures().get(0).type() == def.class) {
            TypedCaptureReferenceNode typedCaptureReferenceNode = new TypedCaptureReferenceNode(userFunctionRefNode.getLocation());
            typedCaptureReferenceNode.attachDecoration(new IRDecorations.IRDName(userFunctionRefNode.getMethodName()));
            irReferenceNode = typedCaptureReferenceNode;
        } else {
            FunctionRef reference = scriptScope.getDecoration(userFunctionRefNode, Decorations.ReferenceDecoration.class).reference();
            TypedInterfaceReferenceNode typedInterfaceReferenceNode = new TypedInterfaceReferenceNode(userFunctionRefNode.getLocation());
            typedInterfaceReferenceNode.attachDecoration(new IRDecorations.IRDReference(reference));
            if (scriptScope.getCondition(userFunctionRefNode, Decorations.InstanceCapturingFunctionRef.class)) {
                typedInterfaceReferenceNode.attachCondition(IRDecorations.IRCInstanceCapture.class);
            }
            irReferenceNode = typedInterfaceReferenceNode;
        }
        irReferenceNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userFunctionRefNode, Decorations.ValueType.class).valueType()));
        if (capturesDecoration != null) {
            irReferenceNode.attachDecoration(new IRDecorations.IRDCaptureNames(List.of(capturesDecoration.captures().get(0).name())));
            if (scriptScope.getCondition(userFunctionRefNode, Decorations.CaptureBox.class)) {
                irReferenceNode.attachCondition(IRDecorations.IRCCaptureBox.class);
            }
        }
        scriptScope.putDecoration(userFunctionRefNode, new Decorations.IRNodeDecoration(irReferenceNode));
    }

    @Override
    public void visitNewArrayFunctionRef(ENewArrayFunctionRef userNewArrayFunctionRefNode, ScriptScope scriptScope) {
        ExpressionNode irReferenceNode;
        if (scriptScope.hasDecoration(userNewArrayFunctionRefNode, Decorations.TargetType.class)) {
            TypedInterfaceReferenceNode typedInterfaceReferenceNode = new TypedInterfaceReferenceNode(userNewArrayFunctionRefNode.getLocation());
            FunctionRef reference = scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.ReferenceDecoration.class).reference();
            typedInterfaceReferenceNode.attachDecoration(new IRDecorations.IRDReference(reference));
            irReferenceNode = typedInterfaceReferenceNode;
        } else {
            Def.Encoding encoding = scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.EncodingDecoration.class).encoding();
            DefInterfaceReferenceNode defInterfaceReferenceNode = new DefInterfaceReferenceNode(userNewArrayFunctionRefNode.getLocation());
            defInterfaceReferenceNode.attachDecoration(new IRDecorations.IRDDefReferenceEncoding(encoding));
            irReferenceNode = defInterfaceReferenceNode;
        }
        Class<?> returnType = scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.ReturnType.class).returnType();
        LoadVariableNode irLoadVariableNode = new LoadVariableNode(userNewArrayFunctionRefNode.getLocation());
        irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(Integer.TYPE));
        irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("size"));
        NewArrayNode irNewArrayNode = new NewArrayNode(userNewArrayFunctionRefNode.getLocation());
        irNewArrayNode.attachDecoration(new IRDecorations.IRDExpressionType(returnType));
        irNewArrayNode.addArgumentNode(irLoadVariableNode);
        ReturnNode irReturnNode = new ReturnNode(userNewArrayFunctionRefNode.getLocation());
        irReturnNode.setExpressionNode(irNewArrayNode);
        BlockNode irBlockNode = new BlockNode(userNewArrayFunctionRefNode.getLocation());
        irBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
        irBlockNode.addStatementNode(irReturnNode);
        FunctionNode irFunctionNode = new FunctionNode(userNewArrayFunctionRefNode.getLocation());
        irFunctionNode.attachDecoration(new IRDecorations.IRDName(scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.MethodNameDecoration.class).methodName()));
        irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(returnType));
        irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(List.of(Integer.TYPE)));
        irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(List.of("size")));
        irFunctionNode.attachCondition(IRDecorations.IRCStatic.class);
        irFunctionNode.attachCondition(IRDecorations.IRCSynthetic.class);
        irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(0));
        irFunctionNode.setBlockNode(irBlockNode);
        this.irClassNode.addFunctionNode(irFunctionNode);
        irReferenceNode.attachDecoration(new IRDecorations.IRDExpressionType(scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.ValueType.class).valueType()));
        scriptScope.putDecoration(userNewArrayFunctionRefNode, new Decorations.IRNodeDecoration(irReferenceNode));
    }

    @Override
    public void visitSymbol(ESymbol userSymbolNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        if (scriptScope.hasDecoration(userSymbolNode, Decorations.StaticType.class)) {
            Class<?> staticType = scriptScope.getDecoration(userSymbolNode, Decorations.StaticType.class).staticType();
            StaticNode staticNode = new StaticNode(userSymbolNode.getLocation());
            staticNode.attachDecoration(new IRDecorations.IRDExpressionType(staticType));
            irExpressionNode = staticNode;
        } else if (scriptScope.hasDecoration(userSymbolNode, Decorations.ValueType.class)) {
            boolean read = scriptScope.getCondition(userSymbolNode, Decorations.Read.class);
            boolean write = scriptScope.getCondition(userSymbolNode, Decorations.Write.class);
            boolean compound = scriptScope.getCondition(userSymbolNode, Decorations.Compound.class);
            Location location = userSymbolNode.getLocation();
            String symbol = userSymbolNode.getSymbol();
            Class<?> valueType = scriptScope.getDecoration(userSymbolNode, Decorations.ValueType.class).valueType();
            StoreVariableNode irStoreNode = null;
            LoadVariableNode irLoadNode = null;
            if (write || compound) {
                StoreVariableNode irStoreVariableNode = new StoreVariableNode(location);
                irStoreVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                irStoreVariableNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                irStoreVariableNode.attachDecoration(new IRDecorations.IRDName(symbol));
                irStoreNode = irStoreVariableNode;
            }
            if (!write || compound) {
                LoadVariableNode irLoadVariableNode = new LoadVariableNode(location);
                irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                irLoadVariableNode.attachDecoration(new IRDecorations.IRDName(symbol));
                irLoadNode = irLoadVariableNode;
            }
            scriptScope.putDecoration(userSymbolNode, new Decorations.AccessDepth(0));
            irExpressionNode = DefaultUserTreeToIRTreePhase.buildLoadStore(0, location, false, null, null, irLoadNode, irStoreNode);
        } else {
            throw userSymbolNode.createError(new IllegalStateException("illegal tree structure"));
        }
        scriptScope.putDecoration(userSymbolNode, new Decorations.IRNodeDecoration(irExpressionNode));
    }

    @Override
    public void visitDot(EDot userDotNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        if (scriptScope.hasDecoration(userDotNode, Decorations.StaticType.class)) {
            Class<?> staticType = scriptScope.getDecoration(userDotNode, Decorations.StaticType.class).staticType();
            StaticNode staticNode = new StaticNode(userDotNode.getLocation());
            staticNode.attachDecoration(new IRDecorations.IRDExpressionType(staticType));
            irExpressionNode = staticNode;
        } else {
            int accessDepth;
            boolean read = scriptScope.getCondition(userDotNode, Decorations.Read.class);
            boolean write = scriptScope.getCondition(userDotNode, Decorations.Write.class);
            boolean compound = scriptScope.getCondition(userDotNode, Decorations.Compound.class);
            Location location = userDotNode.getLocation();
            String index = userDotNode.getIndex();
            Class<?> valueType = scriptScope.getDecoration(userDotNode, Decorations.ValueType.class).valueType();
            Decorations.ValueType prefixValueType = scriptScope.getDecoration(userDotNode.getPrefixNode(), Decorations.ValueType.class);
            ExpressionNode irPrefixNode = (ExpressionNode)this.visit(userDotNode.getPrefixNode(), scriptScope);
            ConstantNode irIndexNode = null;
            UnaryNode irStoreNode = null;
            ExpressionNode irLoadNode = null;
            if (prefixValueType != null && prefixValueType.valueType().isArray()) {
                LoadDotArrayLengthNode irLoadDotArrayLengthNode = new LoadDotArrayLengthNode(location);
                irLoadDotArrayLengthNode.attachDecoration(new IRDecorations.IRDExpressionType(Integer.TYPE));
                irLoadNode = irLoadDotArrayLengthNode;
                accessDepth = 1;
            } else if (prefixValueType != null && prefixValueType.valueType() == def.class) {
                if (write || compound) {
                    StoreDotDefNode irStoreDotDefNode = new StoreDotDefNode(location);
                    irStoreDotDefNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                    irStoreDotDefNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                    irStoreDotDefNode.attachDecoration(new IRDecorations.IRDValue(index));
                    irStoreNode = irStoreDotDefNode;
                }
                if (!write || compound) {
                    LoadDotDefNode irLoadDotDefNode = new LoadDotDefNode(location);
                    irLoadDotDefNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                    irLoadDotDefNode.attachDecoration(new IRDecorations.IRDValue(userDotNode.getIndex()));
                    irLoadNode = irLoadDotDefNode;
                }
                accessDepth = 1;
            } else if (scriptScope.hasDecoration(userDotNode, Decorations.StandardPainlessField.class)) {
                PainlessField painlessField = scriptScope.getDecoration(userDotNode, Decorations.StandardPainlessField.class).standardPainlessField();
                if (write || compound) {
                    StoreDotNode irStoreDotNode = new StoreDotNode(location);
                    irStoreDotNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                    irStoreDotNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                    irStoreDotNode.attachDecoration(new IRDecorations.IRDField(painlessField));
                    irStoreNode = irStoreDotNode;
                }
                if (!write || compound) {
                    LoadDotNode irLoadDotNode = new LoadDotNode(location);
                    irLoadDotNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                    irLoadDotNode.attachDecoration(new IRDecorations.IRDField(painlessField));
                    irLoadNode = irLoadDotNode;
                }
                accessDepth = 1;
            } else if (scriptScope.getCondition(userDotNode, Decorations.Shortcut.class)) {
                if (write || compound) {
                    StoreDotShortcutNode irStoreDotShortcutNode = new StoreDotShortcutNode(location);
                    irStoreDotShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                    irStoreDotShortcutNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                    irStoreDotShortcutNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userDotNode, Decorations.SetterPainlessMethod.class).setterPainlessMethod()));
                    irStoreNode = irStoreDotShortcutNode;
                }
                if (!write || compound) {
                    LoadDotShortcutNode irLoadDotShortcutNode = new LoadDotShortcutNode(location);
                    irLoadDotShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                    irLoadDotShortcutNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userDotNode, Decorations.GetterPainlessMethod.class).getterPainlessMethod()));
                    irLoadNode = irLoadDotShortcutNode;
                }
                accessDepth = 1;
            } else if (scriptScope.getCondition(userDotNode, Decorations.MapShortcut.class)) {
                ConstantNode irConstantNode = new ConstantNode(location);
                irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant(index));
                irIndexNode = irConstantNode;
                if (write || compound) {
                    StoreMapShortcutNode irStoreMapShortcutNode = new StoreMapShortcutNode(location);
                    irStoreMapShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                    irStoreMapShortcutNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                    irStoreMapShortcutNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userDotNode, Decorations.SetterPainlessMethod.class).setterPainlessMethod()));
                    irStoreNode = irStoreMapShortcutNode;
                }
                if (!write || compound) {
                    LoadMapShortcutNode irLoadMapShortcutNode = new LoadMapShortcutNode(location);
                    irLoadMapShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                    irLoadMapShortcutNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userDotNode, Decorations.GetterPainlessMethod.class).getterPainlessMethod()));
                    irLoadNode = irLoadMapShortcutNode;
                }
                accessDepth = 2;
            } else if (scriptScope.getCondition(userDotNode, Decorations.ListShortcut.class)) {
                ConstantNode irConstantNode = new ConstantNode(location);
                irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Integer.TYPE));
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant(scriptScope.getDecoration(userDotNode, Decorations.StandardConstant.class).standardConstant()));
                irIndexNode = irConstantNode;
                if (write || compound) {
                    StoreListShortcutNode irStoreListShortcutNode = new StoreListShortcutNode(location);
                    irStoreListShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                    irStoreListShortcutNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                    irStoreListShortcutNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userDotNode, Decorations.SetterPainlessMethod.class).setterPainlessMethod()));
                    irStoreNode = irStoreListShortcutNode;
                }
                if (!write || compound) {
                    LoadListShortcutNode irLoadListShortcutNode = new LoadListShortcutNode(location);
                    irLoadListShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                    irLoadListShortcutNode.attachDecoration(new IRDecorations.IRDMethod(scriptScope.getDecoration(userDotNode, Decorations.GetterPainlessMethod.class).getterPainlessMethod()));
                    irLoadNode = irLoadListShortcutNode;
                }
                accessDepth = 2;
            } else {
                throw userDotNode.createError(new IllegalStateException("illegal tree structure"));
            }
            scriptScope.putDecoration(userDotNode, new Decorations.AccessDepth(accessDepth));
            irExpressionNode = DefaultUserTreeToIRTreePhase.buildLoadStore(accessDepth, location, userDotNode.isNullSafe(), irPrefixNode, irIndexNode, irLoadNode, irStoreNode);
        }
        scriptScope.putDecoration(userDotNode, new Decorations.IRNodeDecoration(irExpressionNode));
    }

    @Override
    public void visitBrace(EBrace userBraceNode, ScriptScope scriptScope) {
        boolean read = scriptScope.getCondition(userBraceNode, Decorations.Read.class);
        boolean write = scriptScope.getCondition(userBraceNode, Decorations.Write.class);
        boolean compound = scriptScope.getCondition(userBraceNode, Decorations.Compound.class);
        Location location = userBraceNode.getLocation();
        Class<?> valueType = scriptScope.getDecoration(userBraceNode, Decorations.ValueType.class).valueType();
        Class<?> prefixValueType = scriptScope.getDecoration(userBraceNode.getPrefixNode(), Decorations.ValueType.class).valueType();
        ExpressionNode irPrefixNode = (ExpressionNode)this.visit(userBraceNode.getPrefixNode(), scriptScope);
        ExpressionNode irIndexNode = this.injectCast(userBraceNode.getIndexNode(), scriptScope);
        UnaryNode irStoreNode = null;
        ExpressionNode irLoadNode = null;
        if (prefixValueType.isArray()) {
            FlipArrayIndexNode irFlipArrayIndexNode = new FlipArrayIndexNode(userBraceNode.getIndexNode().getLocation());
            irFlipArrayIndexNode.attachDecoration(new IRDecorations.IRDExpressionType(Integer.TYPE));
            irFlipArrayIndexNode.setChildNode(irIndexNode);
            irIndexNode = irFlipArrayIndexNode;
            if (write || compound) {
                StoreBraceNode irStoreBraceNode = new StoreBraceNode(location);
                irStoreBraceNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                irStoreBraceNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                irStoreNode = irStoreBraceNode;
            }
            if (!write || compound) {
                LoadBraceNode irLoadBraceNode = new LoadBraceNode(location);
                irLoadBraceNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                irLoadNode = irLoadBraceNode;
            }
        } else if (prefixValueType == def.class) {
            Class<?> indexType = scriptScope.getDecoration(userBraceNode.getIndexNode(), Decorations.ValueType.class).valueType();
            FlipDefIndexNode irFlipDefIndexNode = new FlipDefIndexNode(userBraceNode.getIndexNode().getLocation());
            irFlipDefIndexNode.attachDecoration(new IRDecorations.IRDExpressionType(indexType));
            irFlipDefIndexNode.setChildNode(irIndexNode);
            irIndexNode = irFlipDefIndexNode;
            if (write || compound) {
                StoreBraceDefNode irStoreBraceNode = new StoreBraceDefNode(location);
                irStoreBraceNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                irStoreBraceNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                irStoreBraceNode.attachDecoration(new IRDecorations.IRDIndexType(indexType));
                irStoreNode = irStoreBraceNode;
            }
            if (!write || compound) {
                LoadBraceDefNode irLoadBraceDefNode = new LoadBraceDefNode(location);
                irLoadBraceDefNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                irLoadBraceDefNode.attachDecoration(new IRDecorations.IRDIndexType(indexType));
                irLoadNode = irLoadBraceDefNode;
            }
        } else if (scriptScope.getCondition(userBraceNode, Decorations.MapShortcut.class)) {
            if (write || compound) {
                PainlessMethod setter = scriptScope.getDecoration(userBraceNode, Decorations.SetterPainlessMethod.class).setterPainlessMethod();
                StoreMapShortcutNode irStoreMapShortcutNode = new StoreMapShortcutNode(location);
                irStoreMapShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                irStoreMapShortcutNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                irStoreMapShortcutNode.attachDecoration(new IRDecorations.IRDMethod(setter));
                irStoreNode = irStoreMapShortcutNode;
            }
            if (!write || compound) {
                PainlessMethod getter = scriptScope.getDecoration(userBraceNode, Decorations.GetterPainlessMethod.class).getterPainlessMethod();
                LoadMapShortcutNode irLoadMapShortcutNode = new LoadMapShortcutNode(location);
                irLoadMapShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                irLoadMapShortcutNode.attachDecoration(new IRDecorations.IRDMethod(getter));
                irLoadNode = irLoadMapShortcutNode;
            }
        } else if (scriptScope.getCondition(userBraceNode, Decorations.ListShortcut.class)) {
            FlipCollectionIndexNode irFlipCollectionIndexNode = new FlipCollectionIndexNode(userBraceNode.getIndexNode().getLocation());
            irFlipCollectionIndexNode.attachDecoration(new IRDecorations.IRDExpressionType(Integer.TYPE));
            irFlipCollectionIndexNode.setChildNode(irIndexNode);
            irIndexNode = irFlipCollectionIndexNode;
            if (write || compound) {
                PainlessMethod setter = scriptScope.getDecoration(userBraceNode, Decorations.SetterPainlessMethod.class).setterPainlessMethod();
                StoreListShortcutNode irStoreListShortcutNode = new StoreListShortcutNode(location);
                irStoreListShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(read ? valueType : Void.TYPE));
                irStoreListShortcutNode.attachDecoration(new IRDecorations.IRDStoreType(valueType));
                irStoreListShortcutNode.attachDecoration(new IRDecorations.IRDMethod(setter));
                irStoreNode = irStoreListShortcutNode;
            }
            if (!write || compound) {
                PainlessMethod getter = scriptScope.getDecoration(userBraceNode, Decorations.GetterPainlessMethod.class).getterPainlessMethod();
                LoadListShortcutNode irLoadListShortcutNode = new LoadListShortcutNode(location);
                irLoadListShortcutNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
                irLoadListShortcutNode.attachDecoration(new IRDecorations.IRDMethod(getter));
                irLoadNode = irLoadListShortcutNode;
            }
        } else {
            throw userBraceNode.createError(new IllegalStateException("illegal tree structure"));
        }
        scriptScope.putDecoration(userBraceNode, new Decorations.AccessDepth(2));
        scriptScope.putDecoration(userBraceNode, new Decorations.IRNodeDecoration(DefaultUserTreeToIRTreePhase.buildLoadStore(2, location, false, irPrefixNode, irIndexNode, irLoadNode, irStoreNode)));
    }

    @Override
    public void visitCall(ECall userCallNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        Decorations.ValueType prefixValueType = scriptScope.getDecoration(userCallNode.getPrefixNode(), Decorations.ValueType.class);
        Class<?> valueType = scriptScope.getDecoration(userCallNode, Decorations.ValueType.class).valueType();
        if (scriptScope.getCondition(userCallNode, Decorations.DynamicInvocation.class)) {
            InvokeCallDefNode irCallSubDefNode = new InvokeCallDefNode(userCallNode.getLocation());
            for (AExpression userArgumentNode : userCallNode.getArgumentNodes()) {
                irCallSubDefNode.addArgumentNode((ExpressionNode)this.visit(userArgumentNode, scriptScope));
            }
            irCallSubDefNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
            irCallSubDefNode.attachDecoration(new IRDecorations.IRDName(userCallNode.getMethodName()));
            irExpressionNode = irCallSubDefNode;
        } else {
            Class<?> boxType = prefixValueType != null ? prefixValueType.valueType() : scriptScope.getDecoration(userCallNode.getPrefixNode(), Decorations.StaticType.class).staticType();
            InvokeCallNode irInvokeCallNode = new InvokeCallNode(userCallNode.getLocation());
            PainlessMethod method = scriptScope.getDecoration(userCallNode, Decorations.StandardPainlessMethod.class).standardPainlessMethod();
            Object[] injections = PainlessLookupUtility.buildInjections(method, scriptScope.getCompilerSettings().asMap());
            Class<?>[] parameterTypes = method.javaMethod().getParameterTypes();
            int augmentedOffset = method.javaMethod().getDeclaringClass() == method.targetClass() ? 0 : 1;
            for (int i = 0; i < injections.length; ++i) {
                Class<?> parameterType = parameterTypes[i + augmentedOffset];
                Object injection = injections[i];
                if (parameterType != PainlessLookupUtility.typeToUnboxedType(injection.getClass())) {
                    throw new IllegalStateException("illegal tree structure");
                }
                ConstantNode constantNode = new ConstantNode(userCallNode.getLocation());
                constantNode.attachDecoration(new IRDecorations.IRDExpressionType(parameterType));
                constantNode.attachDecoration(new IRDecorations.IRDConstant(injection));
                irInvokeCallNode.addArgumentNode(constantNode);
            }
            for (AExpression userCallArgumentNode : userCallNode.getArgumentNodes()) {
                irInvokeCallNode.addArgumentNode(this.injectCast(userCallArgumentNode, scriptScope));
            }
            irInvokeCallNode.attachDecoration(new IRDecorations.IRDExpressionType(valueType));
            irInvokeCallNode.setMethod(scriptScope.getDecoration(userCallNode, Decorations.StandardPainlessMethod.class).standardPainlessMethod());
            irInvokeCallNode.setBox(boxType);
            irExpressionNode = irInvokeCallNode;
        }
        if (userCallNode.isNullSafe()) {
            NullSafeSubNode irNullSafeSubNode = new NullSafeSubNode(irExpressionNode.getLocation());
            irNullSafeSubNode.setChildNode(irExpressionNode);
            irNullSafeSubNode.attachDecoration(irExpressionNode.getDecoration(IRDecorations.IRDExpressionType.class));
            irExpressionNode = irNullSafeSubNode;
        }
        BinaryImplNode irBinaryImplNode = new BinaryImplNode(irExpressionNode.getLocation());
        irBinaryImplNode.setLeftNode((ExpressionNode)this.visit(userCallNode.getPrefixNode(), scriptScope));
        irBinaryImplNode.setRightNode(irExpressionNode);
        irBinaryImplNode.attachDecoration(irExpressionNode.getDecoration(IRDecorations.IRDExpressionType.class));
        scriptScope.putDecoration(userCallNode, new Decorations.IRNodeDecoration(irBinaryImplNode));
    }
}

