/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.execution.PlanExecutor;
import org.elasticsearch.xpack.esql.plugin.EsqlStatsRequest;
import org.elasticsearch.xpack.esql.plugin.EsqlStatsResponse;

public class TransportEsqlStatsAction
extends TransportNodesAction<EsqlStatsRequest, EsqlStatsResponse, EsqlStatsRequest.NodeStatsRequest, EsqlStatsResponse.NodeStatsResponse, Void> {
    private final PlanExecutor planExecutor;

    @Inject
    public TransportEsqlStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor) {
        super("cluster:monitor/xpack/esql/stats/dist", clusterService, transportService, actionFilters, EsqlStatsRequest.NodeStatsRequest::new, (Executor)threadPool.executor("management"));
        this.planExecutor = planExecutor;
    }

    protected DiscoveryNode[] resolveRequest(EsqlStatsRequest request, ClusterState clusterState) {
        return super.resolveRequest((BaseNodesRequest)request, clusterState);
    }

    protected EsqlStatsResponse newResponse(EsqlStatsRequest request, List<EsqlStatsResponse.NodeStatsResponse> nodes, List<FailedNodeException> failures) {
        return new EsqlStatsResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected EsqlStatsRequest.NodeStatsRequest newNodeRequest(EsqlStatsRequest request) {
        return new EsqlStatsRequest.NodeStatsRequest(request);
    }

    protected EsqlStatsResponse.NodeStatsResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new EsqlStatsResponse.NodeStatsResponse(in);
    }

    protected EsqlStatsResponse.NodeStatsResponse nodeOperation(EsqlStatsRequest.NodeStatsRequest request, Task task) {
        EsqlStatsResponse.NodeStatsResponse statsResponse = new EsqlStatsResponse.NodeStatsResponse(this.clusterService.localNode());
        statsResponse.setStats(this.planExecutor.metrics().stats());
        return statsResponse;
    }
}

