/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.inference.Rerank;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.esql.plan.physical.inference.InferenceExec;

public class RerankExec
extends InferenceExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "RerankExec", RerankExec::new);
    private final Expression queryText;
    private final List<Alias> rerankFields;
    private final Attribute scoreAttribute;
    private List<Attribute> lazyOutput;

    public RerankExec(Source source, PhysicalPlan child, Expression inferenceId, Expression queryText, List<Alias> rerankFields, Attribute scoreAttribute) {
        super(source, child, inferenceId);
        this.queryText = queryText;
        this.rerankFields = rerankFields;
        this.scoreAttribute = scoreAttribute;
    }

    public RerankExec(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), in.readCollectionAsList(Alias::new), (Attribute)in.readNamedWriteable(Attribute.class));
    }

    public Expression queryText() {
        return this.queryText;
    }

    public List<Alias> rerankFields() {
        return this.rerankFields;
    }

    public Attribute scoreAttribute() {
        return this.scoreAttribute;
    }

    public String getWriteableName() {
        return RerankExec.ENTRY.name;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.queryText());
        out.writeCollection(this.rerankFields());
        out.writeNamedWriteable((NamedWriteable)this.scoreAttribute);
    }

    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create((Node)this, RerankExec::new, (Object)((Object)this.child()), (Object)this.inferenceId(), (Object)this.queryText, this.rerankFields, (Object)this.scoreAttribute);
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new RerankExec(this.source(), newChild, this.inferenceId(), this.queryText, this.rerankFields, this.scoreAttribute);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(List.of(this.scoreAttribute), this.child().output());
        }
        return this.lazyOutput;
    }

    @Override
    protected AttributeSet computeReferences() {
        return Rerank.computeReferences(this.rerankFields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RerankExec rerank = (RerankExec)((Object)o);
        return Objects.equals(this.queryText, rerank.queryText) && Objects.equals(this.rerankFields, rerank.rerankFields) && Objects.equals(this.scoreAttribute, rerank.scoreAttribute);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.queryText, this.rerankFields, this.scoreAttribute);
    }
}

