/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class TimeSeriesAggregateExec
extends AggregateExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "TimeSeriesAggregateExec", TimeSeriesAggregateExec::new);
    private final Bucket timeBucket;

    public TimeSeriesAggregateExec(Source source, PhysicalPlan child, List<? extends Expression> groupings, List<? extends NamedExpression> aggregates, AggregatorMode mode, List<Attribute> intermediateAttributes, Integer estimatedRowSize, Bucket timeBucket) {
        super(source, child, groupings, aggregates, mode, intermediateAttributes, estimatedRowSize);
        this.timeBucket = timeBucket;
    }

    private TimeSeriesAggregateExec(StreamInput in) throws IOException {
        super(in);
        this.timeBucket = (Bucket)in.readOptionalWriteable(inp -> (Bucket)Bucket.ENTRY.reader.read(inp));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.timeBucket);
    }

    @Override
    public String getWriteableName() {
        return TimeSeriesAggregateExec.ENTRY.name;
    }

    @Override
    protected NodeInfo<AggregateExec> info() {
        return NodeInfo.create((Node)this, TimeSeriesAggregateExec::new, (Object)((Object)this.child()), this.groupings(), this.aggregates(), (Object)this.getMode(), this.intermediateAttributes(), (Object)this.estimatedRowSize(), (Object)this.timeBucket);
    }

    @Override
    public TimeSeriesAggregateExec replaceChild(PhysicalPlan newChild) {
        return new TimeSeriesAggregateExec(this.source(), newChild, this.groupings(), this.aggregates(), this.getMode(), this.intermediateAttributes(), this.estimatedRowSize(), this.timeBucket);
    }

    @Override
    public AggregateExec withAggregates(List<? extends NamedExpression> newAggregates) {
        return new TimeSeriesAggregateExec(this.source(), this.child(), this.groupings(), newAggregates, this.getMode(), this.intermediateAttributes(), this.estimatedRowSize(), this.timeBucket);
    }

    @Override
    public TimeSeriesAggregateExec withMode(AggregatorMode newMode) {
        return new TimeSeriesAggregateExec(this.source(), this.child(), this.groupings(), this.aggregates(), newMode, this.intermediateAttributes(), this.estimatedRowSize(), this.timeBucket);
    }

    @Override
    protected AggregateExec withEstimatedSize(int estimatedRowSize) {
        return new TimeSeriesAggregateExec(this.source(), this.child(), this.groupings(), this.aggregates(), this.getMode(), this.intermediateAttributes(), estimatedRowSize, this.timeBucket);
    }

    public Bucket timeBucket() {
        return this.timeBucket;
    }

    public Rounding.Prepared timeBucketRounding(FoldContext foldContext) {
        if (this.timeBucket == null) {
            return null;
        }
        Rounding.Prepared rounding = this.timeBucket.getDateRoundingOrNull(foldContext);
        if (rounding == null) {
            throw new EsqlIllegalArgumentException("expected TBUCKET; got ", this.timeBucket);
        }
        return rounding;
    }
}

