/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Limit
extends UnaryPlan
implements TelemetryAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Limit", Limit::new);
    private final Expression limit;
    private final transient boolean duplicated;

    public Limit(Source source, Expression limit, LogicalPlan child) {
        this(source, limit, child, false);
    }

    public Limit(Source source, Expression limit, LogicalPlan child, boolean duplicated) {
        super(source, child);
        this.limit = limit;
        this.duplicated = duplicated;
    }

    private Limit(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), false);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.limit());
        out.writeNamedWriteable((NamedWriteable)this.child());
        assert (!this.duplicated);
    }

    public String getWriteableName() {
        return Limit.ENTRY.name;
    }

    protected NodeInfo<Limit> info() {
        return NodeInfo.create((Node)this, Limit::new, (Object)this.limit, (Object)((Object)this.child()), (Object)this.duplicated);
    }

    @Override
    public Limit replaceChild(LogicalPlan newChild) {
        return new Limit(this.source(), this.limit, newChild, this.duplicated);
    }

    public Expression limit() {
        return this.limit;
    }

    public Limit withLimit(Expression limit) {
        return new Limit(this.source(), limit, this.child(), this.duplicated);
    }

    public boolean duplicated() {
        return this.duplicated;
    }

    public Limit withDuplicated(boolean duplicated) {
        return new Limit(this.source(), this.limit, this.child(), duplicated);
    }

    @Override
    public boolean expressionsResolved() {
        return this.limit.resolved();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.limit, this.child(), this.duplicated});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limit other = (Limit)obj;
        return Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.child(), (Object)other.child()) && this.duplicated == other.duplicated;
    }
}

