/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneEmptyPlans;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public final class PruneFilters
extends OptimizerRules.OptimizerRule<Filter> {
    @Override
    protected LogicalPlan rule(Filter filter) {
        Expression condition = (Expression)filter.condition().transformUp(BinaryLogic.class, PruneFilters::foldBinaryLogic);
        if (condition instanceof Literal) {
            if (Literal.TRUE.equals((Object)condition)) {
                return filter.child();
            }
            if (Literal.FALSE.equals((Object)condition) || Expressions.isGuaranteedNull((Expression)condition)) {
                return PruneEmptyPlans.skipPlan(filter);
            }
        }
        if (!condition.equals((Object)filter.condition())) {
            return new Filter(filter.source(), filter.child(), condition);
        }
        return filter;
    }

    private static Expression foldBinaryLogic(BinaryLogic binaryLogic) {
        And and;
        if (binaryLogic instanceof Or) {
            Or or = (Or)binaryLogic;
            boolean nullLeft = Expressions.isGuaranteedNull((Expression)or.left());
            boolean nullRight = Expressions.isGuaranteedNull((Expression)or.right());
            if (nullLeft && nullRight) {
                return new Literal(binaryLogic.source(), null, DataType.NULL);
            }
            if (nullLeft) {
                return or.right();
            }
            if (nullRight) {
                return or.left();
            }
        }
        if (binaryLogic instanceof And && (Expressions.isGuaranteedNull((Expression)(and = (And)binaryLogic).left()) || Expressions.isGuaranteedNull((Expression)and.right()))) {
            return new Literal(binaryLogic.source(), null, DataType.NULL);
        }
        return binaryLogic;
    }
}

