/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;

public abstract class BinarySpatialFunction
extends BinaryScalarFunction
implements SpatialEvaluatorFactory.SpatialSourceResolution {
    private final SpatialTypeResolver spatialTypeResolver;
    private SpatialCrsType crsType;
    protected final boolean leftDocValues;
    protected final boolean rightDocValues;
    private static final String[] GEO_TYPE_NAMES = new String[]{DataType.GEO_POINT.typeName(), DataType.GEO_SHAPE.typeName()};
    private static final String[] CARTESIAN_TYPE_NAMES = new String[]{DataType.CARTESIAN_POINT.typeName(), DataType.CARTESIAN_SHAPE.typeName()};

    protected BinarySpatialFunction(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues, boolean pointsOnly) {
        super(source, left, right);
        this.leftDocValues = leftDocValues;
        this.rightDocValues = rightDocValues;
        this.spatialTypeResolver = new SpatialTypeResolver(this, pointsOnly);
    }

    protected BinarySpatialFunction(StreamInput in, boolean leftDocValues, boolean rightDocValues, boolean pointsOnly) throws IOException {
        this(in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS) ? Source.readFrom((StreamInput)((PlanStreamInput)in)) : Source.EMPTY, (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), leftDocValues, rightDocValues, pointsOnly);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS)) {
            this.source().writeTo(out);
        }
        out.writeNamedWriteable((NamedWriteable)this.left());
        out.writeNamedWriteable((NamedWriteable)this.right());
    }

    public abstract BinarySpatialFunction withDocValues(boolean var1, boolean var2);

    public int hashCode() {
        return Objects.hash(this.getClass(), this.children(), this.leftDocValues, this.rightDocValues);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            BinarySpatialFunction other = (BinarySpatialFunction)obj;
            return Objects.equals(other.children(), this.children()) && Objects.equals(other.leftDocValues, this.leftDocValues) && Objects.equals(other.rightDocValues, this.rightDocValues);
        }
        return false;
    }

    protected Expression.TypeResolution resolveType() {
        return this.spatialTypeResolver.resolveType();
    }

    @Override
    public void setCrsType(DataType dataType) {
        this.crsType = SpatialCrsType.fromDataType(dataType);
    }

    protected static boolean spatialCRSCompatible(DataType spatialDataType, DataType otherDataType) {
        return DataType.isSpatialGeo((DataType)spatialDataType) && DataType.isSpatialGeo((DataType)otherDataType) || !DataType.isSpatialGeo((DataType)spatialDataType) && !DataType.isSpatialGeo((DataType)otherDataType);
    }

    static String[] compatibleTypeNames(DataType spatialDataType) {
        return DataType.isSpatialGeo((DataType)spatialDataType) ? GEO_TYPE_NAMES : CARTESIAN_TYPE_NAMES;
    }

    @Override
    public SpatialCrsType crsType() {
        if (this.crsType == null) {
            this.resolveType();
        }
        return this.crsType;
    }

    @Override
    public boolean leftDocValues() {
        return this.leftDocValues;
    }

    @Override
    public boolean rightDocValues() {
        return this.rightDocValues;
    }

    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return BinarySpatialFunction.isPushableSpatialAttribute(this.left(), pushdownPredicates) && this.right().foldable() || BinarySpatialFunction.isPushableSpatialAttribute(this.right(), pushdownPredicates) && this.left().foldable() ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
    }

    private static boolean isPushableSpatialAttribute(Expression exp, LucenePushdownPredicates p) {
        FieldAttribute fa;
        return exp instanceof FieldAttribute && DataType.isSpatial((DataType)(fa = (FieldAttribute)exp).dataType()) && fa.getExactInfo().hasExact() && p.isIndexed(fa);
    }

    static class SpatialTypeResolver {
        private final SpatialEvaluatorFactory.SpatialSourceResolution supplier;
        private final boolean pointsOnly;

        SpatialTypeResolver(SpatialEvaluatorFactory.SpatialSourceResolution supplier, boolean pointsOnly) {
            this.supplier = supplier;
            this.pointsOnly = pointsOnly;
        }

        public Expression left() {
            return this.supplier.left();
        }

        public Expression right() {
            return this.supplier.right();
        }

        public String sourceText() {
            return this.supplier.source().text();
        }

        protected Expression.TypeResolution resolveType() {
            if (this.left().foldable() && !this.right().foldable() || DataType.isNull((DataType)this.left().dataType())) {
                return this.resolveType(this.right(), this.left(), TypeResolutions.ParamOrdinal.SECOND, TypeResolutions.ParamOrdinal.FIRST);
            }
            return this.resolveType(this.left(), this.right(), TypeResolutions.ParamOrdinal.FIRST, TypeResolutions.ParamOrdinal.SECOND);
        }

        protected Expression.TypeResolution isSpatial(Expression e, TypeResolutions.ParamOrdinal paramOrd) {
            return this.pointsOnly ? EsqlTypeResolutions.isSpatialPoint(e, this.sourceText(), paramOrd) : EsqlTypeResolutions.isSpatial(e, this.sourceText(), paramOrd);
        }

        private Expression.TypeResolution resolveType(Expression leftExpression, Expression rightExpression, TypeResolutions.ParamOrdinal leftOrdinal, TypeResolutions.ParamOrdinal rightOrdinal) {
            Expression.TypeResolution leftResolution = this.isSpatial(leftExpression, leftOrdinal);
            Expression.TypeResolution rightResolution = this.isSpatial(rightExpression, rightOrdinal);
            if (leftResolution.resolved()) {
                return this.resolveType(leftExpression, rightExpression, rightOrdinal);
            }
            if (rightResolution.resolved()) {
                return this.resolveType(rightExpression, leftExpression, leftOrdinal);
            }
            return leftResolution;
        }

        protected Expression.TypeResolution resolveType(Expression spatialExpression, Expression otherExpression, TypeResolutions.ParamOrdinal otherParamOrdinal) {
            if (DataType.isNull((DataType)spatialExpression.dataType())) {
                return this.isSpatial(otherExpression, otherParamOrdinal);
            }
            Expression.TypeResolution resolution = this.isSameSpatialType(spatialExpression.dataType(), otherExpression, this.sourceText(), otherParamOrdinal);
            if (resolution.unresolved()) {
                return resolution;
            }
            this.supplier.setCrsType(spatialExpression.dataType());
            return Expression.TypeResolution.TYPE_RESOLVED;
        }

        protected Expression.TypeResolution isSameSpatialType(DataType spatialDataType, Expression expression, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
            return this.pointsOnly ? TypeResolutions.isType((Expression)expression, dt -> dt == spatialDataType, (String)operationName, (TypeResolutions.ParamOrdinal)paramOrd, (String[])BinarySpatialFunction.compatibleTypeNames(spatialDataType)) : TypeResolutions.isType((Expression)expression, dt -> DataType.isSpatial((DataType)dt) && BinarySpatialFunction.spatialCRSCompatible(spatialDataType, dt), (String)operationName, (TypeResolutions.ParamOrdinal)paramOrd, (String[])BinarySpatialFunction.compatibleTypeNames(spatialDataType));
        }
    }

    public static enum SpatialCrsType {
        GEO,
        CARTESIAN,
        UNSPECIFIED;


        public static SpatialCrsType fromDataType(DataType dataType) {
            return DataType.isSpatialGeo((DataType)dataType) ? GEO : (DataType.isSpatial((DataType)dataType) ? CARTESIAN : UNSPECIFIED);
        }
    }

    protected static abstract class BinarySpatialComparator<T> {
        protected final SpatialCoordinateTypes spatialCoordinateType;
        protected final CoordinateEncoder coordinateEncoder;
        protected final SpatialCrsType crsType;

        protected BinarySpatialComparator(SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder) {
            this.spatialCoordinateType = spatialCoordinateType;
            this.coordinateEncoder = encoder;
            this.crsType = spatialCoordinateType.equals((Object)SpatialCoordinateTypes.GEO) ? SpatialCrsType.GEO : SpatialCrsType.CARTESIAN;
        }

        protected Geometry fromBytesRef(BytesRef bytesRef) {
            return SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(bytesRef);
        }

        protected abstract T compare(BytesRef var1, BytesRef var2) throws IOException;
    }
}

