/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log;

public final class LogEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LogEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator base;
    private final EvalOperator.ExpressionEvaluator value;
    private final DriverContext driverContext;
    private Warnings warnings;

    public LogEvaluator(Source source, EvalOperator.ExpressionEvaluator base, EvalOperator.ExpressionEvaluator value, DriverContext driverContext) {
        this.source = source;
        this.base = base;
        this.value = value;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock baseBlock = (DoubleBlock)this.base.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                DoubleVector valueVector;
                DoubleVector baseVector;
                DoubleBlock valueBlock;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                valueBlock = (DoubleBlock)this.value.eval(page);
                                try {
                                    baseVector = baseBlock.asVector();
                                    if (baseVector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), baseBlock, valueBlock);
                                    if (valueBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (valueBlock != null) {
                                        try {
                                            valueBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                valueBlock.close();
                            }
                            return doubleBlock3;
                        }
                        valueVector = valueBlock.asVector();
                        if (valueVector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), baseBlock, valueBlock);
                        if (valueBlock == null) break block19;
                        valueBlock.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), baseVector, valueVector);
                if (valueBlock == null) break block20;
                valueBlock.close();
            }
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.base.baseRamBytesUsed();
        return baseRamBytesUsed += this.value.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock baseBlock, DoubleBlock valueBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (baseBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (baseBlock.getValueCount(p) != 1) {
                    if (baseBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (valueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valueBlock.getValueCount(p) != 1) {
                    if (valueBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendDouble(Log.process(baseBlock.getDouble(baseBlock.getFirstValueIndex(p)), valueBlock.getDouble(valueBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleVector baseVector, DoubleVector valueVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendDouble(Log.process(baseVector.getDouble(p), valueVector.getDouble(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "LogEvaluator[base=" + String.valueOf(this.base) + ", value=" + String.valueOf(this.value) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.base, this.value});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory base;
        private final EvalOperator.ExpressionEvaluator.Factory value;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory base, EvalOperator.ExpressionEvaluator.Factory value) {
            this.source = source;
            this.base = base;
            this.value = value;
        }

        public LogEvaluator get(DriverContext context) {
            return new LogEvaluator(this.source, this.base.get(context), this.value.get(context), context);
        }

        public String toString() {
            return "LogEvaluator[base=" + String.valueOf(this.base) + ", value=" + String.valueOf(this.value) + "]";
        }
    }
}

