/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormatMillisConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormatMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormatNanosConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormatNanosEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class DateFormat
extends EsqlConfigurationFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DateFormat", DateFormat::new);
    private final Expression field;
    private final Expression format;

    @FunctionInfo(returnType={"keyword"}, description="Returns a string representation of a date, in the provided format.", examples={@Example(file="date", tag="docsDateFormat")})
    public DateFormat(Source source, @Param(optional=true, name="dateFormat", type={"keyword", "text", "date", "date_nanos"}, description="Date format (optional).  If no format is specified, the `yyyy-MM-dd'T'HH:mm:ss.SSSZ` format is used.\nIf `null`, the function returns `null`.") Expression format, @Param(name="date", type={"date", "date_nanos"}, description="Date expression. If `null`, the function returns `null`.") Expression date, Configuration configuration) {
        super(source, date != null ? List.of(format, date) : List.of(format), configuration);
        this.field = date != null ? date : format;
        this.format = date != null ? format : null;
    }

    private DateFormat(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class), ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeOptionalNamedWriteable(this.children().size() == 2 ? (NamedWriteable)this.children().get(1) : null);
    }

    public String getWriteableName() {
        return DateFormat.ENTRY.name;
    }

    Expression field() {
        return this.field;
    }

    Expression format() {
        return this.format;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        TypeResolutions.ParamOrdinal paramOrd;
        Expression.TypeResolution resolution;
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.format != null && (resolution = EsqlTypeResolutions.isStringAndExact(this.format, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST)).unresolved()) {
            return resolution;
        }
        String operationName = this.sourceText();
        resolution = TypeResolutions.isType((Expression)this.field, DataType::isDate, (String)operationName, (TypeResolutions.ParamOrdinal)(paramOrd = this.format == null ? TypeResolutions.ParamOrdinal.FIRST : TypeResolutions.ParamOrdinal.SECOND), (String[])new String[]{"datetime or date_nanos"});
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public boolean foldable() {
        return this.field.foldable() && (this.format == null || this.format.foldable());
    }

    static BytesRef processMillis(long val, DateFormatter formatter) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.dateTimeToString(val, formatter));
    }

    static BytesRef processMillis(long val, BytesRef formatter, Locale locale) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.dateTimeToString(val, DateFormat.toFormatter(formatter, locale)));
    }

    static BytesRef processNanos(long val, DateFormatter formatter) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.nanoTimeToString(val, formatter));
    }

    static BytesRef processNanos(long val, BytesRef formatter, Locale locale) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.nanoTimeToString(val, DateFormat.toFormatter(formatter, locale)));
    }

    private EvalOperator.ExpressionEvaluator.Factory getConstantEvaluator(DataType dateType, EvalOperator.ExpressionEvaluator.Factory fieldEvaluator, DateFormatter formatter) {
        if (dateType == DataType.DATE_NANOS) {
            return new DateFormatNanosConstantEvaluator.Factory(this.source(), fieldEvaluator, formatter);
        }
        return new DateFormatMillisConstantEvaluator.Factory(this.source(), fieldEvaluator, formatter);
    }

    private EvalOperator.ExpressionEvaluator.Factory getEvaluator(DataType dateType, EvalOperator.ExpressionEvaluator.Factory fieldEvaluator, EvalOperator.ExpressionEvaluator.Factory formatEvaluator) {
        if (dateType == DataType.DATE_NANOS) {
            return new DateFormatNanosEvaluator.Factory(this.source(), fieldEvaluator, formatEvaluator, this.configuration().locale());
        }
        return new DateFormatMillisEvaluator.Factory(this.source(), fieldEvaluator, formatEvaluator, this.configuration().locale());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        if (this.format == null) {
            return this.getConstantEvaluator(this.field().dataType(), fieldEvaluator, EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER);
        }
        if (!DataType.isString((DataType)this.format.dataType())) {
            throw new IllegalArgumentException("unsupported data type for format [" + String.valueOf(this.format.dataType()) + "]");
        }
        if (this.format.foldable()) {
            DateFormatter formatter = DateFormat.toFormatter(this.format.fold(toEvaluator.foldCtx()), this.configuration().locale());
            return this.getConstantEvaluator(this.field.dataType(), fieldEvaluator, formatter);
        }
        EvalOperator.ExpressionEvaluator.Factory formatEvaluator = toEvaluator.apply(this.format);
        return this.getEvaluator(this.field().dataType(), fieldEvaluator, formatEvaluator);
    }

    private static DateFormatter toFormatter(Object format, Locale locale) {
        DateFormatter result = format == null ? EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER : DateFormatter.forPattern((String)((BytesRef)format).utf8ToString());
        return result.withLocale(locale);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateFormat(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null, this.configuration());
    }

    protected NodeInfo<? extends Expression> info() {
        Expression first = this.format != null ? this.format : this.field;
        Expression second = this.format != null ? this.field : null;
        return NodeInfo.create((Node)this, DateFormat::new, (Object)first, (Object)second, (Object)this.configuration());
    }
}

