/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Order
extends Expression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Order", Order::new);
    private final Expression child;
    private final OrderDirection direction;
    private final NullsPosition nulls;

    public Order(Source source, Expression child, OrderDirection direction, NullsPosition nulls) {
        super(source, List.of(child));
        this.child = child;
        this.direction = direction;
        this.nulls = nulls == null ? NullsPosition.ANY : nulls;
    }

    public Order(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (OrderDirection)in.readEnum(OrderDirection.class), (NullsPosition)in.readEnum(NullsPosition.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child);
        out.writeEnum((Enum)this.direction);
        out.writeEnum((Enum)this.nulls);
    }

    public String getWriteableName() {
        return Order.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        if (DataType.isString((DataType)this.child.dataType())) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return TypeResolutions.isExact((Expression)this.child, (String)"ORDER BY cannot be applied to field of data type [{}]: {}");
    }

    public DataType dataType() {
        return this.child.dataType();
    }

    public Order replaceChildren(List<Expression> newChildren) {
        return new Order(this.source(), newChildren.get(0), this.direction, this.nulls);
    }

    protected NodeInfo<Order> info() {
        return NodeInfo.create((Node)this, Order::new, (Object)this.child, (Object)((Object)this.direction), (Object)((Object)this.nulls));
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public Expression child() {
        return this.child;
    }

    public OrderDirection direction() {
        return this.direction;
    }

    public NullsPosition nullsPosition() {
        return this.nulls;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.child, this.direction, this.nulls});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)((Object)obj);
        return Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals((Object)this.nulls, (Object)other.nulls) && Objects.equals(this.child, other.child);
    }

    public static enum OrderDirection {
        ASC,
        DESC;

    }

    public static enum NullsPosition {
        FIRST,
        LAST,
        ANY;

    }
}

