/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;

public class PreAnalyzer {
    public PreAnalysis preAnalyze(LogicalPlan plan) {
        if (plan.analyzed()) {
            return PreAnalysis.EMPTY;
        }
        return this.doPreAnalyze(plan);
    }

    protected PreAnalysis doPreAnalyze(LogicalPlan plan) {
        HashSet indices = new HashSet();
        ArrayList<Enrich> unresolvedEnriches = new ArrayList<Enrich>();
        ArrayList<IndexPattern> lookupIndices = new ArrayList<IndexPattern>();
        ArrayList unresolvedInferencePlans = new ArrayList();
        Holder indexMode = new Holder();
        plan.forEachUp(UnresolvedRelation.class, p -> {
            if (p.indexMode() == IndexMode.LOOKUP) {
                lookupIndices.add(p.indexPattern());
            } else if (indexMode.get() == null || indexMode.get() == p.indexMode()) {
                indexMode.set((Object)p.indexMode());
                indices.add(p.indexPattern());
            } else {
                throw new IllegalStateException("index mode is already set");
            }
        });
        plan.forEachUp(Enrich.class, unresolvedEnriches::add);
        plan.forEachUp(InferencePlan.class, unresolvedInferencePlans::add);
        plan.forEachUp(LogicalPlan::setPreAnalyzed);
        return new PreAnalysis((IndexMode)indexMode.get(), indices.stream().toList(), unresolvedEnriches, unresolvedInferencePlans, lookupIndices);
    }

    public static class PreAnalysis {
        public static final PreAnalysis EMPTY = new PreAnalysis(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        public final IndexMode indexMode;
        public final List<IndexPattern> indices;
        public final List<Enrich> enriches;
        public final List<InferencePlan<?>> inferencePlans;
        public final List<IndexPattern> lookupIndices;

        public PreAnalysis(IndexMode indexMode, List<IndexPattern> indices, List<Enrich> enriches, List<InferencePlan<?>> inferencePlans, List<IndexPattern> lookupIndices) {
            this.indexMode = indexMode;
            this.indices = indices;
            this.enriches = enriches;
            this.inferencePlans = inferencePlans;
            this.lookupIndices = lookupIndices;
        }
    }
}

