/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.InternalCartesianCentroid;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianPointValuesSource;

public final class CartesianCentroidAggregator
extends MetricsAggregator {
    private final CartesianPointValuesSource valuesSource;
    private DoubleArray xSum;
    private DoubleArray xCompensations;
    private DoubleArray ySum;
    private DoubleArray yCompensations;
    private LongArray counts;

    public CartesianCentroidAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (CartesianPointValuesSource)valuesSourceConfig.getValuesSource();
        this.xSum = this.bigArrays().newDoubleArray(1L, true);
        this.xCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.ySum = this.bigArrays().newDoubleArray(1L, true);
        this.yCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.counts = this.bigArrays().newLongArray(1L, true);
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
        final CartesianPointValuesSource.MultiCartesianPointValues values = this.valuesSource.pointValues(aggCtx.getLeafReaderContext());
        final CompensatedSum compensatedSumX = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumY = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, (Object)values){

            public void collect(int doc, long bucket) throws IOException {
                CartesianCentroidAggregator.this.xSum = CartesianCentroidAggregator.this.bigArrays().grow(CartesianCentroidAggregator.this.xSum, bucket + 1L);
                CartesianCentroidAggregator.this.ySum = CartesianCentroidAggregator.this.bigArrays().grow(CartesianCentroidAggregator.this.ySum, bucket + 1L);
                CartesianCentroidAggregator.this.xCompensations = CartesianCentroidAggregator.this.bigArrays().grow(CartesianCentroidAggregator.this.xCompensations, bucket + 1L);
                CartesianCentroidAggregator.this.yCompensations = CartesianCentroidAggregator.this.bigArrays().grow(CartesianCentroidAggregator.this.yCompensations, bucket + 1L);
                CartesianCentroidAggregator.this.counts = CartesianCentroidAggregator.this.bigArrays().grow(CartesianCentroidAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    CartesianCentroidAggregator.this.counts.increment(bucket, (long)valueCount);
                    double sumX = CartesianCentroidAggregator.this.xSum.get(bucket);
                    double compensationX = CartesianCentroidAggregator.this.xCompensations.get(bucket);
                    double sumY = CartesianCentroidAggregator.this.ySum.get(bucket);
                    double compensationY = CartesianCentroidAggregator.this.yCompensations.get(bucket);
                    compensatedSumX.reset(sumX, compensationX);
                    compensatedSumY.reset(sumY, compensationY);
                    for (int i = 0; i < valueCount; ++i) {
                        CartesianPoint value = values.nextValue();
                        compensatedSumX.add(value.getX());
                        compensatedSumY.add(value.getY());
                    }
                    CartesianCentroidAggregator.this.xSum.set(bucket, compensatedSumX.value());
                    CartesianCentroidAggregator.this.xCompensations.set(bucket, compensatedSumX.delta());
                    CartesianCentroidAggregator.this.ySum.set(bucket, compensatedSumY.value());
                    CartesianCentroidAggregator.this.yCompensations.set(bucket, compensatedSumY.delta());
                }
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        CartesianPoint bucketCentroid = bucketCount > 0L ? new CartesianPoint(this.xSum.get(bucket) / (double)bucketCount, this.ySum.get(bucket) / (double)bucketCount) : null;
        return new InternalCartesianCentroid(this.name, bucketCentroid, bucketCount, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return InternalCartesianCentroid.empty(this.name, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.xSum, this.xCompensations, this.ySum, this.yCompensations, this.counts});
    }
}

