/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;
import org.elasticsearch.xpack.spatial.common.H3CartesianUtil;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;

class GeoHexVisitor
extends TriangleTreeVisitor.TriangleTreeDecodedVisitor {
    private GeoRelation relation;
    private final double[] xs = new double[15];
    private final double[] ys = new double[15];
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private boolean crossesDateline;
    private int numPoints;

    GeoHexVisitor() {
        super(CoordinateEncoder.GEO);
    }

    public double[] getXs() {
        return ArrayUtil.copyOfSubArray((double[])this.xs, (int)0, (int)this.numPoints);
    }

    public double[] getYs() {
        return ArrayUtil.copyOfSubArray((double[])this.ys, (int)0, (int)this.numPoints);
    }

    public double getLeftX() {
        return this.crossesDateline ? this.maxX : this.minX;
    }

    public double getRightX() {
        return this.crossesDateline ? this.minX : this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void reset(long h3) {
        this.numPoints = H3CartesianUtil.computePoints(h3, this.xs, this.ys);
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numPoints; ++i) {
            minX = Math.min(minX, this.xs[i]);
            maxX = Math.max(maxX, this.xs[i]);
            minY = Math.min(minY, this.ys[i]);
            maxY = Math.max(maxY, this.ys[i]);
        }
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.crossesDateline = maxX - minX > 180.0 && !H3CartesianUtil.isPolar(h3);
    }

    public GeoRelation relation() {
        return this.relation;
    }

    public void visitDecodedPoint(double x, double y) {
        this.updateRelation(this.relatePoint(x, y));
    }

    protected void visitDecodedLine(double aX, double aY, double bX, double bY, byte metadata) {
        this.updateRelation(this.relateLine(aX, aY, bX, bY));
    }

    protected void visitDecodedTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
        boolean ab = TriangleTreeVisitor.abFromTriangle((byte)metadata);
        boolean bc = TriangleTreeVisitor.bcFromTriangle((byte)metadata);
        boolean ca = TriangleTreeVisitor.caFromTriangle((byte)metadata);
        this.updateRelation(this.relateTriangle(aX, aY, ab, bX, bY, bc, cX, cY, ca));
    }

    private void updateRelation(GeoRelation relation) {
        if (relation != GeoRelation.QUERY_DISJOINT) {
            this.relation = relation == GeoRelation.QUERY_INSIDE && this.canBeInside() ? GeoRelation.QUERY_INSIDE : (relation == GeoRelation.QUERY_CONTAINS && this.canBeContained() ? GeoRelation.QUERY_CONTAINS : GeoRelation.QUERY_CROSSES);
        } else {
            this.adjustRelationForNotIntersectingComponent();
        }
    }

    private void adjustRelationForNotIntersectingComponent() {
        if (this.relation == null) {
            this.relation = GeoRelation.QUERY_DISJOINT;
        } else if (this.relation == GeoRelation.QUERY_CONTAINS) {
            this.relation = GeoRelation.QUERY_CROSSES;
        }
    }

    private boolean canBeContained() {
        return this.relation == null || this.relation == GeoRelation.QUERY_CONTAINS;
    }

    private boolean canBeInside() {
        return this.relation != GeoRelation.QUERY_CONTAINS;
    }

    public boolean push() {
        return this.relation != GeoRelation.QUERY_CROSSES;
    }

    public boolean pushDecodedX(double minX) {
        if (this.crossesDateline || this.maxX >= minX) {
            return true;
        }
        this.adjustRelationForNotIntersectingComponent();
        return false;
    }

    public boolean pushDecodedY(double minY) {
        if (this.maxY >= minY) {
            return true;
        }
        this.adjustRelationForNotIntersectingComponent();
        return false;
    }

    public boolean pushDecoded(double maxX, double maxY) {
        if (this.minY <= maxY && (this.crossesDateline || this.minX <= maxX)) {
            return true;
        }
        this.adjustRelationForNotIntersectingComponent();
        return false;
    }

    public boolean pushDecoded(double minX, double minY, double maxX, double maxY) {
        if (this.boxesAreDisjoint(minX, maxX, minY, maxY)) {
            this.relation = GeoRelation.QUERY_DISJOINT;
            return false;
        }
        this.relation = null;
        return true;
    }

    public boolean intersectsBbox(double minX, double maxX, double minY, double maxY) {
        if (minX > maxX) {
            return this.relateBbox(minX, 180.0, minY, maxY) || this.relateBbox(-180.0, maxX, minY, maxY);
        }
        return this.relateBbox(minX, maxX, minY, maxY);
    }

    private boolean relateBbox(double minX, double maxX, double minY, double maxY) {
        if (this.boxesAreDisjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        if (minX <= this.xs[0] && maxX >= this.xs[0] && minY <= this.ys[0] && maxY >= this.ys[0]) {
            return true;
        }
        return this.relatePoint(minX, minY) != GeoRelation.QUERY_DISJOINT || H3CartesianUtil.crossesBox(this.xs, this.ys, this.numPoints, this.crossesDateline, minX, maxX, minY, maxY, true);
    }

    private GeoRelation relatePoint(double x, double y) {
        if (this.boxesAreDisjoint(x, x, y, y)) {
            return GeoRelation.QUERY_DISJOINT;
        }
        return H3CartesianUtil.relatePoint(this.xs, this.ys, this.numPoints, this.crossesDateline, x, y);
    }

    private GeoRelation relateLine(double aX, double aY, double bX, double bY) {
        GeoRelation relation2;
        GeoRelation relation1 = this.relatePoint(aX, aY);
        if (relation1 != (relation2 = this.relatePoint(bX, bY)) || relation1 == GeoRelation.QUERY_CROSSES) {
            return GeoRelation.QUERY_CROSSES;
        }
        if (relation1 == GeoRelation.QUERY_CONTAINS) {
            double maxY;
            double minY;
            double maxX;
            double minX;
            if (this.crossesDateline && H3CartesianUtil.crossesLine(this.xs, this.ys, this.numPoints, this.crossesDateline, minX = Math.min(aX, bX), maxX = Math.max(aX, bX), minY = Math.min(aY, bY), maxY = Math.max(aY, bY), aX, aY, bX, bY, true)) {
                return GeoRelation.QUERY_CROSSES;
            }
            return GeoRelation.QUERY_CONTAINS;
        }
        if (this.edgeIntersectsQuery(aX, aY, bX, bY)) {
            return GeoRelation.QUERY_CROSSES;
        }
        return GeoRelation.QUERY_DISJOINT;
    }

    private GeoRelation relateTriangle(double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        double tMaxY;
        double tMinY;
        double tMaxX;
        double tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
        if (this.boxesAreDisjoint(tMinX, tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX), tMinY = StrictMath.min(StrictMath.min(aY, bY), cY), tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY))) {
            return GeoRelation.QUERY_DISJOINT;
        }
        GeoRelation relation1 = this.relatePoint(aX, aY);
        GeoRelation relation2 = this.relatePoint(bX, bY);
        GeoRelation relation3 = this.relatePoint(cX, cY);
        if (relation1 != relation2 || relation1 != relation3 || relation1 == GeoRelation.QUERY_CROSSES) {
            return GeoRelation.QUERY_CROSSES;
        }
        if (relation1 == GeoRelation.QUERY_CONTAINS) {
            if (this.crossesDateline && H3CartesianUtil.crossesTriangle(this.xs, this.ys, this.numPoints, this.crossesDateline, tMinX, tMaxX, tMinY, tMaxY, aX, aY, bX, bY, cX, cY, true)) {
                return GeoRelation.QUERY_CROSSES;
            }
            return GeoRelation.QUERY_CONTAINS;
        }
        boolean within = false;
        if (this.edgeIntersectsQuery(aX, aY, bX, bY)) {
            if (ab) {
                return GeoRelation.QUERY_CROSSES;
            }
            within = true;
        }
        if (this.edgeIntersectsQuery(bX, bY, cX, cY)) {
            if (bc) {
                return GeoRelation.QUERY_CROSSES;
            }
            within = true;
        }
        if (this.edgeIntersectsQuery(cX, cY, aX, aY)) {
            if (ca) {
                return GeoRelation.QUERY_CROSSES;
            }
            within = true;
        }
        if (within || Component2D.pointInTriangle((double)tMinX, (double)tMaxX, (double)tMinY, (double)tMaxY, (double)this.xs[0], (double)this.ys[0], (double)aX, (double)aY, (double)bX, (double)bY, (double)cX, (double)cY)) {
            return GeoRelation.QUERY_INSIDE;
        }
        return GeoRelation.QUERY_DISJOINT;
    }

    private boolean edgeIntersectsQuery(double ax, double ay, double bx, double by) {
        double maxY;
        double minY;
        double maxX;
        double minX = Math.min(ax, bx);
        return !this.boxesAreDisjoint(minX, maxX = Math.max(ax, bx), minY = Math.min(ay, by), maxY = Math.max(ay, by)) && H3CartesianUtil.crossesLine(this.xs, this.ys, this.numPoints, this.crossesDateline, minX, maxX, minY, maxY, ax, ay, bx, by, true);
    }

    private boolean boxesAreDisjoint(double minX, double maxX, double minY, double maxY) {
        if (!(maxY < this.minY || minY > this.maxY)) {
            if (this.crossesDateline) {
                return maxX < this.minX && minX > this.maxX;
            }
            return maxX < this.minX || minX > this.maxX;
        }
        return true;
    }
}

