/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bootstrap;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Platform;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyUtils;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.entitlements.CreateClassLoaderEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ExitVMEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.InboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.LoadNativeLibrariesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ManageThreadsEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.OutboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ReadJdkImageEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ReadStoreAttributesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.SetHttpsConnectionPropertiesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.WriteSystemPropertiesEntitlement;

class HardcodedEntitlements {
    HardcodedEntitlements() {
    }

    private static List<Scope> createServerEntitlements(Path pidFile) {
        ArrayList<Scope> serverScopes = new ArrayList<Scope>();
        ArrayList<FilesEntitlement.FileData> serverModuleFileDatas = new ArrayList<FilesEntitlement.FileData>();
        Collections.addAll(serverModuleFileDatas, FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.PLUGINS, FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.MODULES, FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.CONFIG, FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.LOGS, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.LIB, FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.SHARED_DATA, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.SHARED_REPO, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofRelativePath(Path.of("operator/settings.json", new String[0]), PathLookup.BaseDir.CONFIG, FilesEntitlement.Mode.READ_WRITE).withExclusive(true), FilesEntitlement.FileData.ofPath(Path.of("/etc/os-release", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/etc/system-release", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/usr/lib/os-release", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/sys/vm/max_map_count", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/meminfo", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/loadavg", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/self/cgroup", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/sys/fs/cgroup/", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/self/mountinfo", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/diskstats", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX));
        if (pidFile != null) {
            serverModuleFileDatas.add(FilesEntitlement.FileData.ofPath(pidFile, FilesEntitlement.Mode.READ_WRITE));
        }
        Collections.addAll(serverScopes, new Scope("org.elasticsearch.base", List.of(new CreateClassLoaderEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.SHARED_REPO, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.SHARED_DATA, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE))))), new Scope("org.elasticsearch.xcontent", List.of(new CreateClassLoaderEntitlement())), new Scope("org.elasticsearch.server", List.of(new ExitVMEntitlement(), new ReadStoreAttributesEntitlement(), new CreateClassLoaderEntitlement(), new InboundNetworkEntitlement(), new LoadNativeLibrariesEntitlement(), new ManageThreadsEntitlement(), new FilesEntitlement(serverModuleFileDatas))), new Scope("java.desktop", List.of(new LoadNativeLibrariesEntitlement(), new ManageThreadsEntitlement())), new Scope("java.xml", List.of(new ReadJdkImageEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.LIB, FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.MODULES, FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.PLUGINS, FilesEntitlement.Mode.READ))))), new Scope("org.apache.httpcomponents.httpclient", List.of(new OutboundNetworkEntitlement())), new Scope("org.apache.lucene.core", List.of(new LoadNativeLibrariesEntitlement(), new ManageThreadsEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.CONFIG, FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.SHARED_DATA, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE))))), new Scope("org.apache.lucene.misc", List.of(new FilesEntitlement(List.of(FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.SHARED_DATA, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE))), new ReadStoreAttributesEntitlement())), new Scope("org.apache.logging.log4j.core", List.of(new ManageThreadsEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.LOGS, FilesEntitlement.Mode.READ_WRITE))))), new Scope("org.elasticsearch.nativeaccess", List.of(new LoadNativeLibrariesEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.SHARED_DATA, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE))))));
        if (Booleans.parseBoolean((String)System.getProperty("org.bouncycastle.fips.approved_only"), (boolean)false)) {
            String trustStore = System.getProperty("javax.net.ssl.trustStore");
            Path trustStorePath = trustStore != null ? Path.of(trustStore, new String[0]) : Path.of(System.getProperty("java.home"), new String[0]).resolve("lib/security/jssecacerts");
            Collections.addAll(serverScopes, new Scope("org.bouncycastle.fips.tls", List.of(new FilesEntitlement(List.of(FilesEntitlement.FileData.ofPath(trustStorePath, FilesEntitlement.Mode.READ))), new ManageThreadsEntitlement(), new OutboundNetworkEntitlement())), new Scope("org.bouncycastle.fips.core", List.of(new FilesEntitlement(List.of(FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.LIB, FilesEntitlement.Mode.READ))), new ManageThreadsEntitlement())));
        }
        return serverScopes;
    }

    static Policy serverPolicy(Path pidFile, Policy serverPolicyPatch) {
        List<Scope> serverScopes = HardcodedEntitlements.createServerEntitlements(pidFile);
        return new Policy("server", serverPolicyPatch == null ? serverScopes : PolicyUtils.mergeScopes(serverScopes, serverPolicyPatch.scopes()));
    }

    static List<Entitlement> agentEntitlements() {
        return List.of(new CreateClassLoaderEntitlement(), new ManageThreadsEntitlement(), new SetHttpsConnectionPropertiesEntitlement(), new OutboundNetworkEntitlement(), new WriteSystemPropertiesEntitlement(Set.of("AsyncProfiler.safemode")), new LoadNativeLibrariesEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofBaseDirPath(PathLookup.BaseDir.LOGS, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofPath(Path.of("/proc/meminfo", new String[0]), FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofPath(Path.of("/sys/fs/cgroup/", new String[0]), FilesEntitlement.Mode.READ))));
    }
}

