/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AssuredReplicationRemoteLevel {
    NONE(0),
    RECEIVED_ANY_REMOTE_LOCATION(1),
    RECEIVED_ALL_REMOTE_LOCATIONS(2),
    PROCESSED_ALL_REMOTE_SERVERS(3);

    private final int intValue;

    private AssuredReplicationRemoteLevel(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static AssuredReplicationRemoteLevel valueOf(int intValue) {
        for (AssuredReplicationRemoteLevel l : AssuredReplicationRemoteLevel.values()) {
            if (l.intValue != intValue) continue;
            return l;
        }
        return null;
    }

    @Nullable
    public static AssuredReplicationRemoteLevel forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "none": {
                return NONE;
            }
            case "receivedanyremotelocation": 
            case "received-any-remote-location": 
            case "received_any_remote_location": {
                return RECEIVED_ANY_REMOTE_LOCATION;
            }
            case "receivedallremotelocations": 
            case "received-all-remote-locations": 
            case "received_all_remote_locations": {
                return RECEIVED_ALL_REMOTE_LOCATIONS;
            }
            case "processedallremoteservers": 
            case "processed-all-remote-servers": 
            case "processed_all_remote_servers": {
                return PROCESSED_ALL_REMOTE_SERVERS;
            }
        }
        return null;
    }

    @NotNull
    public static AssuredReplicationRemoteLevel getLessStrict(@NotNull AssuredReplicationRemoteLevel l1, @NotNull AssuredReplicationRemoteLevel l2) {
        if (l1.intValue <= l2.intValue) {
            return l1;
        }
        return l2;
    }

    @NotNull
    public static AssuredReplicationRemoteLevel getMoreStrict(@NotNull AssuredReplicationRemoteLevel l1, @NotNull AssuredReplicationRemoteLevel l2) {
        if (l1.intValue >= l2.intValue) {
            return l1;
        }
        return l2;
    }
}

