/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.KeyExtractorForBoolean;
import org.elasticsearch.compute.operator.topn.KeyExtractorForBytesRef;
import org.elasticsearch.compute.operator.topn.KeyExtractorForDouble;
import org.elasticsearch.compute.operator.topn.KeyExtractorForFloat;
import org.elasticsearch.compute.operator.topn.KeyExtractorForInt;
import org.elasticsearch.compute.operator.topn.KeyExtractorForLong;
import org.elasticsearch.compute.operator.topn.KeyExtractorForNull;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

interface KeyExtractor {
    public int writeKey(BreakingBytesRefBuilder var1, int var2);

    public static KeyExtractor extractorFor(ElementType elementType, TopNEncoder encoder, boolean ascending, byte nul, byte nonNul, Block block) {
        if (!(elementType == block.elementType() || ElementType.NULL == block.elementType())) {
            throw new IllegalArgumentException("Expected [" + String.valueOf((Object)elementType) + "] but was [" + String.valueOf((Object)block.elementType()) + "]");
        }
        return switch (block.elementType()) {
            case ElementType.BOOLEAN -> KeyExtractorForBoolean.extractorFor(encoder, ascending, nul, nonNul, (BooleanBlock)block);
            case ElementType.BYTES_REF -> KeyExtractorForBytesRef.extractorFor(encoder, ascending, nul, nonNul, (BytesRefBlock)block);
            case ElementType.INT -> KeyExtractorForInt.extractorFor(encoder, ascending, nul, nonNul, (IntBlock)block);
            case ElementType.LONG -> KeyExtractorForLong.extractorFor(encoder, ascending, nul, nonNul, (LongBlock)block);
            case ElementType.FLOAT -> KeyExtractorForFloat.extractorFor(encoder, ascending, nul, nonNul, (FloatBlock)block);
            case ElementType.DOUBLE -> KeyExtractorForDouble.extractorFor(encoder, ascending, nul, nonNul, (DoubleBlock)block);
            case ElementType.NULL -> new KeyExtractorForNull(nul);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("No key extractor for [" + String.valueOf((Object)block.elementType()) + "]"));
                }
                throw new UnsupportedOperationException("No key extractor for [" + String.valueOf((Object)block.elementType()) + "]");
            }
        };
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

