/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.mvdedupe;

import java.util.function.BiFunction;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.mvdedupe.BatchEncoder;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeBoolean;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeBytesRef;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeDouble;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeInt;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeLong;

public final class MultivalueDedupe {
    public static Block dedupeToBlockAdaptive(Block block, BlockFactory blockFactory) {
        return switch (block.elementType()) {
            case ElementType.BOOLEAN -> new MultivalueDedupeBoolean((BooleanBlock)block).dedupeToBlock(blockFactory);
            case ElementType.BYTES_REF -> new MultivalueDedupeBytesRef((BytesRefBlock)block).dedupeToBlockAdaptive(blockFactory);
            case ElementType.INT -> new MultivalueDedupeInt((IntBlock)block).dedupeToBlockAdaptive(blockFactory);
            case ElementType.LONG -> new MultivalueDedupeLong((LongBlock)block).dedupeToBlockAdaptive(blockFactory);
            case ElementType.DOUBLE -> new MultivalueDedupeDouble((DoubleBlock)block).dedupeToBlockAdaptive(blockFactory);
            case ElementType.NULL -> block;
            default -> throw new IllegalArgumentException();
        };
    }

    public static Block dedupeToBlockUsingCopyMissing(Block block, BlockFactory blockFactory) {
        return switch (block.elementType()) {
            case ElementType.BOOLEAN -> new MultivalueDedupeBoolean((BooleanBlock)block).dedupeToBlock(blockFactory);
            case ElementType.BYTES_REF -> new MultivalueDedupeBytesRef((BytesRefBlock)block).dedupeToBlockUsingCopyMissing(blockFactory);
            case ElementType.INT -> new MultivalueDedupeInt((IntBlock)block).dedupeToBlockUsingCopyMissing(blockFactory);
            case ElementType.LONG -> new MultivalueDedupeLong((LongBlock)block).dedupeToBlockUsingCopyMissing(blockFactory);
            case ElementType.DOUBLE -> new MultivalueDedupeDouble((DoubleBlock)block).dedupeToBlockUsingCopyMissing(blockFactory);
            case ElementType.NULL -> block;
            default -> throw new IllegalArgumentException();
        };
    }

    public static Block dedupeToBlockUsingCopyAndSort(Block block, BlockFactory blockFactory) {
        return switch (block.elementType()) {
            case ElementType.BOOLEAN -> new MultivalueDedupeBoolean((BooleanBlock)block).dedupeToBlock(blockFactory);
            case ElementType.BYTES_REF -> new MultivalueDedupeBytesRef((BytesRefBlock)block).dedupeToBlockUsingCopyAndSort(blockFactory);
            case ElementType.INT -> new MultivalueDedupeInt((IntBlock)block).dedupeToBlockUsingCopyAndSort(blockFactory);
            case ElementType.LONG -> new MultivalueDedupeLong((LongBlock)block).dedupeToBlockUsingCopyAndSort(blockFactory);
            case ElementType.DOUBLE -> new MultivalueDedupeDouble((DoubleBlock)block).dedupeToBlockUsingCopyAndSort(blockFactory);
            case ElementType.NULL -> block;
            default -> throw new IllegalArgumentException();
        };
    }

    public static EvalOperator.ExpressionEvaluator.Factory evaluator(ElementType elementType, EvalOperator.ExpressionEvaluator.Factory field) {
        return switch (elementType) {
            case ElementType.BOOLEAN -> new EvaluatorFactory(field, (blockFactory, block) -> new MultivalueDedupeBoolean((BooleanBlock)block).dedupeToBlock((BlockFactory)blockFactory));
            case ElementType.BYTES_REF -> new EvaluatorFactory(field, (blockFactory, block) -> new MultivalueDedupeBytesRef((BytesRefBlock)block).dedupeToBlockAdaptive((BlockFactory)blockFactory));
            case ElementType.INT -> new EvaluatorFactory(field, (blockFactory, block) -> new MultivalueDedupeInt((IntBlock)block).dedupeToBlockAdaptive((BlockFactory)blockFactory));
            case ElementType.LONG -> new EvaluatorFactory(field, (blockFactory, block) -> new MultivalueDedupeLong((LongBlock)block).dedupeToBlockAdaptive((BlockFactory)blockFactory));
            case ElementType.DOUBLE -> new EvaluatorFactory(field, (blockFactory, block) -> new MultivalueDedupeDouble((DoubleBlock)block).dedupeToBlockAdaptive((BlockFactory)blockFactory));
            case ElementType.NULL -> field;
            default -> throw new IllegalArgumentException("unsupported type [" + String.valueOf((Object)elementType) + "]");
        };
    }

    public static BatchEncoder batchEncoder(Block block, int batchSize, boolean allowDirectEncoder) {
        if (block.areAllValuesNull()) {
            if (!allowDirectEncoder) {
                throw new IllegalArgumentException("null blocks can only be directly encoded");
            }
            return new BatchEncoder.DirectNulls(block);
        }
        ElementType elementType = block.elementType();
        if (allowDirectEncoder && block.mvDeduplicated()) {
            return switch (elementType) {
                case ElementType.BOOLEAN -> new BatchEncoder.DirectBooleans((BooleanBlock)block);
                case ElementType.BYTES_REF -> new BatchEncoder.DirectBytesRefs((BytesRefBlock)block);
                case ElementType.INT -> new BatchEncoder.DirectInts((IntBlock)block);
                case ElementType.LONG -> new BatchEncoder.DirectLongs((LongBlock)block);
                case ElementType.DOUBLE -> new BatchEncoder.DirectDoubles((DoubleBlock)block);
                default -> throw new IllegalArgumentException("Unknown [" + String.valueOf((Object)elementType) + "]");
            };
        }
        return switch (elementType) {
            case ElementType.BOOLEAN -> new MultivalueDedupeBoolean((BooleanBlock)block).batchEncoder(batchSize);
            case ElementType.BYTES_REF -> new MultivalueDedupeBytesRef((BytesRefBlock)block).batchEncoder(batchSize);
            case ElementType.INT -> new MultivalueDedupeInt((IntBlock)block).batchEncoder(batchSize);
            case ElementType.LONG -> new MultivalueDedupeLong((LongBlock)block).batchEncoder(batchSize);
            case ElementType.DOUBLE -> new MultivalueDedupeDouble((DoubleBlock)block).batchEncoder(batchSize);
            default -> throw new IllegalArgumentException();
        };
    }

    private MultivalueDedupe() {
    }

    private record EvaluatorFactory(EvalOperator.ExpressionEvaluator.Factory field, BiFunction<BlockFactory, Block, Block> dedupe) implements EvalOperator.ExpressionEvaluator.Factory
    {
        @Override
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new Evaluator(context.blockFactory(), this.field.get(context), this.dedupe);
        }

        @Override
        public String toString() {
            return "MvDedupe[field=" + String.valueOf(this.field) + "]";
        }
    }

    private static class Evaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Evaluator.class);
        private final BlockFactory blockFactory;
        private final EvalOperator.ExpressionEvaluator field;
        private final BiFunction<BlockFactory, Block, Block> dedupe;

        protected Evaluator(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator field, BiFunction<BlockFactory, Block, Block> dedupe) {
            this.blockFactory = blockFactory;
            this.field = field;
            this.dedupe = dedupe;
        }

        @Override
        public Block eval(Page page) {
            try (Block block = this.field.eval(page);){
                Block block2 = this.dedupe.apply(this.blockFactory, block);
                return block2;
            }
        }

        public String toString() {
            return "MvDedupe[field=" + String.valueOf(this.field) + "]";
        }

        @Override
        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
        }

        public void close() {
            this.field.close();
        }
    }

    public record HashResult(IntBlock ords, boolean sawNull) {
    }
}

