/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.lookup;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class EnrichResultBuilderForInt
extends EnrichResultBuilder {
    private ObjectArray<int[]> cells;

    EnrichResultBuilderForInt(BlockFactory blockFactory, int channel) {
        super(blockFactory, channel);
        this.cells = blockFactory.bigArrays().newObjectArray(1L);
    }

    @Override
    void addInputPage(IntVector positions, Page page) {
        IntBlock block = (IntBlock)page.getBlock(this.channel);
        for (int i = 0; i < positions.getPositionCount(); ++i) {
            int valueCount = block.getValueCount(i);
            if (valueCount == 0) continue;
            int cellPosition = positions.getInt(i);
            this.cells = this.blockFactory.bigArrays().grow(this.cells, (long)(cellPosition + 1));
            int[] oldCell = (int[])this.cells.get((long)cellPosition);
            int[] newCell = this.extendCell(oldCell, valueCount);
            this.cells.set((long)cellPosition, (Object)newCell);
            int dstIndex = oldCell != null ? oldCell.length : 0;
            this.adjustBreaker(RamUsageEstimator.sizeOf((int[])newCell) - (oldCell != null ? RamUsageEstimator.sizeOf((int[])oldCell) : 0L));
            int firstValueIndex = block.getFirstValueIndex(i);
            for (int v = 0; v < valueCount; ++v) {
                newCell[dstIndex + v] = block.getInt(firstValueIndex + v);
            }
        }
    }

    private int[] extendCell(int[] oldCell, int newValueCount) {
        if (oldCell == null) {
            return new int[newValueCount];
        }
        return Arrays.copyOf(oldCell, oldCell.length + newValueCount);
    }

    private int[] combineCell(int[] first, int[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int[] result = new int[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private void appendGroupToBlockBuilder(IntBlock.Builder builder, int[] group) {
        if (group == null) {
            builder.appendNull();
        } else if (group.length == 1) {
            builder.appendInt(group[0]);
        } else {
            builder.beginPositionEntry();
            for (int v : group) {
                builder.appendInt(v);
            }
            builder.endPositionEntry();
        }
    }

    private int[] getCellOrNull(int position) {
        return (long)position < this.cells.size() ? (int[])this.cells.get((long)position) : null;
    }

    private Block buildWithSelected(IntBlock selected) {
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(selected.getPositionCount());){
            block9: for (int i = 0; i < selected.getPositionCount(); ++i) {
                int selectedCount = selected.getValueCount(i);
                switch (selectedCount) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        int groupId = selected.getInt(selected.getFirstValueIndex(i));
                        this.appendGroupToBlockBuilder(builder, this.getCellOrNull(groupId));
                        continue block9;
                    }
                    default: {
                        int firstValueIndex = selected.getFirstValueIndex(i);
                        int[] cell = this.getCellOrNull(selected.getInt(firstValueIndex));
                        for (int p = 1; p < selectedCount; ++p) {
                            int groupId = selected.getInt(firstValueIndex + p);
                            cell = this.combineCell(cell, this.getCellOrNull(groupId));
                        }
                        this.appendGroupToBlockBuilder(builder, cell);
                    }
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private Block buildWithSelected(IntVector selected) {
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                this.appendGroupToBlockBuilder(builder, this.getCellOrNull(selected.getInt(i)));
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    @Override
    Block build(IntBlock selected) {
        IntVector vector = selected.asVector();
        if (vector != null) {
            return this.buildWithSelected(vector);
        }
        return this.buildWithSelected(selected);
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.cells, () -> super.close()});
    }
}

