/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.elasticsearch.compute.data.AbstractVectorBuilder;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntVector;

final class IntVectorBuilder
extends AbstractVectorBuilder
implements IntVector.Builder {
    private int[] values;

    IntVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker(initialSize);
        this.values = new int[Math.max(estimatedSize, 2)];
    }

    @Override
    public IntVectorBuilder appendInt(int value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        ++this.valueCount;
        return this;
    }

    @Override
    protected int elementSize() {
        return 4;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public IntVector build() {
        IntVector vector;
        this.finish();
        if (this.valueCount == 1) {
            vector = this.blockFactory.newConstantIntBlockWith(this.values[0], 1, this.estimatedBytes).asVector();
        } else {
            if (this.values.length - this.valueCount > 1024 || this.valueCount < this.values.length / 2) {
                this.values = Arrays.copyOf(this.values, this.valueCount);
            }
            vector = this.blockFactory.newIntArrayVector(this.values, this.valueCount, this.estimatedBytes);
        }
        this.built();
        return vector;
    }
}

