/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBigArrayBlock;
import org.elasticsearch.compute.data.DoubleBigArrayVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;

final class DoubleBlockBuilder
extends AbstractBlockBuilder
implements DoubleBlock.Builder {
    private double[] values;

    DoubleBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + initialSize * this.elementSize());
        this.values = new double[initialSize];
    }

    @Override
    public DoubleBlockBuilder appendDouble(double value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        this.hasNonNullValue = true;
        ++this.valueCount;
        this.updatePosition();
        return this;
    }

    @Override
    protected int elementSize() {
        return 8;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public DoubleBlockBuilder appendNull() {
        super.appendNull();
        return this;
    }

    @Override
    public DoubleBlockBuilder beginPositionEntry() {
        super.beginPositionEntry();
        return this;
    }

    @Override
    public DoubleBlockBuilder endPositionEntry() {
        super.endPositionEntry();
        return this;
    }

    @Override
    public DoubleBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int p = beginInclusive; p < endExclusive; ++p) {
                this.appendNull();
            }
            return this;
        }
        return this.copyFrom((DoubleBlock)block, beginInclusive, endExclusive);
    }

    @Override
    public DoubleBlockBuilder copyFrom(DoubleBlock block, int beginInclusive, int endExclusive) {
        if (endExclusive > block.getPositionCount()) {
            throw new IllegalArgumentException("can't copy past the end [" + endExclusive + " > " + block.getPositionCount() + "]");
        }
        DoubleVector vector = block.asVector();
        if (vector != null) {
            this.copyFromVector(vector, beginInclusive, endExclusive);
        } else {
            this.copyFromBlock(block, beginInclusive, endExclusive);
        }
        return this;
    }

    private void copyFromBlock(DoubleBlock block, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.copyFrom(block, p);
        }
    }

    private void copyFromVector(DoubleVector vector, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.appendDouble(vector.getDouble(p));
        }
    }

    @Override
    public DoubleBlockBuilder copyFrom(DoubleBlock block, int position) {
        if (block.isNull(position)) {
            this.appendNull();
            return this;
        }
        int count = block.getValueCount(position);
        int i = block.getFirstValueIndex(position);
        if (count == 1) {
            this.appendDouble(block.getDouble(i++));
            return this;
        }
        this.beginPositionEntry();
        for (int v = 0; v < count; ++v) {
            this.appendDouble(block.getDouble(i++));
        }
        this.endPositionEntry();
        return this;
    }

    @Override
    public DoubleBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.mvOrdering = mvOrdering;
        return this;
    }

    private DoubleBlock buildBigArraysBlock() {
        DoubleArray array = this.blockFactory.bigArrays().newDoubleArray((long)this.valueCount, false);
        for (int i = 0; i < this.valueCount; ++i) {
            array.set((long)i, this.values[i]);
        }
        DoubleBlock theBlock = this.isDense() && this.singleValued() ? new DoubleBigArrayVector(array, this.positionCount, this.blockFactory).asBlock() : new DoubleBigArrayBlock(array, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.blockFactory);
        this.blockFactory.adjustBreaker(theBlock.ramBytesUsed() - this.estimatedBytes - array.ramBytesUsed());
        return theBlock;
    }

    @Override
    public DoubleBlock build() {
        try {
            this.finish();
            DoubleBlock theBlock = this.hasNonNullValue && this.positionCount == 1 && this.valueCount == 1 ? this.blockFactory.newConstantDoubleBlockWith(this.values[0], 1, this.estimatedBytes) : (this.estimatedBytes > this.blockFactory.maxPrimitiveArrayBytes() ? this.buildBigArraysBlock() : (this.isDense() && this.singleValued() ? this.blockFactory.newDoubleArrayVector(this.values, this.positionCount, this.estimatedBytes).asBlock() : this.blockFactory.newDoubleArrayBlock(this.values, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.estimatedBytes)));
            this.built();
            return theBlock;
        }
        catch (CircuitBreakingException e) {
            this.close();
            throw e;
        }
    }
}

