/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.AddPage;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRefBlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

final class BytesRef2BlockHash
extends BlockHash {
    private final int emitBatchSize;
    private final int channel1;
    private final int channel2;
    private final BytesRefBlockHash hash1;
    private final BytesRefBlockHash hash2;
    private final LongHash finalHash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BytesRef2BlockHash(BlockFactory blockFactory, int channel1, int channel2, int emitBatchSize) {
        super(blockFactory);
        this.emitBatchSize = emitBatchSize;
        this.channel1 = channel1;
        this.channel2 = channel2;
        boolean success = false;
        try {
            this.hash1 = new BytesRefBlockHash(channel1, blockFactory);
            this.hash2 = new BytesRefBlockHash(channel2, blockFactory);
            this.finalHash = new LongHash(1L, blockFactory.bigArrays());
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.hash1, this.hash2, this.finalHash});
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        BytesRefBlock b1 = (BytesRefBlock)page.getBlock(this.channel1);
        BytesRefBlock b2 = (BytesRefBlock)page.getBlock(this.channel2);
        BytesRefVector v1 = b1.asVector();
        BytesRefVector v2 = b2.asVector();
        if (v1 != null && v2 != null) {
            this.addVectors(v1, v2, addInput);
        } else {
            try (IntBlock k1 = this.hash1.add(b1);
                 IntBlock k2 = this.hash2.add(b2);
                 AddWork work = new AddWork(k1, k2, addInput);){
                work.add();
            }
        }
    }

    private void addVectors(BytesRefVector v1, BytesRefVector v2, GroupingAggregatorFunction.AddInput addInput) {
        int positionCount = v1.getPositionCount();
        try (IntVector.FixedBuilder ordsBuilder = this.blockFactory.newIntVectorFixedBuilder(positionCount);){
            try (IntVector k1 = this.hash1.add(v1);
                 IntVector k2 = this.hash2.add(v2);){
                for (int p = 0; p < positionCount; ++p) {
                    long ord = this.ord(k1.getInt(p), k2.getInt(p));
                    ordsBuilder.appendInt(p, Math.toIntExact(ord));
                }
            }
            try (IntVector ords = ordsBuilder.build();){
                addInput.add(0, ords);
            }
        }
    }

    private long ord(int k1, int k2) {
        return BytesRef2BlockHash.hashOrdToGroup(this.finalHash.add((long)k2 << 32 | (long)k1));
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block[] getKeys() {
        int positions = (int)this.finalHash.size();
        BytesRef scratch = new BytesRef();
        Releasable[] outputBlocks = new BytesRefBlock[2];
        try {
            int i;
            try (BytesRefBlock.Builder b1 = this.blockFactory.newBytesRefBlockBuilder(positions);){
                for (i = 0; i < positions; ++i) {
                    int k1 = (int)(this.finalHash.get((long)i) & 0xFFFFFFFFL);
                    if (k1 == 0) {
                        b1.appendNull();
                        continue;
                    }
                    b1.appendBytesRef(this.hash1.hash.get((long)(k1 - 1), scratch));
                }
                outputBlocks[0] = b1.build();
            }
            try (BytesRefBlock.Builder b2 = this.blockFactory.newBytesRefBlockBuilder(positions);){
                for (i = 0; i < positions; ++i) {
                    int k2 = (int)(this.finalHash.get((long)i) >>> 32);
                    if (k2 == 0) {
                        b2.appendNull();
                        continue;
                    }
                    b2.appendBytesRef(this.hash2.hash.get((long)(k2 - 1), scratch));
                }
                outputBlocks[1] = b2.build();
            }
            Releasable[] releasableArray = outputBlocks;
            return releasableArray;
        }
        finally {
            if (outputBlocks[outputBlocks.length - 1] == null) {
                Releasables.close((Releasable[])outputBlocks);
            }
        }
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(0, Math.toIntExact(this.finalHash.size())).seenGroupIds(bigArrays);
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(0, Math.toIntExact(this.finalHash.size()), this.blockFactory);
    }

    public String toString() {
        return String.format(Locale.ROOT, "BytesRef2BlockHash{keys=[channel1=%d, channel2=%d], entries=%d}", this.channel1, this.channel2, this.finalHash.size());
    }

    private class AddWork
    extends AddPage {
        final IntBlock b1;
        final IntBlock b2;

        AddWork(IntBlock b1, IntBlock b2, GroupingAggregatorFunction.AddInput addInput) {
            super(BytesRef2BlockHash.this.blockFactory, BytesRef2BlockHash.this.emitBatchSize, addInput);
            this.b1 = b1;
            this.b2 = b2;
        }

        void add() {
            int positionCount = this.b1.getPositionCount();
            for (int i = 0; i < positionCount; ++i) {
                int v1 = this.b1.getValueCount(i);
                int v2 = this.b2.getValueCount(i);
                int first1 = this.b1.getFirstValueIndex(i);
                int first2 = this.b2.getFirstValueIndex(i);
                if (v1 == 1 && v2 == 1) {
                    long ord = BytesRef2BlockHash.this.ord(this.b1.getInt(first1), this.b2.getInt(first2));
                    this.appendOrdSv(i, Math.toIntExact(ord));
                    continue;
                }
                for (int i1 = 0; i1 < v1; ++i1) {
                    int k1 = this.b1.getInt(first1 + i1);
                    for (int i2 = 0; i2 < v2; ++i2) {
                        int k2 = this.b2.getInt(first2 + i2);
                        long ord = BytesRef2BlockHash.this.ord(k1, k2);
                        this.appendOrdInMv(i, Math.toIntExact(ord));
                    }
                }
                this.finishMv();
            }
            this.flushRemaining();
        }
    }
}

