/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.StdDevDoubleAggregator;
import org.elasticsearch.compute.aggregation.StdDevStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class StdDevDoubleAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("mean", ElementType.DOUBLE), new IntermediateStateDesc("m2", ElementType.DOUBLE), new IntermediateStateDesc("count", ElementType.LONG));
    private final DriverContext driverContext;
    private final StdDevStates.SingleState state;
    private final List<Integer> channels;

    public StdDevDoubleAggregatorFunction(DriverContext driverContext, List<Integer> channels, StdDevStates.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static StdDevDoubleAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new StdDevDoubleAggregatorFunction(driverContext, channels, StdDevDoubleAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.allFalse()) {
            return;
        }
        if (mask.allTrue()) {
            DoubleBlock block = (DoubleBlock)page.getBlock(this.channels.get(0));
            DoubleVector vector = block.asVector();
            if (vector != null) {
                this.addRawVector(vector);
            } else {
                this.addRawBlock(block);
            }
            return;
        }
        DoubleBlock block = (DoubleBlock)page.getBlock(this.channels.get(0));
        DoubleVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector, mask);
        } else {
            this.addRawBlock(block, mask);
        }
    }

    private void addRawVector(DoubleVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            StdDevDoubleAggregator.combine(this.state, vector.getDouble(i));
        }
    }

    private void addRawVector(DoubleVector vector, BooleanVector mask) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            if (!mask.getBoolean(i)) continue;
            StdDevDoubleAggregator.combine(this.state, vector.getDouble(i));
        }
    }

    private void addRawBlock(DoubleBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                StdDevDoubleAggregator.combine(this.state, block.getDouble(i));
            }
        }
    }

    private void addRawBlock(DoubleBlock block, BooleanVector mask) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                StdDevDoubleAggregator.combine(this.state, block.getDouble(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + StdDevDoubleAggregatorFunction.intermediateStateDesc().size());
        Object meanUncast = page.getBlock(this.channels.get(0));
        if (meanUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector mean = ((DoubleBlock)meanUncast).asVector();
        assert (mean.getPositionCount() == 1);
        Object m2Uncast = page.getBlock(this.channels.get(1));
        if (m2Uncast.areAllValuesNull()) {
            return;
        }
        DoubleVector m2 = ((DoubleBlock)m2Uncast).asVector();
        assert (m2.getPositionCount() == 1);
        Object countUncast = page.getBlock(this.channels.get(2));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (count.getPositionCount() == 1);
        StdDevDoubleAggregator.combineIntermediate(this.state, mean.getDouble(0), m2.getDouble(0), count.getLong(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = StdDevDoubleAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

