/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SampleLongAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SampleLongAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("sample", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final SampleLongAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;

    public SampleLongAggregatorFunction(DriverContext driverContext, List<Integer> channels, SampleLongAggregator.SingleState state, int limit) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
    }

    public static SampleLongAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit) {
        return new SampleLongAggregatorFunction(driverContext, channels, SampleLongAggregator.initSingle(driverContext.bigArrays(), limit), limit);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.allFalse()) {
            return;
        }
        if (mask.allTrue()) {
            LongBlock block = (LongBlock)page.getBlock(this.channels.get(0));
            LongVector vector = block.asVector();
            if (vector != null) {
                this.addRawVector(vector);
            } else {
                this.addRawBlock(block);
            }
            return;
        }
        LongBlock block = (LongBlock)page.getBlock(this.channels.get(0));
        LongVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector, mask);
        } else {
            this.addRawBlock(block, mask);
        }
    }

    private void addRawVector(LongVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            SampleLongAggregator.combine(this.state, vector.getLong(i));
        }
    }

    private void addRawVector(LongVector vector, BooleanVector mask) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            if (!mask.getBoolean(i)) continue;
            SampleLongAggregator.combine(this.state, vector.getLong(i));
        }
    }

    private void addRawBlock(LongBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                SampleLongAggregator.combine(this.state, block.getLong(i));
            }
        }
    }

    private void addRawBlock(LongBlock block, BooleanVector mask) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                SampleLongAggregator.combine(this.state, block.getLong(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SampleLongAggregatorFunction.intermediateStateDesc().size());
        Object sampleUncast = page.getBlock(this.channels.get(0));
        if (sampleUncast.areAllValuesNull()) {
            return;
        }
        BytesRefBlock sample = (BytesRefBlock)sampleUncast;
        assert (sample.getPositionCount() == 1);
        BytesRef scratch = new BytesRef();
        SampleLongAggregator.combineIntermediate(this.state, sample);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SampleLongAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

