/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.GetWatcherSettingsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.UpdateWatcherSettingsAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportUpdateWatcherSettingsAction;

public class TransportGetWatcherSettingsAction
extends TransportLocalProjectMetadataAction<GetWatcherSettingsAction.Request, GetWatcherSettingsAction.Response> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetWatcherSettingsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ProjectResolver projectResolver) {
        super("cluster:admin/xpack/watcher/settings/get", actionFilters, transportService.getTaskManager(), clusterService, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetWatcherSettingsAction.Request::readFrom, (request, channel, task) -> this.executeDirect(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel)));
    }

    protected void localClusterStateOperation(Task task, GetWatcherSettingsAction.Request request, ProjectState state, ActionListener<GetWatcherSettingsAction.Response> listener) {
        ((CancellableTask)task).ensureNotCancelled();
        IndexMetadata metadata = state.metadata().index(".watches");
        if (metadata == null) {
            listener.onResponse((Object)new GetWatcherSettingsAction.Response(Settings.EMPTY));
        } else {
            listener.onResponse((Object)new GetWatcherSettingsAction.Response(TransportGetWatcherSettingsAction.filterSettableSettings(metadata.getSettings())));
        }
    }

    private static Settings filterSettableSettings(Settings settings) {
        Settings.Builder builder = Settings.builder();
        settings.keySet().stream().filter(setting -> (UpdateWatcherSettingsAction.ALLOWED_SETTING_KEYS.contains(setting) || UpdateWatcherSettingsAction.ALLOWED_SETTINGS_PREFIXES.stream().anyMatch(prefix -> setting.startsWith(prefix + "."))) && !UpdateWatcherSettingsAction.EXPLICITLY_DENIED_SETTINGS.contains(setting)).forEach(setting -> builder.put(setting, settings.get(setting)));
        return builder.build();
    }

    protected ClusterBlockException checkBlock(GetWatcherSettingsAction.Request request, ProjectState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        if (globalBlock != null) {
            return globalBlock;
        }
        return state.blocks().indicesBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state.metadata(), TransportUpdateWatcherSettingsAction.WATCHER_INDEX_REQUEST));
    }
}

