/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.geoip.Database;
import org.elasticsearch.ingest.geoip.IpDataLookup;
import org.elasticsearch.ingest.geoip.IpinfoIpDataLookups;
import org.elasticsearch.ingest.geoip.MaxmindIpDataLookups;

final class IpDataLookupFactories {
    private IpDataLookupFactories() {
    }

    @Nullable
    static Database getDatabase(String databaseType) {
        Database database = null;
        if (Strings.hasText((String)databaseType)) {
            String databaseTypeLowerCase = databaseType.toLowerCase(Locale.ROOT);
            database = databaseTypeLowerCase.startsWith("ipinfo") ? IpinfoIpDataLookups.getIpinfoDatabase(databaseTypeLowerCase) : MaxmindIpDataLookups.getMaxmindDatabase(databaseType);
        }
        return database;
    }

    static IpDataLookupFactory get(String databaseType, String databaseFile) {
        Database database = IpDataLookupFactories.getDatabase(databaseType);
        if (database == null) {
            throw new IllegalArgumentException("Unsupported database type [" + databaseType + "] for file [" + databaseFile + "]");
        }
        String databaseTypeLowerCase = databaseType.toLowerCase(Locale.ROOT);
        Function<Set<Database.Property>, IpDataLookup> factoryMethod = databaseTypeLowerCase.startsWith("ipinfo") ? IpinfoIpDataLookups.getIpinfoLookup(database) : MaxmindIpDataLookups.getMaxmindLookup(database);
        if (factoryMethod == null) {
            throw new IllegalArgumentException("Unsupported database type [" + databaseType + "] for file [" + databaseFile + "]");
        }
        return properties -> (IpDataLookup)factoryMethod.apply(database.parseProperties(properties));
    }

    static interface IpDataLookupFactory {
        public IpDataLookup create(List<String> var1);
    }
}

