/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.math;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.eql.expression.function.scalar.math.ToNumberFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.math.ToNumberFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public final class ToNumber
extends ScalarFunction
implements OptionalArgument {
    private final Expression value;
    private final Expression base;

    public ToNumber(Source source, Expression value, Expression base) {
        super(source, Arrays.asList(value, base != null ? base : new Literal(source, null, DataTypes.NULL)));
        this.value = value;
        this.base = (Expression)this.arguments().get(1);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution valueResolution = TypeResolutions.isStringAndExact((Expression)this.value, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (valueResolution.unresolved()) {
            return valueResolution;
        }
        return TypeResolutions.isInteger((Expression)this.base, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    protected Pipe makePipe() {
        return new ToNumberFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.value), Expressions.pipe((Expression)this.base));
    }

    public boolean foldable() {
        return this.value.foldable() && this.base.foldable();
    }

    public Object fold() {
        return ToNumberFunctionProcessor.doProcess(this.value.fold(), this.base.fold());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToNumber::new, (Object)this.value, (Object)this.base);
    }

    public ScriptTemplate asScript() {
        ScriptTemplate valueScript = this.asScript(this.value);
        ScriptTemplate baseScript = this.asScript(this.base);
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{eql}.%s(%s,%s)"), "number", valueScript.template(), baseScript.template()), ParamsBuilder.paramsBuilder().script(valueScript.params()).script(baseScript.params()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToNumber(this.source(), newChildren.get(0), newChildren.get(1));
    }
}

