/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.CollectionUtils;

public class SequenceKey
implements Accountable,
Comparable<SequenceKey> {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(SequenceKey.class);
    public static final SequenceKey NONE = new SequenceKey(new Object[0]);
    private final Object[] keys;
    private final int hashCode;

    public SequenceKey(Object ... keys) {
        this.keys = keys;
        this.hashCode = Objects.hash(keys);
    }

    public List<Object> asList() {
        return this.keys == null ? Collections.emptyList() : Arrays.asList(this.keys);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOfObject((Object)this.keys);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceKey other = (SequenceKey)obj;
        return Arrays.equals(this.keys, other.keys);
    }

    public String toString() {
        return CollectionUtils.isEmpty((Object[])this.keys) ? "NONE" : Arrays.toString(this.keys);
    }

    @Override
    public int compareTo(SequenceKey other) {
        int length = this.keys.length;
        int otherLength = other.keys.length;
        for (int i = 0; i < length && i < otherLength; ++i) {
            Comparable key;
            int result;
            Object object = this.keys[i];
            if (!(object instanceof Comparable) || (result = (key = (Comparable)object).compareTo(other.keys[i])) == 0) continue;
            return result;
        }
        return length - otherLength;
    }
}

