/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.payload;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.execution.payload.AbstractPayload;
import org.elasticsearch.xpack.eql.session.Payload;

public class EventPayload
extends AbstractPayload {
    private final List<EqlSearchResponse.Event> values;

    public EventPayload(SearchResponse response) {
        super(response.isTimedOut(), response.getTook(), response.getShardFailures());
        SearchHits hits = response.getHits();
        this.values = new ArrayList<EqlSearchResponse.Event>(hits.getHits().length);
        for (SearchHit hit : hits) {
            this.values.add(new EqlSearchResponse.Event(hit.asUnpooled()));
        }
    }

    @Override
    public Payload.Type resultType() {
        return Payload.Type.EVENT;
    }

    public List<EqlSearchResponse.Event> values() {
        return this.values;
    }
}

