/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.assembler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.assembler.BoxedQueryRequest;
import org.elasticsearch.xpack.eql.execution.assembler.Executable;
import org.elasticsearch.xpack.eql.execution.assembler.SampleCriterion;
import org.elasticsearch.xpack.eql.execution.assembler.SampleQueryRequest;
import org.elasticsearch.xpack.eql.execution.assembler.SequenceCriterion;
import org.elasticsearch.xpack.eql.execution.sample.SampleIterator;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.execution.search.PITAwareQueryClient;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.execution.search.extractor.CompositeKeyExtractor;
import org.elasticsearch.xpack.eql.execution.search.extractor.FieldHitExtractor;
import org.elasticsearch.xpack.eql.execution.search.extractor.ImplicitTiebreakerHitExtractor;
import org.elasticsearch.xpack.eql.execution.search.extractor.TimestampFieldHitExtractor;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceMatcher;
import org.elasticsearch.xpack.eql.execution.sequence.TumblingWindow;
import org.elasticsearch.xpack.eql.expression.OptionalResolvedAttribute;
import org.elasticsearch.xpack.eql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.querydsl.container.FieldExtractorRegistry;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.execution.search.extractor.AbstractFieldHitExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.ComputingExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class ExecutionManager {
    private static final int SAMPLE_MAX_PAGE_SIZE = 1000;
    private final EqlSession session;
    private final EqlConfiguration cfg;

    public ExecutionManager(EqlSession eqlSession) {
        this.session = eqlSession;
        this.cfg = eqlSession.configuration();
    }

    public Executable assemble(List<List<Attribute>> listOfKeys, List<PhysicalPlan> plans, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction, TimeValue maxSpan, Limit limit, boolean[] missing) {
        int i;
        FieldExtractorRegistry extractorRegistry = new FieldExtractorRegistry();
        boolean descending = direction == Order.OrderDirection.DESC;
        HitExtractor tsExtractor = ExecutionManager.timestampExtractor(this.hitExtractor((Expression)timestamp, extractorRegistry));
        HitExtractor tbExtractor = Expressions.isPresent((NamedExpression)tiebreaker) ? this.hitExtractor((Expression)tiebreaker, extractorRegistry) : null;
        HitExtractor itbExtractor = ImplicitTiebreakerHitExtractor.INSTANCE;
        String timestampName = Expressions.name((Expression)timestamp);
        ArrayList<SequenceCriterion> criteria = new ArrayList<SequenceCriterion>(plans.size() - 1);
        int firstPositive = -1;
        for (i = 0; i < missing.length; ++i) {
            if (missing[i]) continue;
            firstPositive = i;
            break;
        }
        for (i = 0; i < plans.size(); ++i) {
            PhysicalPlan query;
            List<Attribute> keys = listOfKeys.get(i);
            List<HitExtractor> keyExtractors = this.hitExtractors(keys, extractorRegistry);
            List<Object> keyFields = new ArrayList<String>(keyExtractors.size());
            LinkedHashSet optionalKeys = Sets.newLinkedHashSetWithExpectedSize((int)CollectionUtils.mapSize((int)keyExtractors.size()));
            for (int j = 0; j < keyExtractors.size(); ++j) {
                HitExtractor extractor = keyExtractors.get(j);
                if (extractor instanceof AbstractFieldHitExtractor) {
                    AbstractFieldHitExtractor hitExtractor = (AbstractFieldHitExtractor)extractor;
                    boolean isOptional = keys.get(j) instanceof OptionalResolvedAttribute;
                    if (hitExtractor.hitName() == null) {
                        String fieldName = hitExtractor.fieldName();
                        keyFields.add(fieldName);
                        if (!isOptional) continue;
                        optionalKeys.add(fieldName);
                        continue;
                    }
                    keyFields = Collections.emptyList();
                    break;
                }
                if (!(extractor instanceof ComputingExtractor)) continue;
                ComputingExtractor computingExtractor = (ComputingExtractor)extractor;
                keyFields.add(computingExtractor.hitName());
            }
            if ((query = plans.get(i)) instanceof EsQueryExec) {
                EsQueryExec esQueryExec = (EsQueryExec)query;
                SearchSourceBuilder source = esQueryExec.source(this.session, false);
                QueryRequest original = () -> source;
                BoxedQueryRequest boxedRequest = new BoxedQueryRequest(original, timestampName, keyFields, optionalKeys);
                SequenceCriterion criterion = new SequenceCriterion(i, boxedRequest, keyExtractors, tsExtractor, tbExtractor, itbExtractor, i == firstPositive && descending, missing[i]);
                criteria.add(criterion);
                continue;
            }
            if (i != plans.size() - 1) {
                throw new EqlIllegalArgumentException("Expected a query but got [{}]", query.getClass());
            }
            criteria.add(null);
        }
        int completionStage = criteria.size() - 1;
        SequenceMatcher matcher = new SequenceMatcher(completionStage, descending, maxSpan, limit, ExecutionManager.toMissing(criteria.subList(0, criteria.size() - 1)), this.session.circuitBreaker());
        TumblingWindow w = new TumblingWindow(new PITAwareQueryClient(this.session), criteria.subList(0, completionStage), (SequenceCriterion)criteria.get(completionStage), matcher, listOfKeys, this.cfg.allowPartialSearchResults(), this.cfg.allowPartialSequenceResults());
        return w;
    }

    public Executable assemble(List<List<Attribute>> listOfKeys, List<PhysicalPlan> plans, Limit limit) {
        if (this.cfg.fetchSize() > 1000) {
            throw new InvalidArgumentException("Fetch size cannot be greater than [{}]", new Object[]{1000});
        }
        FieldExtractorRegistry extractorRegistry = new FieldExtractorRegistry();
        ArrayList<SampleCriterion> criteria = new ArrayList<SampleCriterion>(plans.size() - 1);
        for (int i = 0; i < plans.size(); ++i) {
            List<Attribute> keys = listOfKeys.get(i);
            List<BucketExtractor> keyExtractors = ExecutionManager.compositeKeyExtractors(keys, extractorRegistry);
            ArrayList<String> keyFields = new ArrayList<String>(keyExtractors.size());
            for (int j = 0; j < keyExtractors.size(); ++j) {
                BucketExtractor extractor = keyExtractors.get(j);
                if (extractor instanceof CompositeKeyExtractor) {
                    CompositeKeyExtractor e = (CompositeKeyExtractor)extractor;
                    keyFields.add(e.key());
                    continue;
                }
                if (!(extractor instanceof ComputingExtractor)) continue;
                ComputingExtractor ce = (ComputingExtractor)extractor;
                keyFields.add(ce.hitName());
            }
            PhysicalPlan query = plans.get(i);
            if (!(query instanceof EsQueryExec)) {
                throw new EqlIllegalArgumentException("Expected a query but got [{}]", query.getClass());
            }
            EsQueryExec esQueryExec = (EsQueryExec)query;
            SampleQueryRequest firstQuery = new SampleQueryRequest(() -> RuntimeUtils.wrapAsFilter(esQueryExec.source(this.session, false)), keyFields, keys, this.cfg.fetchSize());
            SampleQueryRequest midQuery = new SampleQueryRequest(() -> RuntimeUtils.wrapAsFilter(esQueryExec.source(this.session, false)), keyFields, keys, this.cfg.fetchSize());
            SampleQueryRequest finalQuery = new SampleQueryRequest(() -> RuntimeUtils.wrapAsFilter(esQueryExec.source(this.session, false)), keyFields, keys, this.cfg.fetchSize());
            firstQuery.withCompositeAggregation();
            midQuery.withCompositeAggregation();
            criteria.add(new SampleCriterion(firstQuery, midQuery, finalQuery, keyFields, keyExtractors));
        }
        return new SampleIterator(new PITAwareQueryClient(this.session), criteria, this.cfg.fetchSize(), limit, this.session.circuitBreaker(), this.cfg.maxSamplesPerKey(), this.cfg.allowPartialSearchResults());
    }

    private static boolean[] toMissing(List<SequenceCriterion> criteria) {
        boolean[] result = new boolean[criteria.size()];
        for (int i = 0; i < criteria.size(); ++i) {
            result[i] = criteria.get(i).missing();
        }
        return result;
    }

    private static HitExtractor timestampExtractor(HitExtractor hitExtractor) {
        if (hitExtractor instanceof FieldHitExtractor) {
            FieldHitExtractor fe = (FieldHitExtractor)hitExtractor;
            return fe instanceof TimestampFieldHitExtractor ? hitExtractor : new TimestampFieldHitExtractor(fe);
        }
        throw new EqlIllegalArgumentException("Unexpected extractor [{}]", hitExtractor);
    }

    private HitExtractor hitExtractor(Expression exp, FieldExtractorRegistry registry) {
        return RuntimeUtils.createExtractor(registry.fieldExtraction(exp), this.cfg);
    }

    private List<HitExtractor> hitExtractors(List<? extends Expression> exps, FieldExtractorRegistry registry) {
        ArrayList<HitExtractor> extractors = new ArrayList<HitExtractor>(exps.size());
        for (Expression expression : exps) {
            extractors.add(this.hitExtractor(expression, registry));
        }
        return extractors;
    }

    private static List<BucketExtractor> compositeKeyExtractors(List<? extends Expression> exps, FieldExtractorRegistry registry) {
        ArrayList<BucketExtractor> extractors = new ArrayList<BucketExtractor>(exps.size());
        for (Expression expression : exps) {
            extractors.add(RuntimeUtils.createBucketExtractor(registry.compositeKeyExtraction(expression)));
        }
        return extractors;
    }
}

