/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.RemoteClusterAwareRequest;
import org.elasticsearch.xpack.ccr.Ccr;

public class ClearCcrRestoreSessionRequest
extends LegacyActionRequest
implements RemoteClusterAwareRequest,
IndicesRequest {
    private DiscoveryNode node;
    private final String sessionUUID;
    private final ShardId shardId;

    ClearCcrRestoreSessionRequest(StreamInput in) throws IOException {
        super(in);
        this.sessionUUID = in.readString();
        this.shardId = in.getTransportVersion().onOrAfter((VersionId)Ccr.TRANSPORT_VERSION_ACTION_WITH_SHARD_ID) ? new ShardId(in) : null;
    }

    public ClearCcrRestoreSessionRequest(String sessionUUID, DiscoveryNode node, ShardId shardId) {
        this.sessionUUID = sessionUUID;
        this.node = node;
        this.shardId = shardId;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.sessionUUID);
        if (out.getTransportVersion().onOrAfter((VersionId)Ccr.TRANSPORT_VERSION_ACTION_WITH_SHARD_ID)) {
            this.shardId.writeTo(out);
        }
    }

    String getSessionUUID() {
        return this.sessionUUID;
    }

    ShardId getShardId() {
        return this.shardId;
    }

    public DiscoveryNode getPreferredTargetNode() {
        return this.node;
    }

    public String[] indices() {
        if (this.shardId == null) {
            return null;
        }
        return new String[]{this.shardId.getIndexName()};
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }
}

