/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadProjectAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.GetAutoFollowPatternAction;

public class TransportGetAutoFollowPatternAction
extends TransportMasterNodeReadProjectAction<GetAutoFollowPatternAction.Request, GetAutoFollowPatternAction.Response> {
    @Inject
    public TransportGetAutoFollowPatternAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super("cluster:admin/xpack/ccr/auto_follow_pattern/get", transportService, clusterService, threadPool, actionFilters, GetAutoFollowPatternAction.Request::new, projectResolver, GetAutoFollowPatternAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, GetAutoFollowPatternAction.Request request, ProjectState state, ActionListener<GetAutoFollowPatternAction.Response> listener) throws Exception {
        Map<String, AutoFollowMetadata.AutoFollowPattern> autoFollowPatterns = TransportGetAutoFollowPatternAction.getAutoFollowPattern(state.metadata(), request.getName());
        listener.onResponse((Object)new GetAutoFollowPatternAction.Response(autoFollowPatterns));
    }

    protected ClusterBlockException checkBlock(GetAutoFollowPatternAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    static Map<String, AutoFollowMetadata.AutoFollowPattern> getAutoFollowPattern(ProjectMetadata project, String name) {
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)project.custom("ccr_auto_follow");
        if (autoFollowMetadata == null) {
            if (name == null) {
                return Collections.emptyMap();
            }
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{name});
        }
        if (name == null) {
            return autoFollowMetadata.getPatterns();
        }
        AutoFollowMetadata.AutoFollowPattern autoFollowPattern = (AutoFollowMetadata.AutoFollowPattern)autoFollowMetadata.getPatterns().get(name);
        if (autoFollowPattern == null) {
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{name});
        }
        return Collections.singletonMap(name, autoFollowPattern);
    }
}

