/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.utils;

import java.util.Map;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;

public final class SecondaryAuthorizationUtils {
    private SecondaryAuthorizationUtils() {
    }

    public static Map<String, String> getSecurityHeadersPreferringSecondary(ThreadPool threadPool, SecurityContext securityContext, ClusterState clusterState) {
        SetOnce filteredHeadersHolder = new SetOnce();
        SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(securityContext, () -> {
            Map filteredHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)threadPool.getThreadContext(), (ClusterState)clusterState);
            filteredHeadersHolder.set((Object)filteredHeaders);
        });
        return (Map)filteredHeadersHolder.get();
    }

    public static void useSecondaryAuthIfAvailable(SecurityContext securityContext, Runnable runnable) {
        if (securityContext == null) {
            runnable.run();
            return;
        }
        SecondaryAuthentication secondaryAuth = securityContext.getSecondaryAuthentication();
        if (secondaryAuth == null) {
            runnable.run();
            return;
        }
        secondaryAuth.wrap(runnable).run();
    }
}

