/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.script.DoubleFieldScript;

public class DoubleScriptBlockDocValuesReader
extends BlockDocValuesReader {
    private final DoubleFieldScript script;
    private int docId;

    DoubleScriptBlockDocValuesReader(DoubleFieldScript script) {
        this.script = script;
    }

    @Override
    public int docId() {
        return this.docId;
    }

    @Override
    public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
        try (BlockLoader.DoubleBuilder builder = factory.doubles(docs.count() - offset);){
            for (int i = offset; i < docs.count(); ++i) {
                this.read(docs.get(i), builder);
            }
            BlockLoader.Block block = builder.build();
            return block;
        }
    }

    @Override
    public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
        this.docId = docId;
        this.read(docId, (BlockLoader.DoubleBuilder)builder);
    }

    private void read(int docId, BlockLoader.DoubleBuilder builder) {
        this.script.runForDoc(docId);
        switch (this.script.count()) {
            case 0: {
                builder.appendNull();
                break;
            }
            case 1: {
                builder.appendDouble(this.script.values()[0]);
                break;
            }
            default: {
                builder.beginPositionEntry();
                for (int i = 0; i < this.script.count(); ++i) {
                    builder.appendDouble(this.script.values()[i]);
                }
                builder.endPositionEntry();
            }
        }
    }

    @Override
    public String toString() {
        return "ScriptDoubles";
    }

    static class DoubleScriptBlockLoader
    extends BlockDocValuesReader.DocValuesBlockLoader {
        private final DoubleFieldScript.LeafFactory factory;

        DoubleScriptBlockLoader(DoubleFieldScript.LeafFactory factory) {
            this.factory = factory;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.doubles(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            return new DoubleScriptBlockDocValuesReader(this.factory.newInstance(context));
        }
    }
}

